/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.history.xml.enumEventType;
import com.ibm.websphere.product.history.xml.includedEFix;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.history.xml.updateEvent;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMetadataNameValuePair;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.xml.efix.ptf;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class WASMaintenancePackage {
    private WASDirectoryLogger logger;
    private String maintenancePackageID = null;
    private String description = null;
    private String packageFileName = null;
    private String buildDate = null;
    private String action = null;
    private String result = null;
    private String timestamp = null;
    private String logFileName = null;
    private String backupFileName = null;
    private boolean isInstalledAsMaintenance = false;
    private Vector componentUpdateListThisMaintenance = new Vector();
    private String[] aparList = null;
    private Vector nameValuePairParams = new Vector();
    private String packageType = null;
    private int order = 0;
    private String installRoot = null;
    private ptf ptfThis = new ptf();
    private ptfApplied ptfAppliedThis = new ptfApplied();
    private ptfDriver ptfDriverThis = new ptfDriver();
    private includedEFix[] includedEFixList = null;
    private updateEvent updateEventThis = new updateEvent();

    public WASMaintenancePackage(String string, Node node) {
        this.logger = WASDirectoryLogger.getWASDirectoryLogger(string);
        this.logger.entering(this.getClass().getName(), "WASMaintenancePackage");
        this.setInstallRoot(WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, false));
        this.setMaintenancePackageID(SimpleXMLParser.getNodeAttributeValue(node, "name"));
        String string2 = SimpleXMLParser.getNodeAttributeValue(node, "order");
        this.setOrder(Integer.parseInt(string2));
        this.setDefinedParamsForThisNode(node);
        this.setAttributeValuesForThisMaintenancePackage();
        this.setIncludedEFixListFromAPARList();
        this.setPTFForThisMaintenancePackage();
        this.setPTFAppliedForThisMaintenancePackage();
        this.setPTFDriverForThisMaintenancePackage();
        this.logger.exiting(this.getClass().getName(), "WASMaintenancePackage");
    }

    public String getParamValue(String string) {
        for (int i = 0; i < this.nameValuePairParams.size(); ++i) {
            WASMetadataNameValuePair wASMetadataNameValuePair = (WASMetadataNameValuePair)this.nameValuePairParams.elementAt(i);
            if (!wASMetadataNameValuePair.getName().equals(string)) continue;
            return wASMetadataNameValuePair.getValue();
        }
        return null;
    }

    public Vector getParamValues(String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.nameValuePairParams.size(); ++i) {
            WASMetadataNameValuePair wASMetadataNameValuePair = (WASMetadataNameValuePair)this.nameValuePairParams.elementAt(i);
            if (!wASMetadataNameValuePair.getName().equals(string)) continue;
            vector.add(wASMetadataNameValuePair.getValue());
        }
        vector.trimToSize();
        return vector;
    }

    private void setDefinedParamsForThisNode(Node node) {
        this.logger.entering(this.getClass().getName(), "setDefinedParamsForThisNode");
        Vector vector = SimpleXMLParser.getAllNamedChildNodes(node, "param");
        if (vector.size() == 0) {
            this.logger.logThisMessage(Level.FINER, this.getClass().getName(), "setDefinedParamsForThisNode", "There is no parameter nodes in this maintenance package.");
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            String string = SimpleXMLParser.getNodeAttributeValue(node2, "name");
            String string2 = SimpleXMLParser.getNodeAttributeValue(node2, "value");
            this.nameValuePairParams.add(new WASMetadataNameValuePair(string, string2));
        }
        this.logger.exiting(this.getClass().getName(), "setDefinedParamsForThisNode");
    }

    protected void setAttributeValuesForThisMaintenancePackage() {
        this.logger.entering(this.getClass().getName(), "setAttributeValuesForThisMaintenancePackage");
        this.setDescription(this.getParamValue("info"));
        this.setBuildDate(this.getParamValue("builddate"));
        this.setPackageFileName(this.getParamValue("filename"));
        this.setAction(this.getParamValue("action"));
        this.setResult(this.getParamValue("status"));
        this.setTimestamp(this.getParamValue("timestamp"));
        this.setPackageType(this.getParamValue("packagetype"));
        this.setLogFileName(WASDirectoryHelper.getLogDirPath(this.getInstallRoot()), this.getMaintenancePackageID(), this.getAction());
        this.setBackupFileName(WASDirectoryHelper.getBackupDirPath(this.getInstallRoot()), this.getPackageFileName());
        this.setInstallAsMaintenance(Boolean.valueOf(this.getParamValue("wasinstalledasmaintenance")));
        Vector vector = this.getParamValues("apar");
        this.setAparList(vector.toArray(new String[vector.size()]));
        Vector vector2 = this.getParamValues("component");
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.get(i);
            WASComponentUpdate wASComponentUpdate = new WASComponentUpdate(this.getMaintenancePackageID(), string, this.getAction(), "maintenance package", "replace", this.getTimestamp(), this.getResult(), this.getBackupFileName(), this.getLogFileName(), this.getPackageFileName(), this.getInstallRoot());
            this.addComponentUpdateToList(wASComponentUpdate);
        }
        this.logger.exiting(this.getClass().getName(), "setAttributeValuesForThisMaintenancePackage");
    }

    public String[] getAparList() {
        return this.aparList;
    }

    protected void setAparList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setAparList", "apar number: " + stringArray[i]);
        }
        this.aparList = stringArray;
    }

    public String getAction() {
        return this.action;
    }

    protected void setAction(String string) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setAction", "action is: " + string);
        this.action = string;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    protected void setBackupFileName(String string, String string2) {
        String string3 = string + File.separator + string2;
        File file = new File(string3);
        this.backupFileName = this.getAction().equals("install") && !this.getResult().equals("failure") && file.exists() ? string3 : "";
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBackupFileName", "backup file name is: " + this.backupFileName);
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    protected void setBuildDate(String string) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBuildDate", "build date is: " + string);
        this.buildDate = string;
    }

    public WASComponentUpdate[] getComponentUpdateList() {
        return this.componentUpdateListThisMaintenance.toArray(new WASComponentUpdate[this.componentUpdateListThisMaintenance.size()]);
    }

    public void addComponentUpdateToList(WASComponentUpdate wASComponentUpdate) {
        if (wASComponentUpdate != null) {
            this.componentUpdateListThisMaintenance.add(wASComponentUpdate);
            this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "addComponentUpdateToList", "Added componentUpdate for component: " + wASComponentUpdate.getComponentName());
        }
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setDescription", "description is: " + string);
        this.description = string;
    }

    protected void setInstallAsMaintenance(boolean bl) {
        this.isInstalledAsMaintenance = bl;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setInstallAsMaintenance", "isInstallAsMaintenance flag is: " + bl);
    }

    public boolean isInstallAsMaintenance() {
        return this.isInstalledAsMaintenance;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    protected void setInstallRoot(String string) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setInstallRoot", "installRoot is: " + string);
        this.installRoot = string;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    protected void setLogFileName(String string, String string2, String string3) {
        String string4 = string + File.separator + string2 + "." + string3 + File.separator + "updatelog" + ".txt";
        File file = new File(string4);
        this.logFileName = file.exists() ? string4 : "";
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setLogFileName", "log file name is: " + this.logFileName);
    }

    public String getMaintenancePackageID() {
        return this.maintenancePackageID;
    }

    protected void setMaintenancePackageID(String string) {
        this.maintenancePackageID = string;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setMaintenancePackageID", "maintenancePackageID is: " + string);
    }

    public int getOrder() {
        return this.order;
    }

    protected void setOrder(int n) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setOrder", "order is: " + n);
        this.order = n;
    }

    public String getPackageFileName() {
        return this.packageFileName;
    }

    protected void setPackageFileName(String string) {
        this.packageFileName = string;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPAckageFileName", "Package file name is: " + string);
    }

    public String getPackageType() {
        return this.packageType;
    }

    protected void setPackageType(String string) {
        this.packageType = string;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPackageType", "Package type is: " + string);
    }

    public String getResult() {
        return this.result;
    }

    protected void setResult(String string) {
        this.result = string;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setResult", "Result status is: " + string);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(String string) {
        this.timestamp = string;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setTimestamp", "Timestamp is: " + string);
    }

    public includedEFix[] getIncludedEFixListForThisMaintenancePackage() {
        return this.includedEFixList;
    }

    private void setIncludedEFixListFromAPARList() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setIncludedEFixListFromAPARList", "Set included efix list with size of apar list: " + this.aparList.length);
        Vector<includedEFix> vector = new Vector<includedEFix>();
        for (int i = 0; i < this.aparList.length; ++i) {
            includedEFix includedEFix2 = new includedEFix();
            includedEFix2.setEFixId(this.aparList[i]);
            vector.add(includedEFix2);
        }
        this.includedEFixList = vector.toArray(new includedEFix[vector.size()]);
    }

    public ptf getPTFForThisMaintenancePackage() {
        return this.ptfThis;
    }

    private void setPTFForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFForThisMaintenancePackage", "Set ptf with ptfID: " + this.maintenancePackageID);
        this.ptfThis.setId(this.maintenancePackageID);
        this.ptfThis.setBuildDate(this.buildDate);
        this.ptfThis.setBuildVersion(this.buildDate);
        this.ptfThis.setShortDescription(this.description);
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            this.ptfThis.addComponentName(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentName());
        }
    }

    public ptfApplied getPTFAppliedForThisMaintenancePackage() {
        return this.ptfAppliedThis;
    }

    private void setPTFAppliedForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFAppliedForThisMaintenancePackage", "Set ptfApplied with ptfID: " + this.maintenancePackageID);
        this.ptfAppliedThis.setPTFId(this.maintenancePackageID);
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            this.ptfAppliedThis.addComponentApplied(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentApplied());
        }
    }

    public ptfDriver getPTFDriverForThisMaintenancePackage() {
        return this.ptfDriverThis;
    }

    private void setPTFDriverForThisMaintenancePackage() {
        int n;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFDriverForThisMaintenancePackage", "Set ptfDriver with ptfID: " + this.maintenancePackageID);
        this.ptfDriverThis.setId(this.maintenancePackageID);
        this.ptfDriverThis.setBuildDate(this.buildDate);
        this.ptfDriverThis.setShortDescription(this.description);
        for (n = 0; n < this.componentUpdateListThisMaintenance.size(); ++n) {
            this.ptfDriverThis.addComponentUpdate(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(n)).getComponentUpdate());
        }
        for (n = 0; n < this.includedEFixList.length; ++n) {
            this.ptfDriverThis.addIncludedEFix(this.includedEFixList[n]);
        }
    }

    public updateEvent getUpdateEventForThisMaintenancePackage() {
        return this.updateEventThis;
    }

    private void setUpdateEventForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setUpdateEventForThisMaintenancePackage", "Set updateEvent with maintenance package ID: " + this.maintenancePackageID);
        this.updateEventThis.setBackupName(this.backupFileName);
        this.updateEventThis.setEventType("ptf");
        this.updateEventThis.setId(this.maintenancePackageID);
        this.updateEventThis.setLogName(this.logFileName);
        this.updateEventThis.setPrimaryContent(this.packageFileName);
        this.updateEventThis.setResult(this.result);
        this.updateEventThis.setStartTimeStamp(this.timestamp);
        this.updateEventThis.setUpdateAction(this.action);
        this.updateEventThis.setUpdateType("replace");
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            updateEvent updateEvent2 = new updateEvent();
            updateEvent2.setEventType(enumEventType.COMPONENT_EVENT_TYPE);
            updateEvent2.setParentId(this.maintenancePackageID);
            updateEvent2.setId(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentName());
            updateEvent2.setUpdateAction(this.action);
            updateEvent2.setUpdateType("replace");
            updateEvent2.setStartTimeStamp(this.timestamp);
            updateEvent2.setResult(this.result);
            this.updateEventThis.addUpdateEvent(updateEvent2);
        }
    }
}

