/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.logger;

import com.ibm.websphere.product.utils.WASDirectoryHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class WASDirectoryLogger {
    private static final String S_WASDIRECTORY_TRACE_FILE_NAME = "wasdirectory.trace";
    public static final String S_TRACE_FILE_EXT = ".txt";
    public static final String S_TRACE_LOCK_FILE_EXT = ".lck";
    public static final Level DEFAULT_TRACE_LEVEL = Level.INFO;
    private static HashMap loggerMap = new HashMap();
    private Logger LOGGER;
    private boolean isLoggerInitProperly = false;
    private static final String WASDIRECTORY_LOGGER_TRACE_LEVEL = "wasdirectory.logger.level";
    private static final String LEVEL_ALL = "all";
    private static final String LEVEL_CONFIG = "config";
    private static final String LEVEL_FINE = "fine";
    private static final String LEVEL_FINER = "finer";
    private static final String LEVEL_FINEST = "finest";
    private static final String LEVEL_INFO = "info";
    private static final String LEVEL_OFF = "off";
    private static final String LEVEL_SEVERE = "severe";
    private static final String LEVEL_WARNING = "warning";

    public static WASDirectoryLogger getWASDirectoryLogger(String string) {
        return WASDirectoryLogger.getWASDirectoryLogger(string, DEFAULT_TRACE_LEVEL);
    }

    public static WASDirectoryLogger getWASDirectoryLogger(String string, Level level) {
        return new WASDirectoryLogger(string, level);
    }

    public void logThisMessage(Level level, String string, String string2, String string3) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.logp(level, string, string2, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logThisException(Level level, String string, String string2, String string3, Throwable throwable) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.logp(level, string, string2, string3);
            this.LOGGER.logp(level, string, string2, this.getStackTrace(throwable));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void entering(String string, String string2) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.entering(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exiting(String string, String string2) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.exiting(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected WASDirectoryLogger(String string, Level level) {
        this.LOGGER = this.createLogger(string, level);
        if (this.LOGGER != null) {
            this.isLoggerInitProperly = true;
            this.LOGGER.info("Logger for install root: " + string + ", is initialized successfully.");
        }
    }

    protected Logger createLogger(String string, Level level) {
        Logger logger;
        if (!new File(string = WASDirectoryHelper.normalizeLocationAccordingToPlatform(string, false)).exists()) {
            return null;
        }
        if (loggerMap.get(string) == null && (logger = this.initLogger(string, level)) != null) {
            loggerMap.put(string, logger);
        }
        return (Logger)loggerMap.get(string);
    }

    protected Logger initLogger(String string, Level level) {
        block6: {
            Logger logger = null;
            level = this.setLoggerTraceLevel(level);
            try {
                this.cleanupTraceFile(WASDirectoryHelper.getVersionDirPath(string));
                logger = Logger.getAnonymousLogger();
                logger.setUseParentHandlers(false);
                logger.setLevel(level);
                Date date = new Date(System.currentTimeMillis());
                String string2 = new SimpleDateFormat("_yyyy.MM.dd_HH.mm.ss.SSS").format(date);
                String string3 = WASDirectoryHelper.getVersionDirPath(string) + File.separator + S_WASDIRECTORY_TRACE_FILE_NAME + S_TRACE_FILE_EXT;
                if (string != null) {
                    string3 = string3.substring(0, string3.lastIndexOf(S_TRACE_FILE_EXT));
                    string3 = string3 + string2 + S_TRACE_FILE_EXT;
                    FileHandler fileHandler = new FileHandler(string3);
                    fileHandler.setFormatter(new SimpleFormatter());
                    fileHandler.setLevel(level);
                    logger.addHandler(fileHandler);
                }
                return logger;
            }
            catch (IOException iOException) {
                if (logger == null) break block6;
                Handler[] handlerArray = logger.getHandlers();
                for (int i = 0; i < handlerArray.length; ++i) {
                    if (!(handlerArray[i] instanceof FileHandler)) continue;
                    handlerArray[i].close();
                }
            }
            catch (SecurityException securityException) {
                if (logger == null) break block6;
                Handler[] handlerArray = logger.getHandlers();
                for (int i = 0; i < handlerArray.length; ++i) {
                    if (!(handlerArray[i] instanceof FileHandler)) continue;
                    handlerArray[i].close();
                }
            }
        }
        return null;
    }

    protected void cleanupTraceFile(String string) {
        File[] fileArray = new File(string).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(WASDirectoryLogger.S_WASDIRECTORY_TRACE_FILE_NAME) && (string.endsWith(WASDirectoryLogger.S_TRACE_FILE_EXT) || string.endsWith(WASDirectoryLogger.S_TRACE_LOCK_FILE_EXT));
            }
        });
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    protected Level setLoggerTraceLevel(Level level) {
        String string = System.getProperty(WASDIRECTORY_LOGGER_TRACE_LEVEL);
        if (string == null) {
            return level;
        }
        if (LEVEL_ALL.equals(string)) {
            return Level.ALL;
        }
        if (LEVEL_CONFIG.equals(string)) {
            return Level.CONFIG;
        }
        if (LEVEL_FINE.equals(string)) {
            return Level.FINE;
        }
        if (LEVEL_FINER.equals(string)) {
            return Level.FINER;
        }
        if (LEVEL_FINEST.equals(string)) {
            return Level.FINEST;
        }
        if (LEVEL_INFO.equals(string)) {
            return Level.INFO;
        }
        if (LEVEL_OFF.equals(string)) {
            return Level.OFF;
        }
        if (LEVEL_SEVERE.equals(string)) {
            return Level.SEVERE;
        }
        if (LEVEL_WARNING.equals(string)) {
            return Level.WARNING;
        }
        return level;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

