/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProductInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASProductFile {
    private String m_sDtdDir = null;
    private String m_sVersionDir = null;
    private String m_sFileName = null;
    private Vector m_vWASProductInfoVec = new Vector(1);
    private static Hashtable container = new Hashtable();
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = string + File.separator + "properties/version/dtd";
            String string3 = string + File.separator + "properties/version";
            String string4 = "BASE.product";
            WASProductFile wASProductFile = WASProductFile.getWASProductFileInstance(string2, string3, string4);
        }
    }

    public static WASProductFile getWASProductFileInstance(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        File file = new File(string);
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File file2 = new File(string2);
        if (file2 == null || !file2.exists() || !file2.isDirectory()) {
            return null;
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + string3);
        if (file3 == null || !file3.exists() || file3.isDirectory()) {
            return null;
        }
        String string4 = file3.getAbsolutePath();
        WASProductFile wASProductFile = (WASProductFile)container.get(string4);
        if (wASProductFile == null) {
            wASProductFile = new WASProductFile(string, string2, string3);
            container.put(string4, wASProductFile);
        }
        return wASProductFile;
    }

    public void setDtdDir(String string) {
        this.m_sDtdDir = string;
    }

    public String getDtdDir() {
        return this.m_sDtdDir;
    }

    public void setVersionDir(String string) {
        this.m_sVersionDir = string;
    }

    public String getVersionDir() {
        return this.m_sVersionDir;
    }

    public void setFileName(String string) {
        this.m_sFileName = string;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public WASProductInfo[] getWASProductInfoArray() {
        WASProductInfo[] wASProductInfoArray = new WASProductInfo[this.m_vWASProductInfoVec.size()];
        for (int i = 0; i < wASProductInfoArray.length; ++i) {
            wASProductInfoArray[i] = (WASProductInfo)this.m_vWASProductInfoVec.elementAt(i);
        }
        return wASProductInfoArray;
    }

    public static boolean refreshCache() {
        if (container != null) {
            container.clear();
            return true;
        }
        return false;
    }

    private void parse() {
        String string = this.readFile(this.m_sVersionDir + this.m_sFileName);
        if (string == null) {
            return;
        }
        Pattern pattern = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            this.parseProductString(string2);
        }
    }

    private void parseProductString(String string) {
        Object object;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            object = matcher.group();
            string2 = ((String)object).substring(((String)object).indexOf(34) + 1, ((String)object).lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(string)).find()) {
            object = matcher.group();
            string3 = ((String)object).substring(((String)object).indexOf("<id>") + 4, ((String)object).indexOf("</id>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(string)).find()) {
            object = matcher.group();
            string4 = ((String)object).substring(((String)object).indexOf("<version>") + 9, ((String)object).indexOf("</version>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(string)).find()) {
            object = matcher.group();
            string5 = ((String)object).substring(((String)object).indexOf(34) + 1, ((String)object).lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(string)).find()) {
            object = matcher.group();
            string6 = ((String)object).substring(((String)object).indexOf(34) + 1, ((String)object).lastIndexOf(34));
        }
        object = new WASProductInfo(string2, string3, string4, string5, string6);
        this.m_vWASProductInfoVec.addElement(object);
    }

    private String readFile(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            string2 = new String(byArray, "UTF-8");
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    private WASProductFile(String string, String string2, String string3) {
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.m_sDtdDir = string;
        this.m_sVersionDir = string2;
        this.m_sFileName = string3;
        this.parse();
    }

    private WASProductFile() {
    }
}

