/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.ws.pak.core.utils.IPakUtils;
import com.ibm.ws.pak.core.utils.PakUtils;
import com.ibm.ws.resync.internal.ResyncUtil;
import com.ibm.ws.sync.core.SyncConstants;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.internal.ui.ImportFix;
import com.ibm.ws.sync.internal.ui.ImportOffering;
import com.ibm.ws.sync.internal.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SyncUIUtil {
    public static final String pluginId = "com.ibm.ws.sync.ui";
    public static final String ERROR_PACKAGE_GROUP_NOT_AVALIABLE = "PACKAGE_GROUP_NOT_AVALIABLE";
    public static final String ERROR_RESYNC_MISSING_OFFERING = "ERROR_RESYNC_MISSING_OFFERING";
    public static final String ERROR_SYNC_NO_BASE_OFFERING = "ERROR_SYNC_NO_BASE_OFFERING";

    public static void displayMessages(final IStatus status, final boolean repositoryError) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (repositoryError) {
                    SyncUIUtil.doDisplayRepositoryMessages(status);
                } else if (status.getMessage().equals(SyncUIUtil.ERROR_PACKAGE_GROUP_NOT_AVALIABLE)) {
                    IStatus[] children = status.getChildren();
                    CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_package_group_not_available_1, new Object[]{children[0].getMessage()});
                    multiStatus.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_package_group_not_available_detail_1, new Object[]{children[0].getMessage()}));
                    CicMultiStatus statusSuggestion = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_package_group_not_available_detail_2, new Object[0]);
                    statusSuggestion.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_package_group_not_available_detail_3, new Object[0]));
                    statusSuggestion.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_package_group_not_available_detail_4, new Object[0]));
                    multiStatus.add((IStatus)statusSuggestion);
                    SyncUIUtil.doDisplayMessages((IStatus)multiStatus, Messages.ImportWAS_package_group_not_available_title);
                } else if (status.getMessage().equals(SyncUIUtil.ERROR_RESYNC_MISSING_OFFERING)) {
                    IStatus[] children;
                    CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(0, 4, null, null, String.valueOf(Messages.ImportWAS_resynchronization_error_1) + LogUtil.NEWLINE + Messages.ImportWAS_resynchronization_error_2, new Object[0]);
                    CicMultiStatus missingPackages = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_synchronization_error_detail, new Object[0]);
                    IStatus[] iStatusArray = children = status.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus element = iStatusArray[n2];
                        missingPackages.add(element);
                        ++n2;
                    }
                    multiStatus.add((IStatus)missingPackages);
                    multiStatus.add((IStatus)Statuses.ERROR.get("", new Object[0]));
                    CicMultiStatus reasons = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_connection_fail_reason_1, new Object[0]);
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_2, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_3, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_4, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_5, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_6, new Object[0]));
                    multiStatus.add((IStatus)reasons);
                    SyncUIUtil.doDisplayMessages((IStatus)multiStatus, Messages.ImportWAS_synchronization_error_title);
                } else if (status.getMessage().equals(SyncUIUtil.ERROR_SYNC_NO_BASE_OFFERING)) {
                    IStatus[] children;
                    CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_synchronization_error_1, new Object[0]);
                    CicMultiStatus missingPackages = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_synchronization_error_detail, new Object[0]);
                    IStatus[] iStatusArray = children = status.getChildren();
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IStatus element = iStatusArray[n3];
                        missingPackages.add(element);
                        ++n3;
                    }
                    multiStatus.add((IStatus)missingPackages);
                    multiStatus.add((IStatus)Statuses.ERROR.get("", new Object[0]));
                    CicMultiStatus reasons = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_connection_fail_reason_1, new Object[0]);
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_2, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_3, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_4, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_5, new Object[0]));
                    reasons.add((IStatus)Statuses.ERROR.get(Messages.ImportWAS_connection_fail_reason_6, new Object[0]));
                    multiStatus.add((IStatus)reasons);
                    SyncUIUtil.doDisplayMessages((IStatus)multiStatus, Messages.ImportWAS_synchronization_error_title);
                } else {
                    String msg = status.getMessage();
                    if (msg == null || msg.length() < 1) {
                        IStatus[] children;
                        CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(0, 4, null, null, Messages.ImportWAS_import_error, new Object[0]);
                        IStatus[] iStatusArray = children = status.getChildren();
                        int n = children.length;
                        int n4 = 0;
                        while (n4 < n) {
                            IStatus element = iStatusArray[n4];
                            multiStatus.add(element);
                            ++n4;
                        }
                        SyncUIUtil.doDisplayMessages((IStatus)multiStatus);
                    } else {
                        SyncUIUtil.doDisplayMessages(status);
                    }
                }
            }
        });
    }

    private static void doDisplayMessages(IStatus status) {
        SyncUIUtil.doDisplayMessages(status, Messages.ImportWAS_defaultTitle);
    }

    private static void doDisplayMessages(IStatus status, String title) {
        if (!status.isOK()) {
            Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(shell, title, null, status, 15);
            errorDialog.open();
        }
    }

    private static void doDisplayRepositoryMessages(IStatus status) {
        if (!status.isOK()) {
            String msg = String.valueOf(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected) + "\n\n" + status.getMessage();
            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(status.getPlugin(), 2, status.getCode(), null, status.getException(), msg);
            if (status.isMultiStatus()) {
                IStatus[] children;
                IStatus[] iStatusArray = children = status.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    RepositoryStatus.StatusAndErrorType displayStatus = RepositoryStatus.getDisplayStatusForCanAddExisting((String)msg, (IStatus)element);
                    SyncUIUtil.addToMultiStatus(multiStatus, (IStatus)displayStatus);
                    ++n2;
                }
            }
            Shell shell = CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell();
            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(shell, com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Warning, null, (IStatus)multiStatus, 15);
            errorDialog.open();
        }
    }

    private static void addToMultiStatus(CicMultiStatus multiStatus, IStatus status) {
        if (!status.isMultiStatus()) {
            multiStatus.add(status);
        } else {
            IStatus[] nested;
            IStatus[] iStatusArray = nested = status.getChildren();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                boolean hasSameMsg = false;
                IStatus[] children = multiStatus.getChildren();
                if (children != null) {
                    IStatus[] iStatusArray2 = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IStatus element2 = iStatusArray2[n4];
                        if (element2.getMessage().equals(element.getMessage())) {
                            hasSameMsg = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!hasSameMsg) {
                    multiStatus.add(element);
                }
                ++n2;
            }
        }
    }

    public static IOffering getBaseOffering(Profile profile) {
        IOffering[] offerings;
        IOffering[] iOfferingArray = offerings = profile.getInstalledOfferings();
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (Agent.isSelfContainedOffering((IOffering)offering)) {
                return offering;
            }
            ++n2;
        }
        return null;
    }

    public static ImportOffering[] getTargetPackages(SyncLocation syncLocation) {
        TreeSet<ImportOffering> importOfferingsAndFixes = new TreeSet<ImportOffering>();
        if (syncLocation != null) {
            IProfile syncProfile = syncLocation.getProfile();
            SyncLocation.InstalledOffering[] offeringsToImport = syncLocation.getOfferingsToInstall();
            ArrayList<SyncLocation.InstalledFix> fixesToImport = new ArrayList<SyncLocation.InstalledFix>(Arrays.asList(syncLocation.getIFixesToInstall()));
            SyncLocation.InstalledOffering[] installedOfferingArray = offeringsToImport;
            int n = offeringsToImport.length;
            int n2 = 0;
            while (n2 < n) {
                SyncLocation.InstalledOffering element = installedOfferingArray[n2];
                ImportOffering importOffering = new ImportOffering(element.getRepositoryOffering(), false);
                SyncUIUtil.addFixes(importOffering, fixesToImport, syncLocation);
                importOfferingsAndFixes.add(importOffering);
                ++n2;
            }
            if (syncProfile != null) {
                IOfferingOrFix[] offeringsAndFixesToUninstall = syncLocation.getOfferingsAndFixesToUninstall();
                IOffering[] installedOfferings = syncProfile.getInstalledOfferings();
                int i = 0;
                while (i < installedOfferings.length) {
                    ImportOffering installedOffering;
                    if (!SyncUIUtil.isOfferingOrFixInArray((IOfferingOrFix)installedOfferings[i], offeringsAndFixesToUninstall) && !importOfferingsAndFixes.contains(installedOffering = new ImportOffering(installedOfferings[i], true))) {
                        SyncUIUtil.addFixes(installedOffering, fixesToImport, syncLocation);
                        importOfferingsAndFixes.add(installedOffering);
                    }
                    ++i;
                }
            }
        }
        return importOfferingsAndFixes.toArray(new ImportOffering[importOfferingsAndFixes.size()]);
    }

    private static void addFixes(ImportOffering importOffering, List fixesToImport, SyncLocation syncLocation) {
        if (importOffering == null || importOffering.getOffering() == null) {
            return;
        }
        String offeringId = importOffering.getOfferingId();
        ArrayList<SyncLocation.InstalledFix> fixesToRemove = new ArrayList<SyncLocation.InstalledFix>();
        for (SyncLocation.InstalledFix fix : fixesToImport) {
            if (!offeringId.equals(fix.getAssociatedOfferingId())) continue;
            importOffering.addFix(new ImportFix(fix.getRepositoryFix(), false));
            fixesToRemove.add(fix);
        }
        fixesToImport.removeAll(fixesToRemove);
        IProfile syncProfile = syncLocation.getProfile();
        IFix[] installedFixes = syncProfile != null ? syncProfile.getInstalledFixes(importOffering.getOffering()) : new IFix[]{};
        IOfferingOrFix[] offeringsAndFixesToUninstall = syncLocation.getOfferingsAndFixesToUninstall();
        int i = 0;
        while (i < installedFixes.length) {
            if (!SyncUIUtil.isOfferingOrFixInArray((IOfferingOrFix)installedFixes[i], offeringsAndFixesToUninstall)) {
                importOffering.addFix(new ImportFix(installedFixes[i], true));
            }
            ++i;
        }
    }

    private static boolean isOfferingOrFixInArray(IOfferingOrFix offering, IOfferingOrFix[] offeringArray) {
        IOfferingOrFix[] iOfferingOrFixArray = offeringArray;
        int n = offeringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix element = iOfferingOrFixArray[n2];
            if (offering.getIdentity().getId().equals(element.getIdentity().getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Profile findParentProfile(String installLocation) {
        Profile parentProfile = null;
        Profile[] existingProfiles = Agent.getInstance().getNormalProfiles();
        File newInstallDir = new File(installLocation);
        int i = 0;
        while (i < existingProfiles.length && parentProfile == null) {
            File installDir = new File(existingProfiles[i].getInstallLocation());
            if (newInstallDir.compareTo(installDir) != 0) {
                try {
                    String installDirPath = String.valueOf(installDir.getCanonicalPath()) + File.separator;
                    String newInstallDirPath = String.valueOf(newInstallDir.getCanonicalPath()) + File.separator;
                    if (newInstallDirPath.startsWith(installDirPath)) {
                        parentProfile = existingProfiles[i];
                    }
                }
                catch (IOException ioe) {
                    ExceptionUtil.debugLogToReview((Throwable)ioe);
                }
            }
            ++i;
        }
        return parentProfile;
    }

    public static String[] getAllWASLocations() {
        Profile[] existingProfiles;
        ArrayList<String> wasLocationList = new ArrayList<String>();
        PakUtils pakUtils = new PakUtils();
        List<String> wasIds = Arrays.asList(SyncConstants.WAS_IDS);
        Profile[] profileArray = existingProfiles = Agent.getInstance().getNormalProfiles();
        int n = existingProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile existingProfile = profileArray[n2];
            if (ResyncUtil.hasImportedOfferings((IProfile)existingProfile)) {
                wasLocationList.add(existingProfile.getInstallLocation());
            } else if (SyncUIUtil.isWAS7((IPakUtils)pakUtils, wasIds, existingProfile.getInstallLocation())) {
                wasLocationList.add(existingProfile.getInstallLocation());
            }
            ++n2;
        }
        String[] nifInstallLocation = pakUtils.getPossibleInstallLocation();
        int i = 0;
        while (i < nifInstallLocation.length) {
            if (SyncUIUtil.findParentProfile(nifInstallLocation[i]) == null && SyncUIUtil.isWAS7((IPakUtils)pakUtils, wasIds, nifInstallLocation[i]) && !SyncUIUtil.isPathInList(wasLocationList, nifInstallLocation[i])) {
                wasLocationList.add(nifInstallLocation[i]);
            }
            ++i;
        }
        return wasLocationList.toArray(new String[wasLocationList.size()]);
    }

    private static boolean isWAS7(IPakUtils pakUtils, List wasIds, String installLocation) {
        String[] productIds;
        String[] stringArray = productIds = pakUtils.getProductIds(installLocation);
        int n = productIds.length;
        int n2 = 0;
        while (n2 < n) {
            String version;
            String productId = stringArray[n2];
            if (wasIds.contains(productId) && (version = pakUtils.getVersion(installLocation, productId)).startsWith("7.")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isPathInList(List pathList, String path) {
        File f1 = new File(path);
        int i = 0;
        while (i < pathList.size()) {
            File f2 = new File((String)pathList.get(i));
            if (f1.equals(f2)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

