/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resync.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IStartupExtender;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.ws.resync.internal.MultiSyncEngine;
import com.ibm.ws.resync.internal.ResyncUtil;
import com.ibm.ws.resync.internal.ui.Messages;
import com.ibm.ws.sync.core.SyncLocation;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StartupExtender
implements IStartupExtender {
    public static final String pluginId = "com.ibm.ws.resync.internal.ui.StartupExtender";
    public static final String startupResyncPref = "com.ibm.ws.resync.preferences.startup.enabled";
    private static final String S_EMPTY = "";
    private static final Logger log = Logger.getLogger(StartupExtender.class);
    private static boolean isResync = false;

    public static void setResync(boolean isResync) {
        StartupExtender.isResync = isResync;
    }

    public static boolean isResync() {
        return isResync;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            if (CicPreferenceManager.getInstance().isSet(startupResyncPref) && !CicPreferenceManager.getInstance().getBoolean(startupResyncPref)) {
                log.debug("com.ibm.ws.resync.preferences.startup.enabled = " + CicPreferenceManager.getInstance().getBoolean(startupResyncPref));
                return new Status(0, pluginId, S_EMPTY);
            }
            if (!Agent.getInstance().isSilentMode()) {
                Profile[] profiles;
                log.debug("Run startup resync.");
                ArrayList<SyncLocation> outofsyncLocations = new ArrayList<SyncLocation>();
                Profile[] profileArray = profiles = Agent.getInstance().getNormalProfiles();
                int n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile = profileArray[n2];
                    if (ResyncUtil.hasImportedOfferings((IProfile)profile)) {
                        log.debug("Found resync location at startup: " + profile.getInstallLocation());
                        SyncLocation aLoc = new SyncLocation(profile.getInstallLocation());
                        CicMultiStatus status = aLoc.performQuickCheck(monitor);
                        if (status.matches(4)) {
                            log.status((IStatus)Statuses.ERROR.getMultiStatus(new IStatus[]{status}, Messages.UnexpectedErrorStartupResyncCheck, new Object[]{profile.getInstallLocation()}));
                        } else if (aLoc.requiresReSynchronization()) {
                            log.debug("Found out-of-sync location at startup: " + profile.getInstallLocation());
                            outofsyncLocations.add(aLoc);
                        }
                    }
                    ++n2;
                }
                log.debug("Done startup resync's imported check.");
                if (outofsyncLocations.size() > 0) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            YesNoErrorDialog dialog = new YesNoErrorDialog(CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), Messages.RepositoryAccessDialogTitle, null, (IStatus)new Status(2, StartupExtender.pluginId, Messages.RepositoryAccessDialogText), 2);
                            if (dialog.open() == 2) {
                                log.debug("User wants to resync at startup.");
                                StartupExtender.setResync(true);
                            }
                        }
                    });
                }
                if (StartupExtender.isResync()) {
                    log.debug("In startup resync.");
                    SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
                    final MultiSyncEngine resyncEngine = new MultiSyncEngine(outofsyncLocations);
                    final IStatus[] validateStatus = new IStatus[]{Status.OK_STATUS};
                    final IStatus[] syncStatus = new IStatus[]{Status.OK_STATUS};
                    validateStatus[0] = resyncEngine.validateRepositories(spm.next());
                    log.debug("Done repository validation.");
                    if (!validateStatus[0].isOK()) {
                        if (validateStatus[0].getSeverity() == 8) {
                            return new Status(8, pluginId, Messages.ResyncCancelledText);
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                String dialogText = Messages.RepositoryValidationErrorDialogText;
                                if (resyncEngine.hasSynchronizableLocations()) {
                                    dialogText = Messages.RepositoryValidationErrorDialogText_Synchronizable;
                                }
                                ErrorDialog.openError((Shell)CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), (String)Messages.RepositoryValidationErrorDialogTitle, null, (IStatus)Statuses.ST.createMultiStatus(4, new IStatus[]{validateStatus[0], new Status(1, StartupExtender.pluginId, StartupExtender.S_EMPTY), StartupExtender.this.repositoryConnFailedReasons()}, dialogText, new Object[0]));
                            }
                        });
                        log.debug("Done error display for repository validation.");
                    }
                    if (resyncEngine.hasSynchronizableLocations()) {
                        syncStatus[0] = resyncEngine.performMultiSynchronization(spm.next());
                        log.debug("Done resynchronization.");
                        if (!syncStatus[0].isOK()) {
                            if (syncStatus[0].getSeverity() == 8) {
                                if (syncStatus[0].getChildren().length == 0) {
                                    return new Status(8, pluginId, Messages.ResyncCancelledText);
                                }
                                return Statuses.ST.createMultiStatus(8, syncStatus[0].getChildren(), Messages.ResyncCancelledText, new Object[0]);
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IStatus[] iStatusArray;
                                    if (resyncEngine.hasRepositoryError()) {
                                        IStatus[] iStatusArray2 = new IStatus[3];
                                        iStatusArray2[0] = syncStatus[0];
                                        iStatusArray2[1] = new Status(1, StartupExtender.pluginId, StartupExtender.S_EMPTY);
                                        iStatusArray = iStatusArray2;
                                        iStatusArray2[2] = StartupExtender.this.repositoryConnFailedReasons();
                                    } else {
                                        IStatus[] iStatusArray3 = new IStatus[2];
                                        iStatusArray3[0] = syncStatus[0];
                                        iStatusArray = iStatusArray3;
                                        iStatusArray3[1] = new Status(1, StartupExtender.pluginId, StartupExtender.S_EMPTY);
                                    }
                                    IStatus[] resyncStatus = iStatusArray;
                                    ErrorDialog.openError((Shell)CicCommonUiPlugin.getDefault().getTimeTriggeredProgressDlgShell(), (String)Messages.ResyncWarningDialogTitle, null, (IStatus)Statuses.ST.createMultiStatus(4, resyncStatus, Messages.ResyncWarningDialogText, new Object[0]));
                                }
                            });
                            log.debug("Done error display for resynchronization.");
                        }
                    }
                    spm.done();
                }
            }
            log.debug("Exit startup resync.");
            return new Status(0, pluginId, S_EMPTY);
        }
        catch (Throwable t) {
            log.error(t, Messages.UnexpectedErrorStartupResync, new Object[0]);
            return new Status(4, pluginId, Messages.UnexpectedErrorStartupResync, t);
        }
    }

    protected IStatus repositoryConnFailedReasons() {
        CicMultiStatus status = Statuses.ST.createMultiStatus(4, Messages.RepositoryConnectionFailure, new Object[0]);
        status.add((IStatus)new Status(4, pluginId, Messages.RepoConnFailReason1));
        status.add((IStatus)new Status(4, pluginId, Messages.RepoConnFailReason2));
        status.add((IStatus)new Status(4, pluginId, Messages.RepoConnFailReason3));
        status.add((IStatus)new Status(4, pluginId, Messages.RepoConnFailReason4));
        return status;
    }
}

