/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.file;

import com.ibm.io.file.UnixNativeFile;
import com.ibm.io.file.WindowsNativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.io.file.exception.InvalidGroupException;
import com.ibm.io.file.exception.InvalidUserException;
import com.ibm.io.file.exception.NativeFileIOException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class NativeFile
extends File {
    private static final long serialVersionUID = 8140735840556693048L;
    public static final int READABLE = 4;
    public static final int WRITEABLE = 2;
    public static final int EXECUTABLE = 1;

    public NativeFile(String string) throws NullPointerException {
        super(string);
    }

    public NativeFile(String string, String string2) throws NullPointerException {
        super(string, string2);
    }

    public NativeFile(File file, String string) throws NullPointerException {
        super(file, string);
    }

    public NativeFile(File file) throws NullPointerException {
        super(file.getPath());
    }

    public static boolean isNativeFileFunctionalityAvailable() {
        boolean bl = false;
        if (UnixNativeFile.isImplemented() || WindowsNativeFile.isImplemented()) {
            bl = true;
        }
        return bl;
    }

    public int getUserPermissions() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        int n = 7;
        if (!this.canWrite()) {
            n ^= 2;
        }
        if (!this.canRead()) {
            n ^= 4;
        }
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                n = UnixNativeFile.getUserPermissions(this.getAbsolutePath());
            } else {
                throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            }
        }
        return n;
    }

    public int getGroupPermissions() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        int n = 7;
        if (!this.canWrite()) {
            n ^= 2;
        }
        if (!this.canRead()) {
            n ^= 4;
        }
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                n = UnixNativeFile.getGroupPermissions(this.getAbsolutePath());
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return n;
    }

    public int getWorldPermissions() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        int n = 7;
        if (!this.canWrite()) {
            n ^= 2;
        }
        if (!this.canRead()) {
            n ^= 4;
        }
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                n = UnixNativeFile.getWorldPermissions(this.getAbsolutePath());
            } else {
                throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUserPermissions(int n) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (!this.exists() && !this.isSymLink()) throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            UnixNativeFile.setUserPermissions(this.getAbsolutePath(), n);
            return;
        } else {
            if (!WindowsNativeFile.isImplemented()) return;
            if (!this.exists()) throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            WindowsNativeFile.setPermissions(this.getAbsolutePath(), n);
        }
    }

    public void setGroupPermissions(int n) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists() || this.isSymLink()) {
                UnixNativeFile.setGroupPermissions(this.getAbsolutePath(), n);
            } else {
                throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            }
        }
    }

    public void setWorldPermissions(int n) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists() || this.isSymLink()) {
                UnixNativeFile.setWorldPermissions(this.getAbsolutePath(), n);
            } else {
                throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPermissions(int n, int n2, int n3) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (!this.exists() && !this.isSymLink()) throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            UnixNativeFile.setPermissions(this.getAbsolutePath(), n, n2, n3);
            return;
        } else {
            if (!WindowsNativeFile.isImplemented()) return;
            if (!this.exists()) throw new FileNotFoundException("File " + this.getAbsolutePath() + " does not exist.");
            WindowsNativeFile.setPermissions(this.getAbsolutePath(), n);
        }
    }

    public boolean isSymLink() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented() && UnixNativeFile.isSymLink(this.getAbsolutePath()) == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isBrokenSymLink() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented()) {
            try {
                bl = this.isSymLink() && !this.exists();
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = false;
            }
        }
        return bl;
    }

    public String getSymLinkLocation() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        String string = null;
        if (UnixNativeFile.isImplemented() && this.isSymLink()) {
            string = UnixNativeFile.getSymLinkValue(this.getAbsolutePath());
        }
        return string;
    }

    public boolean isWorldReadable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getWorldPermissions();
        if ((4 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isWorldWriteable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getWorldPermissions();
        if ((2 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isWorldExecutable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getWorldPermissions();
        if ((1 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isGroupReadable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getGroupPermissions();
        if ((4 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isGroupWriteable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getGroupPermissions();
        if ((2 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isGroupExecutable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getGroupPermissions();
        if ((1 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isUserReadable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getUserPermissions();
        if ((4 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isUserWriteable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getUserPermissions();
        if ((2 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isUserExecutable() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        int n = this.getUserPermissions();
        if ((1 & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public String getOwner() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        String string = null;
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                string = UnixNativeFile.getFileOwner(this.getAbsolutePath());
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return string;
    }

    public String getGroup() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        String string = null;
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                string = UnixNativeFile.getFileGroup(this.getAbsolutePath());
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return string;
    }

    public void setOwner(String string) throws AccessDeniedException, FileNotFoundException, InvalidUserException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                UnixNativeFile.setFileOwner(this.getAbsolutePath(), string);
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
    }

    public void setGroup(String string) throws AccessDeniedException, FileNotFoundException, InvalidGroupException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                UnixNativeFile.setFileGroup(this.getAbsolutePath(), string);
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
    }

    public static boolean createSymlink(String string, String string2) throws AccessDeniedException, NativeFileIOException {
        return NativeFile.createSymlink(new File(string), new File(string2));
    }

    public static boolean createSymlink(String string, File file) throws AccessDeniedException, NativeFileIOException {
        return NativeFile.createSymlink(new File(string), file);
    }

    public static boolean createSymlink(File file, File file2) throws AccessDeniedException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented() && !file.exists()) {
            UnixNativeFile.createSymLink(file.getPath(), file2.getPath());
            bl = true;
        }
        return bl;
    }

    public boolean isUID() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (UnixNativeFile.isSetUIDBit(this.getAbsolutePath()) == 1) {
                    bl = true;
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return bl;
    }

    public boolean isGID() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (UnixNativeFile.isSetGIDBit(this.getAbsolutePath()) == 1) {
                    bl = true;
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return bl;
    }

    public boolean isSticky() throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        boolean bl = false;
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (UnixNativeFile.isSetStickyBit(this.getAbsolutePath()) == 1) {
                    bl = true;
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
        return bl;
    }

    public void setUID(boolean bl) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (bl) {
                    UnixNativeFile.setUIDBit(this.getAbsolutePath(), 1);
                } else {
                    UnixNativeFile.setUIDBit(this.getAbsolutePath(), 0);
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
    }

    public void setGID(boolean bl) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (bl) {
                    UnixNativeFile.setGIDBit(this.getAbsolutePath(), 1);
                } else {
                    UnixNativeFile.setGIDBit(this.getAbsolutePath(), 0);
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
    }

    public void setSticky(boolean bl) throws AccessDeniedException, FileNotFoundException, NativeFileIOException {
        if (UnixNativeFile.isImplemented()) {
            if (this.exists()) {
                if (bl) {
                    UnixNativeFile.setStickyBit(this.getAbsolutePath(), 1);
                } else {
                    UnixNativeFile.setStickyBit(this.getAbsolutePath(), 0);
                }
            } else {
                throw new FileNotFoundException("File [" + this.getAbsolutePath() + "] does not exist.");
            }
        }
    }

    public boolean delete() throws SecurityException {
        boolean bl = false;
        try {
            if (UnixNativeFile.isImplemented() && this.isSymLink()) {
                try {
                    UnixNativeFile.symlinkDelete(this.getAbsolutePath());
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = super.delete();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public NativeFile getParentNativeFile() {
        NativeFile nativeFile = null;
        File file = null;
        file = super.getParentFile();
        if (file != null) {
            nativeFile = new NativeFile(file.getPath());
        }
        return nativeFile;
    }

    public NativeFile[] listNativeFiles() throws SecurityException {
        File[] fileArray = super.listFiles();
        NativeFile[] nativeFileArray = null;
        if (fileArray != null && fileArray.length > 0) {
            nativeFileArray = new NativeFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                nativeFileArray[i] = new NativeFile(fileArray[i]);
            }
        }
        return nativeFileArray;
    }

    public NativeFile[] listNativeFiles(FilenameFilter filenameFilter) throws SecurityException {
        File[] fileArray = super.listFiles(filenameFilter);
        NativeFile[] nativeFileArray = null;
        if (fileArray != null && fileArray.length > 0) {
            nativeFileArray = new NativeFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                nativeFileArray[i] = new NativeFile(fileArray[i]);
            }
        }
        return nativeFileArray;
    }

    public NativeFile[] listNativeFiles(FileFilter fileFilter) throws SecurityException {
        File[] fileArray = super.listFiles(fileFilter);
        NativeFile[] nativeFileArray = null;
        if (fileArray != null && fileArray.length > 0) {
            nativeFileArray = new NativeFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                nativeFileArray[i] = new NativeFile(fileArray[i]);
            }
        }
        return nativeFileArray;
    }

    public static NativeFile[] getFileSystems() throws AccessDeniedException, NativeFileIOException {
        String[] stringArray = null;
        NativeFile[] nativeFileArray = null;
        if (UnixNativeFile.isImplemented()) {
            stringArray = UnixNativeFile.getMountedFileSystems();
        } else if (WindowsNativeFile.isImplemented()) {
            stringArray = WindowsNativeFile.getMountedFileSystems();
        }
        if (stringArray != null) {
            nativeFileArray = new NativeFile[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nativeFileArray[i] = new NativeFile(stringArray[i]);
            }
        }
        return nativeFileArray;
    }

    public long getFreeSpace() throws AccessDeniedException, NativeFileIOException {
        long l = 0L;
        if (this.exists()) {
            if (UnixNativeFile.isImplemented()) {
                l = UnixNativeFile.getFreeSpace(this.getAbsolutePath());
            } else if (WindowsNativeFile.isImplemented()) {
                NativeFile nativeFile = this;
                l = !nativeFile.isDirectory() ? ((nativeFile = this.getParentNativeFile()) != null ? nativeFile.getFreeSpace() : 0L) : WindowsNativeFile.getFreeSpace(nativeFile.getAbsolutePath());
            }
        } else {
            NativeFile nativeFile = this.getParentNativeFile();
            l = nativeFile != null ? nativeFile.getFreeSpace() : 0L;
        }
        return l;
    }

    public long getFileSystemSize() throws AccessDeniedException, NativeFileIOException {
        long l = 0L;
        if (this.exists()) {
            if (UnixNativeFile.isImplemented()) {
                l = UnixNativeFile.getFileSystemSize(this.getAbsolutePath());
            } else if (WindowsNativeFile.isImplemented()) {
                NativeFile nativeFile = this;
                l = !nativeFile.isDirectory() ? ((nativeFile = this.getParentNativeFile()) != null ? nativeFile.getFileSystemSize() : 0L) : WindowsNativeFile.getFileSystemSize(nativeFile.getAbsolutePath());
            }
        } else {
            NativeFile nativeFile = this.getParentNativeFile();
            l = nativeFile != null ? nativeFile.getFileSystemSize() : 0L;
        }
        return l;
    }

    public static synchronized boolean initializeLibrary(File file) {
        boolean bl = false;
        if (NativeFile.isNativeFileFunctionalityAvailable()) {
            bl = true;
        } else {
            String string = System.getProperty("os.name");
            if (string != null) {
                string = string.toLowerCase();
            }
            bl = string.startsWith("window") ? WindowsNativeFile.initializeLibrary(file) : UnixNativeFile.initializeLibrary(file);
        }
        return bl;
    }

    public static synchronized boolean initializeLibrary(File file, String string, boolean bl) {
        boolean bl2 = false;
        if (NativeFile.isNativeFileFunctionalityAvailable()) {
            bl2 = true;
        } else {
            String string2 = System.getProperty("os.name");
            if (string2 != null) {
                string2 = string2.toLowerCase();
            }
            if (string != null && string.trim().equals("")) {
                string = null;
            }
            bl2 = string2.startsWith("window") ? WindowsNativeFile.initializeLibrary(file, string, bl) : UnixNativeFile.initializeLibrary(file, string, bl);
        }
        return bl2;
    }
}

