/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages.licensePanel;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionAddPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageData;
import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageDataContext;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.ConLicenseNotAcceptedPage;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.ConLicenseViewPage;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.Messages;
import com.ibm.cic.common.core.console.views.AConViewRadioList;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ConLicensePage
extends AConPage {
    LicensePageDataContext context;
    private final Parameters p;

    public ConLicensePage(IConManager manager, Parameters params) {
        super(manager);
        this.p = params;
    }

    @Override
    public void init() {
        super.init();
        this.setHeaderView(Messages.ConLicensePage_licensePageBanner);
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.clear();
        this.createContents(this);
        super.present(a_output);
    }

    @Override
    public boolean isPageComplete() {
        Boolean b;
        if (this.context != null && (b = this.context.getLicenseData().isAccepted()) != null) {
            return b;
        }
        return false;
    }

    @Override
    public boolean skipPage() {
        this.context = this.conManager().getDataContext(LicensePageDataContext.class);
        return this.context == null || !this.context.getLicenseData().hasLicenses();
    }

    protected void createContents(ConViewGroup contents) {
        this.context = this.conManager().getDataContext(LicensePageDataContext.class);
        if (this.context == null) {
            return;
        }
        contents.addView(new ConViewText(CommonSharedUIUtils.removeAmpersand((String)LicensePageData.getReadCarefullyStatement())));
        ConViewListNumbered mainList = new ConViewListNumbered(Messages.ConLicensePage_viewLicenseListHeader);
        List<LicensePageData.ILicenseNode> entries = ConLicensePage.getEntries(this.context.getLicenseData());
        for (LicensePageData.ILicenseNode licenseNode : entries) {
            this.addLicenseEntry(mainList, licenseNode);
        }
        contents.addView(mainList);
        AConViewRadioList radioList = new AConViewRadioList(Messages.ConLicensePage_options, true){

            @Override
            protected int getSelectedIndex() {
                Boolean accepted = ConLicensePage.this.context.getLicenseData().isAccepted();
                int index = -1;
                if (accepted != null) {
                    index = accepted != false ? 0 : 1;
                }
                return index;
            }

            @Override
            protected void onSelectedIndex(int index) {
                ConLicensePage.this.context.getLicenseData().setAccepted(index == 0);
            }
        };
        radioList.addEntry(CommonSharedUIUtils.removeAmpersand((String)LicensePageData.getAcceptanceStatement(entries.size() > 1)), ConCommonCommandKeys.keys_Accept, AConActionEntry.NO_ACTION);
        if (this.p.declineConsequences != null) {
            radioList.addEntry(CommonSharedUIUtils.removeAmpersand((String)LicensePageData.getDeclinedStatement(entries.size() > 1)), ConCommonCommandKeys.keys_Decline, (AConActionEntry)new ConActionDoesNotAcceptLicense());
        } else {
            radioList.addEntry(CommonSharedUIUtils.removeAmpersand((String)LicensePageData.getDeclinedStatement(entries.size() > 1)), ConCommonCommandKeys.keys_Decline, AConActionEntry.NO_ACTION);
        }
        contents.addView(radioList);
    }

    private void addLicenseEntry(ConViewListNumbered list, LicensePageData.ILicenseNode licenseNode) {
        list.addEntry(this.licenseConsoleName(licenseNode), new ConActViewLicense(licenseNode));
    }

    private static String consoleName(List<String> names) {
        String prev = null;
        ArrayList<String> keepers = new ArrayList<String>(names.size());
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            if (prev == null || !name.equals(prev)) {
                keepers.add(name);
                prev = name;
            }
            ++i;
        }
        return ConLicensePage.format(keepers);
    }

    private static String format(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String licenseConsoleName(LicensePageData.ILicenseNode licenseNode) {
        ArrayList<LicensePageData.IGroupingNode> contextList = new ArrayList<LicensePageData.IGroupingNode>();
        this.getGroups(contextList, licenseNode.getParentNode());
        if (contextList.isEmpty()) {
            return licenseNode.getLicense().getLicenseLabel();
        }
        ArrayList<String> list = new ArrayList<String>(contextList.size() + 1);
        for (LicensePageData.IGroupingNode gn : contextList) {
            list.add(gn.toString());
        }
        list.add(licenseNode.getLicense().getLicenseLabel());
        return ConLicensePage.consoleName(list);
    }

    private void getGroups(List<LicensePageData.IGroupingNode> contextList, LicensePageData.IGroupingNode node) {
        if (node != null) {
            contextList.add(0, node);
            this.getGroups(contextList, node.getParentNode());
        }
    }

    private static List<LicensePageData.ILicenseNode> getEntries(LicensePageData licenseData) {
        LinkedList<LicensePageData.ILicenseNode> entries = new LinkedList<LicensePageData.ILicenseNode>();
        Collection<LicensePageData.IGroupingNode> rootNodes = licenseData.getRootNodes();
        for (LicensePageData.IGroupingNode gn : rootNodes) {
            ConLicensePage.addEntry(entries, gn);
        }
        return entries;
    }

    private static void addEntry(List<LicensePageData.ILicenseNode> entries, LicensePageData.IGroupingNode gn) {
        LicensePageData.ILicenseNode[] ln = gn.getLicenses();
        ArrayList<LicensePageData.ILicenseNode> list = new ArrayList<LicensePageData.ILicenseNode>(Arrays.asList(ln));
        Collections.sort(list, new Comparator<LicensePageData.ILicenseNode>(){

            @Override
            public int compare(LicensePageData.ILicenseNode o1, LicensePageData.ILicenseNode o2) {
                int r2;
                int r1 = LicensePageData.sortRanking(o1);
                if (r1 != (r2 = LicensePageData.sortRanking(o2))) {
                    return r1 - r2;
                }
                return o1.getLicense().getLicenseLabel().compareTo(o2.getLicense().getLicenseLabel());
            }
        });
        entries.addAll(list);
        for (LicensePageData.IGroupingNode gn2 : gn.getSubGroups()) {
            ConLicensePage.addEntry(entries, gn2);
        }
    }

    private class ConActViewLicense
    extends ConActionAddPage {
        private final LicensePageData.ILicenseNode licenseNode;

        public ConActViewLicense(LicensePageData.ILicenseNode licenseNode) {
            this.licenseNode = licenseNode;
        }

        @Override
        public void run(IConManager a_conManager) {
            super.run(a_conManager);
        }

        @Override
        protected AConPage createNewPage(IConManager a_manager) {
            ConLicenseViewPage newPage = new ConLicenseViewPage(a_manager, ConLicensePage.this.p.cancelAction, this.licenseNode);
            return newPage;
        }
    }

    private class ConActionDoesNotAcceptLicense
    extends ConActionAddPage {
        @Override
        protected AConPage createNewPage(IConManager a_manager) {
            return new ConLicenseNotAcceptedPage(a_manager, ConLicensePage.this.p.cancelAction, ConLicensePage.this.p.declineConsequences);
        }
    }

    public static class Parameters {
        private String declineConsequences;
        private final AConActionEntry cancelAction;

        public Parameters(AConActionEntry cancelAction, String declineConsequences) {
            this.cancelAction = cancelAction;
            this.declineConsequences = declineConsequences;
        }

        public String getDeclineConsequences() {
            return this.declineConsequences;
        }

        public void setDeclineConsequences(String declineConsequences) {
            this.declineConsequences = declineConsequences;
        }

        public AConActionEntry getCancelAction() {
            return this.cancelAction;
        }
    }
}

