/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages;

import com.ibm.cic.common.core.console.manager.AConManager;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.manager.ConCredentialPromptManager;
import com.ibm.cic.common.core.console.shared.pages.ConCredentialPrompterPage;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConCredentialPrompter
implements ICredentialPrompter {
    private static final Logger log = Logger.getLogger(ConCredentialPrompter.class);
    private static IConIO m_overrideConIO;
    private final String application;

    public ConCredentialPrompter(String application) {
        this.application = application;
    }

    public static void setOverrideConIO(IConIO a_overrideConIO) {
        m_overrideConIO = a_overrideConIO;
    }

    public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous, CredentialInfo[] ret) {
        CredPrompterConManager conManager = new CredPrompterConManager(this.application);
        ConCredentialPromptManager c = new ConCredentialPromptManager(this.application, validator, connectMessage, requested, previous);
        c.startConversation();
        conManager.setDataContext(c);
        IStatus consoleStatus = conManager.run();
        log.statusNotOK(consoleStatus);
        IStatus status = c.getOkStatus();
        if (status == null) {
            return Status.CANCEL_STATUS;
        }
        if (status.isOK()) {
            ret[0] = c.getCredentialInfo();
        }
        return status;
    }

    static class CredPrompterConManager
    extends AConManager {
        public CredPrompterConManager(String application) {
            super(m_overrideConIO, application);
        }

        @Override
        protected AConPage getWelcomePage() {
            return new ConCredentialPrompterPage(this);
        }
    }
}

