/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.IVariableProvider;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.EclipseInstallAdaptor;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;

public class EclipseVariableProvider
implements IVariableProvider {
    private static final Logger log = Logger.getLogger(EclipseVariableProvider.class);

    public String substitute(SubstitutionOperation operation, String variableName, String variableArg) {
        String path = null;
        if (operation == null) {
            return null;
        }
        if (variableName.equals("eclipseIdeLocation")) {
            path = this.getEclipseIdeLocation(operation, variableArg);
        } else if (variableName.equals("eclipseJreLocation")) {
            path = this.getEclipseJreLocation(operation, variableArg);
        } else if (variableName.equals("eclipseLauncher")) {
            path = this.getEclipseLauncher(operation, variableArg);
        } else if (variableName.equals("bundleLocation")) {
            path = this.getBundleLocation(operation, variableArg);
        }
        if (path != null) {
            return operation.makeRelativeToContextLocationInPortableMode(path, AbstractVariableSubstitution.AllowAbsolutePath.FALSE);
        }
        return path;
    }

    private String getEclipseIdeLocation(SubstitutionOperation operation, String variableArg) {
        InstallContext eclipseContext = this.getDefaultEclipseContext(operation.getProfile());
        if (eclipseContext != null) {
            String eclipseIdeLocation = eclipseContext.getProperty("installLocation");
            return this.getRelativeOrCanonicalLocation(eclipseIdeLocation);
        }
        return null;
    }

    private String getEclipseJreLocation(SubstitutionOperation operation, String variableArg) {
        String jreLocation;
        Profile profile = operation.getProfile();
        String installPackagedJre = profile.getData("install.packaged.jre.for.eclipse.ide");
        if (!Boolean.valueOf(installPackagedJre).booleanValue() && (jreLocation = profile.getData("existing.jre.for.eclipse.ide.java.home")) != null) {
            return this.getRelativeOrCanonicalLocation(jreLocation);
        }
        InstallContext eclipseContext = this.getDefaultEclipseContext(profile);
        if (eclipseContext != null) {
            try {
                ConfigurationContributorEditor editor = EclipseInstallAdaptor.getConfigurationEditor(eclipseContext);
                jreLocation = this.getJreLocationFromConfiguration(editor);
            }
            catch (CoreException ce) {
                log.error((Throwable)ce);
                return null;
            }
            if (jreLocation != null) {
                return this.getRelativeOrCanonicalLocation(jreLocation);
            }
        }
        if (variableArg != null) {
            return this.getRelativeOrCanonicalLocation(variableArg);
        }
        return null;
    }

    private String getEclipseLauncher(SubstitutionOperation operation, String variableArg) {
        ConfigurationContributorEditor editor;
        String configLocation;
        InstallContext context = operation.getInstallContext();
        String string = configLocation = context == null ? null : context.getLocation("configLocation");
        if (configLocation == null) {
            context = this.getDefaultEclipseContext(operation.getProfile());
        }
        if (context == null) {
            return null;
        }
        try {
            editor = EclipseInstallAdaptor.getConfigurationEditor(context);
        }
        catch (CoreException ce) {
            log.error((Throwable)ce);
            return null;
        }
        String launcher = editor.getLauncher();
        if (launcher == null) {
            return null;
        }
        return this.getRelativeOrCanonicalLocation(launcher);
    }

    private String getBundleLocation(SubstitutionOperation operation, String variableArg) {
        URL url;
        ConfigurationContributorEditor editor;
        String configLocation;
        if (variableArg == null) {
            return null;
        }
        InstallContext context = operation.getInstallContext();
        String string = configLocation = context == null ? null : context.getLocation("configLocation");
        if (configLocation == null) {
            context = this.getDefaultEclipseContext(operation.getProfile());
        }
        if (context == null || context.isP2Managed()) {
            return null;
        }
        try {
            editor = EclipseInstallAdaptor.getConfigurationEditor(context);
        }
        catch (CoreException ce) {
            log.error((Throwable)ce);
            return null;
        }
        String bundleLocation = editor.findBundleLocation(variableArg);
        if (bundleLocation == null) {
            return null;
        }
        try {
            url = new URL(bundleLocation);
        }
        catch (MalformedURLException e) {
            log.error((Throwable)e);
            return null;
        }
        return this.getRelativeOrCanonicalLocation(url.getFile());
    }

    private String getJreLocationFromConfiguration(ConfigurationEditor editor) {
        File jreDir;
        File binDir;
        File installLocation;
        String vmLocation = editor.getVMLocation();
        if (vmLocation == null) {
            return null;
        }
        File javaExe = new File(vmLocation);
        if (!javaExe.isAbsolute() && (installLocation = editor.getInstallLocation()) != null) {
            javaExe = new File(installLocation, vmLocation);
        }
        if ((binDir = javaExe.getParentFile()) == null) {
            return null;
        }
        if (!binDir.getName().equalsIgnoreCase("bin")) {
            File dir;
            jreDir = new File(binDir, "jre");
            if (jreDir.isDirectory()) {
                return jreDir.getPath();
            }
            do {
                if ((binDir = binDir.getParentFile()) != null) continue;
                log.error("getJreLocationFromConfiguration(): cannot find location of java exe for this JVM: \"{0}\"", new Object[]{vmLocation});
                return null;
            } while (!(dir = new File(binDir, "bin")).isDirectory());
            binDir = dir;
        }
        if ((jreDir = binDir.getParentFile()) == null) {
            return null;
        }
        return jreDir.getPath();
    }

    private InstallContext getDefaultEclipseContext(Profile profile) {
        String contextId = profile.getData("eclipseContext");
        return profile.findInstallContext(contextId);
    }

    private String getCanonicalLocation(String location) {
        File f = new File(location);
        try {
            return f.getCanonicalPath();
        }
        catch (Exception e) {
            return f.getPath();
        }
    }

    private String getRelativeOrCanonicalLocation(String location) {
        if (new File(location).isAbsolute()) {
            return this.getCanonicalLocation(location);
        }
        return location;
    }
}

