/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.AbstractInstallAdaptor;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.eclipse.qualification.EclipseQualificationOperation;
import com.ibm.cic.agent.internal.eclipse.qualification.NewOfferingQualificationOperation;
import com.ibm.cic.agent.internal.eclipse.qualification.NewProfileInitializationOperation;
import com.ibm.cic.agent.internal.eclipse.qualification.NewProfileQualificationOperation;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationConstants;
import com.ibm.cic.agent.internal.installAdaptors.AddProgramArgsOperation;
import com.ibm.cic.agent.internal.installAdaptors.AddVMArgumentsOperation;
import com.ibm.cic.agent.internal.installAdaptors.BundleManager;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationValidator;
import com.ibm.cic.agent.internal.installAdaptors.ConfigureBundleOperation;
import com.ibm.cic.agent.internal.installAdaptors.ConfigureFeatureOperation;
import com.ibm.cic.agent.internal.installAdaptors.InstallAgentBundleOperation;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.agent.internal.installAdaptors.RemoveAgentBundleOperation;
import com.ibm.cic.agent.internal.installAdaptors.RestartConfigurationOperation;
import com.ibm.cic.agent.internal.installAdaptors.SetConfigurationPreferenceOperation;
import com.ibm.cic.agent.internal.installAdaptors.SetPropertyOperation;
import com.ibm.cic.agent.internal.installAdaptors.SetVMLocationOperation;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAddProgramArgumentsData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAddVMArgumentsData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.EclipseRestartData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetConfigPreferenceData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetPropertyData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetVirtualMachineData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class EclipseInstallAdaptor
extends AbstractInstallAdaptor
implements IInstallAdaptor,
ConfigurationConstants {
    private static final Logger log = Logger.getLogger(EclipseInstallAdaptor.class);
    private static Map configEditors = new HashMap();
    private static BundleManager bundleManager = new BundleManager();
    private static final AgentJob[] EMPTY_JOBS = new AgentJob[0];
    private AgentJob[] sessionJobs = EMPTY_JOBS;

    public String getId() {
        return "eclipse";
    }

    public IStatus restart(InstallContext context) {
        IStatus status = this.isValidEclipseContext(context);
        if (status.isOK()) {
            try {
                this.restart(EclipseInstallAdaptor.getConfigurationEditor(context));
            }
            catch (CoreException ce) {
                return ce.getStatus();
            }
        }
        return status;
    }

    public IStatus initialize(InstallContext context) {
        if (context.isP2Managed()) {
            configEditors.remove(context);
        }
        return this.isValidEclipseContext(context);
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        if (!pair.isUninstall()) {
            return this.install(pair.getTo(), context, monitor);
        }
        return null;
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        if (!pair.isInstall()) {
            result.add(this.configure(pair.getFrom(), context, true, pm.next()));
        }
        if (!pair.isUninstall()) {
            result.add(this.configure(pair.getTo(), context, false, pm.next()));
        }
        pm.done();
        return result;
    }

    public IStatus complete(InstallContext context, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{99, 1});
        try {
            ConfigurationContributorEditor editor = (ConfigurationContributorEditor)configEditors.get(context);
            if (editor != null) {
                boolean planVerifierInstalled;
                editor.setIsModifyJob(false);
                AgentJob[] agentJobArray = this.sessionJobs;
                int n = this.sessionJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob sessionJob = agentJobArray[n2];
                    if (sessionJob.getProfile() == context.getEnclosingProfile()) {
                        editor.setIsModifyJob(sessionJob.isModify());
                    }
                    ++n2;
                }
                editor.setPlanVerifierState(planVerifierInstalled, (planVerifierInstalled = editor.isPlanVerifierInstalled()) && !this.planVerifierShouldBeDisabledAfterInstall(context));
                editor.setPlanVerifierDisabledDuringReconcile(!planVerifierInstalled || !context.isAdaptorTransactionUndoable());
            }
            this.saveDirtyEditor(editor, context, pm.next());
            if (this.configurationIsEmpty(context, editor)) {
                File configLocation = editor.getConfigurationLocation();
                boolean removedConfigurator = FileUtil.rm_r((File)new File(configLocation, "org.eclipse.update"), (boolean)true);
                boolean createdConfigLocation = context.createdDirectory(configLocation);
                if (removedConfigurator && createdConfigLocation) {
                    String element;
                    String[] stringArray = configDirsToDelete;
                    int n = configDirsToDelete.length;
                    int n3 = 0;
                    while (n3 < n) {
                        element = stringArray[n3];
                        FileUtil.rm_r((File)new File(configLocation, element), (boolean)true);
                        ++n3;
                    }
                    stringArray = configFilesToDelete;
                    n = configFilesToDelete.length;
                    n3 = 0;
                    while (n3 < n) {
                        element = stringArray[n3];
                        FileUtil.delete((File)new File(configLocation, element));
                        ++n3;
                    }
                    File[] logFiles = configLocation.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".log");
                        }
                    });
                    int i = 0;
                    while (logFiles != null && i < logFiles.length) {
                        FileUtil.delete((File)logFiles[i]);
                        ++i;
                    }
                    Util.deleteEmptyDirs((File)configLocation);
                    if (!context.isP2Managed()) {
                        if (editor.getP2DataArea() != null) {
                            FileUtil.rm_r((File)editor.getP2DataArea(), (boolean)true);
                        }
                        if (editor.getBundles().length == 0) {
                            FileUtil.rm_r((File)new File(editor.getInstallLocation(), "p2"), (boolean)true);
                        }
                    }
                    FileUtil.delete((File)new File(editor.getLauncherLocation(), String.valueOf(editor.getLauncherName()) + ".ini"));
                }
            } else if (AgentUserOptions.CIC_FAIL_ON_INVALID_ECLIPSE_CONFIGURATION.isSet()) {
                IStatus iStatus = this.validateConfiguration(context, 4, pm.next());
                return iStatus;
            }
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        catch (IOException ioe) {
            log.warning(ioe.getLocalizedMessage(), new Object[]{ioe});
        }
        finally {
            pm.done();
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean planVerifierShouldBeDisabledAfterInstall(InstallContext context) {
        block7: {
            IOfferingOrFix[] offerings;
            Profile profile;
            block6: {
                profile = context.getEnclosingProfile();
                if (!context.isAdaptorTransactionUndoing()) break block6;
                IOffering[] offerings2 = profile.getInstalledOfferings();
                int i = 0;
                while (i < offerings2.length) {
                    if (!OfferingProperty.isPlanVerifierEnabled((IOffering)offerings2[i])) {
                        return true;
                    }
                    ++i;
                }
                break block7;
            }
            ArrayList<AgentJob> profileJobs = new ArrayList<AgentJob>();
            AgentJob[] agentJobArray = this.sessionJobs;
            int n = this.sessionJobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob sessionJob = agentJobArray[n2];
                if (profile == sessionJob.getProfile()) {
                    profileJobs.add(sessionJob);
                }
                ++n2;
            }
            if (profileJobs.size() == 0) break block7;
            IOfferingOrFix[] iOfferingOrFixArray = offerings = AgentUtil.getResultingOfferingsAndFixes((IProfile)profile, (AgentJob[])profileJobs.toArray(new AgentJob[profileJobs.size()]), (boolean)false);
            int n3 = offerings.length;
            n = 0;
            while (n < n3) {
                IOffering offering;
                IOfferingOrFix offering2 = iOfferingOrFixArray[n];
                if (offering2 instanceof IOffering && !OfferingProperty.isPlanVerifierEnabled((IOffering)(offering = (IOffering)offering2))) {
                    log.info(NLS.bind((String)Messages.EclipseInstallAdaptor_plan_verifier_disabled, (Object)profile.getProfileId()));
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean configurationIsEmpty(InstallContext context, ConfigurationContributorEditor editor) {
        Profile profile = context.getEnclosingProfile();
        if (profile.isExistingEclipseProfile()) {
            return false;
        }
        if (Agent.getInstance().isAgentUninstallingItself()) {
            return false;
        }
        if (editor == null || editor.reconcilerError) {
            return false;
        }
        if (editor.isEmpty()) {
            return true;
        }
        return AgentUtil.isFinalUninstall((Profile)profile, (AgentJob[])this.sessionJobs);
    }

    public IStatus qualify(AgentJob[] jobs, InstallContextTree rootContext, Profile profile, IProgressMonitor monitor) {
        if (!profile.isExistingEclipseProfile()) {
            return Status.OK_STATUS;
        }
        if (this.isP2Content(jobs) && AgentUserOptions.CIC_AGENT_P2_ENABLED.isSet()) {
            return Status.OK_STATUS;
        }
        String contextId = profile.getData("eclipseContext");
        InstallContextTree contextTree = rootContext.findSubContext(contextId);
        if (contextTree == null) {
            return Status.OK_STATUS;
        }
        EclipseQualificationOperation op = new EclipseQualificationOperation(jobs, profile, contextId, contextTree);
        return op.qualify(monitor);
    }

    public IStatus qualifyNewProfile(Profile profile) {
        IStatus status = Status.OK_STATUS;
        String profileKind = profile.getProfileKind();
        if (!"product".equals(profileKind)) {
            return status;
        }
        NewProfileQualificationOperation op = new NewProfileQualificationOperation(profile);
        return op.qualifyNewProfile();
    }

    public IStatus initializeNewProfile(Profile profile) {
        IStatus status = Status.OK_STATUS;
        String profileKind = profile.getProfileKind();
        if (!"existingEclipse".equals(profileKind)) {
            return status;
        }
        NewProfileInitializationOperation op = new NewProfileInitializationOperation(profile);
        return op.initializeNewProfile();
    }

    public IStatus qualifyNewOffering(Profile profile, IOffering offering) {
        if (!profile.isExistingEclipseProfile()) {
            return Status.OK_STATUS;
        }
        NewOfferingQualificationOperation op = new NewOfferingQualificationOperation(profile, offering);
        return op.qualifyNewOffering();
    }

    public IStatus preInstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        this.sessionJobs = jobs;
        this.forgetAllEditors();
        return Status.OK_STATUS;
    }

    public IStatus postInstallSession(AgentJob[] jobs, IStatus sessionStatus, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (!StatusUtil.isErrorOrCancel((IStatus)sessionStatus)) {
            status = this.doPostSessionWork(jobs, monitor);
        }
        this.forgetAllEditors();
        this.sessionJobs = EMPTY_JOBS;
        return status;
    }

    public IStatus preUninstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        this.sessionJobs = jobs;
        this.forgetAllEditors();
        return Status.OK_STATUS;
    }

    public IStatus postUninstallSession(AgentJob[] jobs, IStatus sessionStatus, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (!StatusUtil.isErrorOrCancel((IStatus)sessionStatus)) {
            status = this.doPostSessionWork(jobs, monitor);
        }
        this.forgetAllEditors();
        this.sessionJobs = EMPTY_JOBS;
        return status;
    }

    public IStatus completeSession(AgentJob[] jobs, IProgressMonitor monitor) {
        if (!AgentUserOptions.shouldUnloadBundlesOnExitOnly()) {
            this.unloadAgentBundles(monitor);
        }
        return Status.OK_STATUS;
    }

    public IStatus stop(IProgressMonitor monitor) {
        this.unloadAgentBundles(monitor);
        return Status.OK_STATUS;
    }

    private void unloadAgentBundles(IProgressMonitor monitor) {
        RemoveAgentBundleOperation removeBundlesOp = new RemoveAgentBundleOperation(bundleManager);
        removeBundlesOp.perform(monitor);
    }

    private IStatus install(IInstallableUnit unit, InstallContext context, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus(Messages.EclipseInstallAdaptor_problems_installing_ius, new Object[0]);
        EclipseAdapterData data = (EclipseAdapterData)unit.getAdapterData();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, data.getArtifacts().size());
        for (EclipseArtifact artifact : data.getArtifacts()) {
            try {
                File location = CacheManager.getDefaultInstance().getArtifactLocation(unit, (IArtifact)artifact, pm.next());
                if (artifact.getType() == 1) {
                    result.add(this.installRootFiles(location, context));
                }
            }
            catch (CacheManager.CacheManagerException e) {
                if (e.getStatus().matches(8)) {
                    return e.getStatus();
                }
                String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_error_getting_artifact_location, (Object)e.getMessage());
                Status status = new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e);
                result.add((IStatus)status);
            }
            monitor.worked(1);
        }
        monitor.done();
        return result;
    }

    private IStatus installRootFiles(File zip, InstallContext context) {
        String rootLocation = context.getInstallLocation();
        boolean sync = true;
        return Util.unzipFile((boolean)true, (File)zip, (File)new File(rootLocation), (boolean)sync);
    }

    /*
     * Unable to fully structure code
     */
    private IStatus configure(IInstallableUnit unit, InstallContext context, boolean unconfigure, IProgressMonitor monitor) {
        block10: {
            adapterData = (EclipseAdapterData)unit.getAdapterData();
            artifacts = adapterData.getArtifacts();
            elements = adapterData.getDataElements();
            monitor.beginTask("", elements.size());
            eclipseData = elements.toArray(new IEclipseData[elements.size()]);
            result = Statuses.ST.createMultiStatus();
            try {
                index = 0;
                while (index < eclipseData.length) {
                    block9: {
                        try {
                            this.doConfiguration(artifacts, unit, context, eclipseData[index], unconfigure, monitor);
                            monitor.worked(1);
                            break block9;
                        }
                        catch (CoreException ce) {
                            result.add(ce.getStatus());
                            if (!result.isErrorOrCancel()) break block9;
                            if (index <= 0) break block10;
                            undex = index - 1;
                            ** while (undex >= 0)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                this.doConfiguration(artifacts, unit, context, eclipseData[undex], unconfigure == false, monitor);
                            }
                            catch (CoreException nestedCE) {
                                EclipseInstallAdaptor.log.error((Throwable)nestedCE);
                            }
                            --undex;
                            continue;
lbl28:
                            // 1 sources

                            break;
                        }
                    }
                    ++index;
                }
            }
            finally {
                monitor.done();
            }
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    public IStatus isValidEclipseContext(InstallContext context) {
        if (context == null) {
            return Status.OK_STATUS;
        }
        String configLocation = context.getLocation("configLocation");
        if (context.allowsAdaptorType("eclipse") && (configLocation == null || configLocation.trim().length() == 0)) {
            String msg = NLS.bind((String)Messages.EclipseInstallAdaptor_configuration_location_not_set, (Object)context.getName(), (Object)context.getEnclosingProfile().getProfileId());
            return new Status(4, Agent.PI_AGENT, 1, msg, null);
        }
        return Status.OK_STATUS;
    }

    public static ConfigurationContributorEditor getConfigurationEditor(InstallContext context) throws CoreException {
        ConfigurationContributorEditor editor = (ConfigurationContributorEditor)configEditors.get(context);
        if (editor == null) {
            String configLocation = context.getLocation("configLocation");
            File configDir = new File(configLocation);
            editor = new ConfigurationContributorEditor(configDir, PlatformUtils.getLauncherLocation((String)context.getInstallLocation()), null, context);
            editor.setAgentSelfConfiguration(context.getEnclosingProfile().isAgentProfile());
            editor.setIsP2Managed(context.isP2Managed());
            configEditors.put(context, editor);
        }
        return editor;
    }

    private void forgetAllEditors() {
        configEditors.clear();
    }

    private void saveDirtyEditor(ConfigurationContributorEditor editor, InstallContext context, IProgressMonitor monitor) throws CoreException {
        if (editor != null && editor.isDirty()) {
            boolean isAgentConfig = context.getEnclosingProfile().isAgentProfile();
            boolean platformXmlDirty = editor.isPlatformXmlDirty();
            if (editor.isRunning() && !isAgentConfig) {
                context.setNeedsRestart(true);
            }
            editor.save(monitor);
            if (isAgentConfig && platformXmlDirty && !editor.configurationIsEmpty()) {
                this.fixAgentPlatformXml(editor, context);
            }
        }
    }

    private void fixAgentPlatformXml(ConfigurationContributorEditor editor, InstallContext context) throws CoreException {
        if (System.getProperty("SKIP_AGENT_PLATFORM_XML_FIXUP_IN_INSTALLER") != null) {
            return;
        }
        Profile profile = context.getEnclosingProfile();
        SimpleIdentity identity = new SimpleIdentity("com.ibm.cic.agent");
        IOffering offering = Agent.getInstance().findInstalledOffering((IProfile)profile, (IIdentity)identity);
        if (offering == null) {
            return;
        }
        Version internalVersion111 = new Version(1, 1, 1000);
        if (internalVersion111.compareTo(offering.getVersion()) <= 0) {
            return;
        }
        editor.fixAgentPlatformXml();
    }

    private boolean suppressPostSessionWork(Profile profile) {
        if (!profile.isAgentProfile()) {
            return false;
        }
        if (System.getProperty("FORCE_AGENT_CONFIGURATION_VALIDATION") != null) {
            return false;
        }
        SimpleIdentity identity = new SimpleIdentity("com.ibm.cic.agent");
        IOffering[] offerings = Agent.getInstance().getInstalledOfferings(profile, (IIdentity)identity);
        if (offerings == null || offerings.length == 0) {
            if (!Agent.getInstance().isAgentUninstallingItself()) {
                FileUtil.rm_r((File)new File(profile.getInstallLocation()), (boolean)true);
            }
            return true;
        }
        Version internalVersion1004 = new Version(1, 0, 4);
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            Version version = offering.getVersion();
            if (internalVersion1004.compareTo(version) > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IStatus doPostSessionWork(AgentJob[] jobs, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, jobs.length);
        HashSet<Profile> seenBefore = new HashSet<Profile>();
        try {
            if (Agent.getInstance().isSkipInstall()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                Profile profile = job.getProfile();
                IProgressMonitor nextMonitor = pm.next();
                if (!seenBefore.contains(profile)) {
                    seenBefore.add(profile);
                    if (!this.suppressPostSessionWork(profile)) {
                        SplitProgressMonitor spm = new SplitProgressMonitor(nextMonitor, 2);
                        IStatus status = this.initializeP2Profile(profile, spm.next());
                        if (!status.isOK()) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                        status = this.validateProfileState(profile, spm.next());
                        if (!status.isOK()) {
                            IStatus iStatus = status;
                            return iStatus;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus initializeP2Profile(Profile profile, IProgressMonitor monitor) {
        InstallContext[] installContexts = profile.getAllInstallContexts();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, installContexts.length);
        try {
            InstallContext[] installContextArray = installContexts;
            int n = installContexts.length;
            int n2 = 0;
            while (n2 < n) {
                InstallContext context = installContextArray[n2];
                IStatus status = this.initializeP2Context(context, pm.next());
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus initializeP2Context(InstallContext context, IProgressMonitor monitor) {
        ConfigurationContributorEditor editor;
        if (!context.isP2Managed()) {
            return Status.OK_STATUS;
        }
        configEditors.remove(context);
        try {
            editor = EclipseInstallAdaptor.getConfigurationEditor(context);
        }
        catch (CoreException e) {
            String configLocation = context.getLocation("configLocation");
            File configDir = new File(configLocation);
            return new Status(2, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseInstallAdaptor_problemLoadingEclipseConfiguration, (Object)configDir.toString(), (Object)e.toString()), (Throwable)e);
        }
        if (this.configurationIsEmpty(context, editor)) {
            return Status.OK_STATUS;
        }
        return editor.runInitialize(2, monitor);
    }

    private IStatus validateProfileState(Profile profile, IProgressMonitor monitor) {
        InstallContext[] installContexts = profile.getAllInstallContexts();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, installContexts.length);
        pm.subTask(NLS.bind((String)Messages.EclipseInstallAdaptor_validating_eclipse_configuration, (Object)profile.getProfileId()));
        try {
            InstallContext[] installContextArray = installContexts;
            int n = installContexts.length;
            int n2 = 0;
            while (n2 < n) {
                InstallContext context = installContextArray[n2];
                IStatus status = this.validateConfiguration(context, 2, pm.next());
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus validateConfiguration(InstallContext context, int severity, IProgressMonitor monitor) {
        if (context.isP2Managed()) {
            return Status.OK_STATUS;
        }
        ConfigurationContributorEditor editor = (ConfigurationContributorEditor)configEditors.get(context);
        if (editor == null) {
            return Status.OK_STATUS;
        }
        if (this.configurationIsEmpty(context, editor)) {
            return Status.OK_STATUS;
        }
        return ConfigurationValidator.validateConfiguration(editor, severity, monitor);
    }

    private void doConfiguration(Collection artifacts, IInstallableUnit unit, InstallContext context, IEclipseData data, boolean unconfigure, IProgressMonitor monitor) throws CoreException {
        ConfigurationContributorEditor targetedConfig;
        String dataKind = data.getDataKind();
        ConfigurationContributorEditor configurationContributorEditor = targetedConfig = !EclipseAgentBundleData.getKind().equals(dataKind) ? EclipseInstallAdaptor.getConfigurationEditor(context) : null;
        if (EclipseBundleData.getKind().equals(dataKind)) {
            ConfigureBundleOperation bundleOp = new ConfigureBundleOperation((EclipseBundleData)data, artifacts, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)bundleOp, monitor);
        } else if (EclipseAgentBundleData.getKind().equals(dataKind)) {
            InstallAgentBundleOperation agentOp = new InstallAgentBundleOperation((EclipseAgentBundleData)data, bundleManager, artifacts, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)agentOp, monitor);
        } else if (EclipseFeatureData.getKind().equals(dataKind)) {
            ConfigureFeatureOperation featureOp = new ConfigureFeatureOperation((EclipseFeatureData)data, artifacts, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)featureOp, monitor);
        } else if (EclipseSetVirtualMachineData.getKind().equals(dataKind)) {
            SetVMLocationOperation setvmOp = new SetVMLocationOperation((EclipseSetVirtualMachineData)data, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)setvmOp, monitor);
        } else if (EclipseAddProgramArgumentsData.getKind().equals(dataKind)) {
            AddProgramArgsOperation programArgsOp = new AddProgramArgsOperation((EclipseAddProgramArgumentsData)data, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)programArgsOp, monitor);
        } else if (EclipseAddVMArgumentsData.getKind().equals(dataKind)) {
            AddVMArgumentsOperation vmargsOp = new AddVMArgumentsOperation((EclipseAddVMArgumentsData)data, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)vmargsOp, monitor);
        } else if (EclipseSetPropertyData.getKind().equals(dataKind)) {
            SetPropertyOperation propertyOp = new SetPropertyOperation((EclipseSetPropertyData)data, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)propertyOp, monitor);
        } else if (EclipseSetConfigPreferenceData.getKind().equals(dataKind)) {
            SetConfigurationPreferenceOperation preferenceOp = new SetConfigurationPreferenceOperation((EclipseSetConfigPreferenceData)data, unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)preferenceOp, monitor);
        } else if (EclipseRestartData.getKind().equals(dataKind)) {
            RestartConfigurationOperation restartOp = new RestartConfigurationOperation(unit, context, targetedConfig, !unconfigure);
            context.performOperation((IInstallOperation)restartOp, monitor);
        } else {
            Assert.isTrue((boolean)false, (String)"Unexpected Eclipse Data object.");
        }
    }

    private void restart(ConfigurationContributorEditor targetedConfig) {
        try {
            if (targetedConfig.isRunning()) {
                new File(targetedConfig.getConfigurationLocation(), "restart").createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isP2Content(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            if (this.isP2Content((IContent)offeringOrFix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isP2Content(IContent content) {
        IContentRepository repository = RepositoryUtils.getContentRepository((IContent)content);
        return repository != null && repository.containsP2Repository(null);
    }
}

