/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.installAdaptors.AbstractPropertyContributorRegistry;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.common.core.utils.Util;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;

public class ConfigIniContributorRegistry
extends AbstractPropertyContributorRegistry {
    private static HashSet WRITE_ONCE_KEYS = ConfigurationEditor.getWriteOncePropertyKeys();
    private static HashSet LIST_KEYS = ConfigurationEditor.getListPropertyKeys();

    public ConfigIniContributorRegistry(InstallContext context) {
        super(new File(context.getAdapterStorage("eclipse"), "configIni.properties"));
    }

    public void applyMergedChanges(ConfigurationContributorEditor editor) {
        editor.setProperties((Properties)this.getMergedRegistry());
    }

    public void initialize(ConfigurationContributorEditor editor) throws CoreException {
        Properties current = editor.getProperties();
        if (this.load()) {
            this.addDelta(current);
        } else {
            this.addExisting(current);
        }
    }

    protected Map createMergedPropertyMap() {
        return new Properties();
    }

    protected String getMergedValue(String name, String currentValue, String newValue) {
        if (currentValue != null) {
            if (WRITE_ONCE_KEYS.contains(name)) {
                return currentValue;
            }
            if (LIST_KEYS.contains(name)) {
                LinkedHashSet set = new LinkedHashSet(Util.toOrderedSet((String)currentValue, (char)','));
                Set newSet = Util.toOrderedSet((String)newValue, (char)',');
                set.addAll(newSet);
                return Util.toString(set, (char)',');
            }
        }
        return newValue;
    }
}

