/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator;

import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import java.io.File;
import org.osgi.framework.Version;

public class ConfigurationUtil {
    private static final String PLUGINS = "plugins";
    private static final String OSGI_ID = "org.eclipse.osgi";

    public static boolean isPlatformBaseLocation(String location, File installLocation) {
        String installPath;
        File file;
        String filePath;
        return location.startsWith("file:") && (filePath = (file = new File(location.substring(5))).toString()).startsWith(installPath = String.valueOf(installLocation.toString()) + File.separatorChar + PLUGINS + File.separatorChar);
    }

    public static String computeOsgiFramework(BundleInfo[] bundles, File installLocation) {
        String framework = null;
        Version highestVersion = null;
        BundleInfo[] bundleInfoArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundle = bundleInfoArray[n2];
            if (OSGI_ID.equals(bundle.getSymbolicName())) {
                String bundleLocation = bundle.getLocation();
                if (highestVersion == null) {
                    framework = bundleLocation;
                    highestVersion = new Version(bundle.getVersion());
                } else {
                    Version currentVersion = new Version(bundle.getVersion());
                    if (currentVersion.compareTo(highestVersion) > 0) {
                        framework = bundleLocation;
                        highestVersion = currentVersion;
                    } else if (currentVersion.equals((Object)highestVersion) && ConfigurationUtil.isPlatformBaseLocation(bundleLocation, installLocation)) {
                        framework = bundleLocation;
                    }
                }
            }
            ++n2;
        }
        return framework;
    }
}

