/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.Version;

public class ModelUtils {
    private static final String FEATURE_DATA_KIND = EclipseFeatureData.getKind();
    private static final String BUNDLE_DATA_KIND = EclipseBundleData.getKind();

    public static boolean isBundle(IEclipseData data) {
        String dataKind = data.getDataKind();
        return BUNDLE_DATA_KIND.equals(dataKind);
    }

    public static boolean isFeature(IEclipseData data) {
        String dataKind = data.getDataKind();
        return FEATURE_DATA_KIND.equals(dataKind);
    }

    public static IEclipseData getBundleOrFeature(IInstallableUnit unit) {
        EclipseAdapterData data = (EclipseAdapterData)unit.getAdapterData();
        Collection dataElements = data.getDataElements();
        for (IEclipseData elem : dataElements) {
            if (!ModelUtils.isBundle(elem) && !ModelUtils.isFeature(elem)) continue;
            return elem;
        }
        return null;
    }

    public static String getBundleId(IInstallableUnit unit) {
        IEclipseData bundleOrFeature = ModelUtils.getBundleOrFeature(unit);
        return bundleOrFeature == null ? null : ModelUtils.getBundleId(bundleOrFeature);
    }

    public static String getFeatureId(IShareableEntity se) {
        EclipseFeatureData feature = ModelUtils.getFeature(se);
        if (feature == null) {
            return se.getIdentity().getId();
        }
        return feature.getId();
    }

    public static EclipseFeatureData getFeature(IShareableEntity se) {
        String seId = se.getIdentity().getId();
        if (!(se instanceof IShareableUnit)) {
            return null;
        }
        Version seVersion = se.getVersion();
        EclipseFeatureData feature = null;
        IShareableUnit su = (IShareableUnit)se;
        List ius = su.getInstallableUnits();
        for (IInstallableUnit unit : ius) {
            EclipseFeatureData f;
            IEclipseData bundleOrFeature;
            String adapterId = unit.getAdapterId();
            if (!adapterId.equals("eclipse") || (bundleOrFeature = ModelUtils.getBundleOrFeature(unit)) == null || !ModelUtils.isFeature(bundleOrFeature) || !ModelUtils.matchingIds(seId, (f = (EclipseFeatureData)bundleOrFeature).getId()) || VersionUtil.compareToIgnoreQualifier((Version)seVersion, (Version)f.getVersion()) != 0) continue;
            if (feature != null) {
                return null;
            }
            feature = (EclipseFeatureData)bundleOrFeature;
        }
        return feature;
    }

    public static IShareableUnit findOfferingShareableUnitWithHighestVersion(IOffering offering, String suId) {
        IShareableUnit result = null;
        IAssembly assembly = offering.getAssembly();
        if (assembly == null) {
            return null;
        }
        ContentCollection shareableEntities = new ContentCollection((IContent)assembly);
        for (Object se : shareableEntities) {
            IShareableUnit su;
            if (!(se instanceof IShareableUnit) || !suId.equals((su = (IShareableUnit)se).getIdentity().getId())) continue;
            if (result == null) {
                result = su;
                continue;
            }
            if (su.getVersion().compareTo(result.getVersion()) <= 0) continue;
            result = su;
        }
        return result;
    }

    private static String getBundleId(IEclipseData bundleOrFeature) {
        if (ModelUtils.isBundle(bundleOrFeature)) {
            EclipseBundleData bundleData = (EclipseBundleData)bundleOrFeature;
            return bundleData.getId();
        }
        return null;
    }

    private static boolean matchingIds(String suId, String featureId) {
        return suId.equals(featureId) || suId.equals(String.valueOf(featureId) + ".feature");
    }
}

