/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.eclipse.qualification.BundleDetails;
import com.ibm.cic.agent.internal.eclipse.qualification.EclipseQualificationHistory;
import com.ibm.cic.agent.internal.eclipse.qualification.ModelUtils;
import com.ibm.cic.agent.internal.eclipse.qualification.PlatformConfigurationState;
import com.ibm.cic.agent.internal.eclipse.qualification.ShareableEntityRef;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.FeatureInfo;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationValidator;
import com.ibm.cic.agent.internal.installAdaptors.EclipseInstallAdaptor;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class EclipseQualificationOperation {
    private static final String CHECK_IF_ECLIPSE_UPDATE_REQUIRED = "CHECK_IF_ECLIPSE_UPDATE_REQUIRED";
    private final boolean eclipseUpdateAllowed;
    private final String contextId;
    private final InstallContextTree contextTree;
    private final InstallableUnitPair[] unitPairs;
    private final InstallableUnitPair.List unitPairList;
    private int fromUnitCount;
    private int toUnitCount;
    private final AgentJob[] jobs;
    private final Profile profile;
    private final StateObjectFactory factory = Platform.getPlatformAdmin().getFactory();
    private String eclipseCacheLocation;
    private ConfigurationEditor configEditor;
    private PlatformConfigurationState configState;
    private HashMap bundleDetails;
    private HashMap idToExistingBundle;
    private HashMap idToCachedBundle;
    private HashMap idToExistingFeature;
    private HashSet siIdsWithUpdatedBundleIUs;
    private HashSet missingFeatures;
    private final HashMap seIdToRemovedBundleIus = new HashMap();
    private final HashMap seIdToRef = new HashMap();
    private final EclipseQualificationHistory.PluginHistory pluginHistory;
    private final EclipseQualificationHistory.FeatureHistory featureHistory;
    private final EclipseQualificationHistory.JreHistory jreHistory;
    private final List bundlesToUnconfigure = new ArrayList();
    private final List featuresToUnconfigure = new ArrayList();
    private final TreeMap bundlesToUpdate = new TreeMap();
    private final TreeMap featuresToUpdate = new TreeMap();
    private HashSet jreSuIdsToFilter;
    private IStatus initialConstraintStatus = Status.OK_STATUS;
    private static final String CHECK_EXISTING_BUNDLES_FOR_CONSTRAINTS_WITH_UNSPECIFIED_TOLERANCE = "CHECK_EXISTING_BUNDLES_FOR_CONSTRAINTS_WITH_UNSPECIFIED_TOLERANCE";

    public EclipseQualificationOperation(AgentJob[] jobs, Profile profile, String contextId, InstallContextTree contextTree) {
        if (jobs == null || contextId == null || contextTree == null) {
            throw new IllegalArgumentException();
        }
        this.contextId = contextId;
        this.contextTree = contextTree;
        this.unitPairList = contextTree.getPairs();
        this.unitPairs = this.unitPairList.getPairs();
        this.initCounts(this.unitPairs);
        this.jobs = jobs;
        this.profile = profile;
        String property = System.getProperty(CHECK_IF_ECLIPSE_UPDATE_REQUIRED);
        this.eclipseUpdateAllowed = property != null && property.equalsIgnoreCase("false");
        this.pluginHistory = new EclipseQualificationHistory.PluginHistory(profile, this.eclipseUpdateAllowed);
        this.featureHistory = new EclipseQualificationHistory.FeatureHistory(profile, this.eclipseUpdateAllowed);
        this.jreHistory = new EclipseQualificationHistory.JreHistory(profile);
    }

    public IStatus qualify(IProgressMonitor monitor) {
        if (this.unitPairs.length == 0) {
            return Status.OK_STATUS;
        }
        this.pluginHistory.load();
        this.featureHistory.load();
        this.jreHistory.load();
        IStatus status = this.doQualify(monitor);
        if (!status.isOK()) {
            if (!this.initialConstraintStatus.isOK()) {
                return this.initialConstraintStatus;
            }
            return status;
        }
        this.contextTree.setPairs(this.unitPairList);
        this.pluginHistory.store();
        this.featureHistory.store();
        this.jreHistory.store();
        return Status.OK_STATUS;
    }

    private IStatus doQualify(IProgressMonitor monitor) {
        this.initialConstraintStatus = Status.OK_STATUS;
        int n = 5;
        if (this.toUnitCount != 0) {
            n += 6;
            if (this.fromUnitCount != 0) {
                ++n;
            }
        }
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, n);
        InstallContext eclipseContext = this.profile.findInstallContext(this.contextId);
        String configLocation = eclipseContext.getLocation("configLocation");
        File configDir = new File(configLocation);
        try {
            configDir = configDir.getCanonicalFile();
            String eclipseCachePath = eclipseContext.getLocation("cacheLocation");
            if (eclipseCachePath == null || eclipseCachePath.trim().length() == 0) {
                Status status = new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, NLS.bind((String)Messages.EclipseInstallAdaptor_context_incomplete, (Object)eclipseContext, (Object)"cacheLocation"), null);
                return status;
            }
            this.eclipseCacheLocation = FileURLUtil.toUnescapedFileURL((File)new File(eclipseCachePath).getCanonicalFile()).toString();
            IStatus status = this.getPlatformConfigurationEditor(eclipseContext, configDir);
            pm.next().done();
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            BundleInfo[] infos = this.configEditor.getBundles();
            this.getBundleInfoDetails(infos);
            this.configState = new PlatformConfigurationState();
            status = this.configState.init(configDir, infos, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            State state = this.configState.getState();
            if (this.toUnitCount != 0) {
                this.initialConstraintStatus = ConfigurationValidator.checkForUnsatisfiedConstraints(state, 4, pm.next());
            }
            if (!(status = this.getBundleDescriptionDetails(state, pm.next())).isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.getExistingFeatures(pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (this.fromUnitCount != 0) {
                status = this.filterFromBundles(pm.next());
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (this.toUnitCount == 0) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            this.getJreSusToFilter();
            status = this.getFeaturesToUpdate(pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.updateOrFilterBundles(state, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.checkIfEclipseUpdateRequired();
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            this.configState.resolve(pm.next());
            status = this.checkForUnsatisfiedConstraints(state, pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.resolveShareableEntityRefs(pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.checkToleranceToExistingShareableEntities(pm.next());
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.okToContinue();
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.checkForConstraintsWithUnspecifiedTolerance(state);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            try {
                this.unconfigureBundles();
                this.unconfigureFeatures();
            }
            catch (Exception e) {
                Status status2 = new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseQualificationOperation_problemQualifyingEclipseInstallation, (Object)configDir, (Object)e), (Throwable)e);
                return status2;
            }
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private boolean doCheckForConstraintsWithUnspecifiedTolerance() {
        String property = System.getProperty(CHECK_EXISTING_BUNDLES_FOR_CONSTRAINTS_WITH_UNSPECIFIED_TOLERANCE);
        return property != null;
    }

    private IStatus checkForConstraintsWithUnspecifiedTolerance(State state) {
        if (!this.doCheckForConstraintsWithUnspecifiedTolerance()) {
            return Status.OK_STATUS;
        }
        if (this.bundlesToUpdate.isEmpty()) {
            return Status.OK_STATUS;
        }
        BundleDescription[] bundles = state.getResolvedBundles();
        TreeSet<String> msgs = new TreeSet<String>();
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            String location = bundle.getLocation();
            if (!location.startsWith(this.eclipseCacheLocation)) {
                BundleSpecification[] requiredBundles;
                StringBuffer sb = new StringBuffer();
                HostSpecification host = bundle.getHost();
                if (host != null) {
                    this.checkForUnspecifiedTolerance((VersionConstraint)host, sb);
                }
                if ((requiredBundles = bundle.getRequiredBundles()) != null && requiredBundles.length != 0) {
                    BundleSpecification[] bundleSpecificationArray = requiredBundles;
                    int n3 = requiredBundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        BundleSpecification requiredBundle = bundleSpecificationArray[n4];
                        this.checkForUnspecifiedTolerance((VersionConstraint)requiredBundle, sb);
                        ++n4;
                    }
                }
                if (sb.length() != 0) {
                    String bundleId = bundle.getSymbolicName();
                    String versionedId = String.valueOf(bundleId) + '_' + bundle.getVersion().toString();
                    String msg = NLS.bind((String)Messages.EclipseQualificationOperation_bundleWithUnspecifiedTolerance, (Object)versionedId, (Object)sb);
                    msgs.add(msg);
                }
            }
            ++n2;
        }
        if (msgs.size() == 0) {
            return Status.OK_STATUS;
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.EclipseQualificationOperation_bundlesWithUnspecifiedTolerances, new Object[0]);
        for (String msg : msgs) {
            status.add((IStatus)new Status(2, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, msg, null));
        }
        return this.okToContinue(status, false);
    }

    private void checkForUnspecifiedTolerance(VersionConstraint requiredBundle, StringBuffer sb) {
        String requiredBundleId;
        VersionRange tolerance = requiredBundle.getVersionRange();
        if ((tolerance == null || tolerance.equals((Object)VersionRange.emptyRange)) && this.bundlesToUpdate.containsKey(requiredBundleId = requiredBundle.getName())) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(requiredBundleId);
        }
    }

    private IStatus checkIfEclipseUpdateRequired() {
        if (this.eclipseUpdateAllowed) {
            return Status.OK_STATUS;
        }
        if (this.bundlesToUnconfigure.isEmpty() && this.featuresToUnconfigure.isEmpty() && this.missingFeatures.isEmpty()) {
            return Status.OK_STATUS;
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.EclipseQualificationOperation_updatedRequired, new Object[0]);
        for (EclipseFeatureData featureData : this.missingFeatures) {
            String msg = NLS.bind((String)Messages.EclipseQualificationOperation_missingFeature, (Object)featureData.getId());
            status.add((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, msg, null));
        }
        this.addUpdateStatus(status, 4, this.featuresToUpdate, Messages.EclipseQualificationOperation_featureToUpdate);
        this.addUpdateStatus(status, 4, this.bundlesToUpdate, Messages.EclipseQualificationOperation_bundleToUpdate);
        return status;
    }

    private IStatus okToContinue() {
        if (this.bundlesToUnconfigure.isEmpty() && this.featuresToUnconfigure.isEmpty()) {
            return Status.OK_STATUS;
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus(Messages.EclipseQualificationOperation_okToUpdate, new Object[0]);
        this.addUpdateStatus(status, 2, this.featuresToUpdate, Messages.EclipseQualificationOperation_featureToUpdate);
        this.addUpdateStatus(status, 2, this.bundlesToUpdate, Messages.EclipseQualificationOperation_bundleToUpdate);
        return this.okToContinue(status, true);
    }

    private IStatus okToContinue(CicMultiStatus status, boolean defaultResponse) {
        if (status.isOK()) {
            return Status.OK_STATUS;
        }
        Object result = UserFeedback.isOkToContinue((IStatus)status, (boolean)true, (boolean)defaultResponse) ? Status.OK_STATUS : Statuses.ST.createMultiStatus("com.ibm.cic.agent.core.eclipseInstallAdaptor", 8, 0, new IStatus[]{status}, null, Messages.EclipseQualificationOperation_operationCancelledByTheUser);
        return result;
    }

    private void addUpdateStatus(CicMultiStatus status, int severity, TreeMap toUpdate, String message) {
        Set entries = toUpdate.entrySet();
        for (Map.Entry entry : entries) {
            String id = (String)entry.getKey();
            String[] versions = ((String)entry.getValue()).split(";");
            String oldVersion = versions[0];
            String newVersion = versions[1];
            String versionedId = String.valueOf(id) + '_' + oldVersion;
            String msg = NLS.bind((String)message, (Object)versionedId, (Object)newVersion);
            status.add((IStatus)new Status(severity, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, msg, null));
        }
    }

    private IStatus getPlatformConfigurationEditor(InstallContext eclipseContext, File configDir) throws Exception {
        File location = new File(configDir, "config.ini");
        if (!location.isFile()) {
            return new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 0, NLS.bind((String)Messages.EclipseQualificationOperation_missingConfigIni, (Object)location), null);
        }
        this.configEditor = EclipseInstallAdaptor.getConfigurationEditor(eclipseContext);
        if (!AgentUserOptions.CIC_AGENT_ECLIPSE_DO_NOT_REFRESH_PLATFORM_CONFIGURATION.isSet()) {
            this.configEditor.refreshPlatformConfiguration();
        }
        return Status.OK_STATUS;
    }

    private void getBundleInfoDetails(BundleInfo[] infos) {
        HashMap<String, BundleDetails> details = new HashMap<String, BundleDetails>(infos.length);
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            BundleDetails detail = new BundleDetails();
            detail.setInfo(info);
            details.put(String.valueOf(info.getSymbolicName()) + info.getVersion(), detail);
            ++n2;
        }
        this.bundleDetails = details;
    }

    private void addBundleToMap(Map map, BundleDescription bundle, BundleDetails details) {
        String id = bundle.getName();
        if (map.containsKey(id)) {
            List bundlesList = (List)map.get(id);
            BundleDetails existingBundleDetails = (BundleDetails)bundlesList.get(0);
            if (bundle.isSingleton()) {
                if (existingBundleDetails.getDescription().getVersion().compareTo(bundle.getVersion()) < 0) {
                    bundlesList.clear();
                    bundlesList.add(details);
                    map.put(id, bundlesList);
                }
            } else {
                bundlesList.add(details);
                map.put(id, bundlesList);
            }
        } else {
            ArrayList<BundleDetails> bundlesList = new ArrayList<BundleDetails>(1);
            bundlesList.add(details);
            map.put(id, bundlesList);
        }
    }

    private IStatus getBundleDescriptionDetails(State state, IProgressMonitor monitor) {
        BundleDescription[] bundles = state.getResolvedBundles();
        monitor.beginTask("", bundles.length);
        try {
            this.idToExistingBundle = new HashMap(bundles.length);
            this.idToCachedBundle = new HashMap(bundles.length);
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                BundleDetails details = (BundleDetails)this.bundleDetails.get(String.valueOf(bundle.getName()) + bundle.getVersion().toString());
                if (details != null) {
                    details.setDescription(bundle);
                    String location = bundle.getLocation();
                    if (location.startsWith(this.eclipseCacheLocation)) {
                        this.addBundleToMap(this.idToCachedBundle, bundle, details);
                    } else {
                        this.addBundleToMap(this.idToExistingBundle, bundle, details);
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus getExistingFeatures(IProgressMonitor monitor) {
        FeatureInfo[] features = this.configEditor.getFeatures();
        monitor.beginTask("", features.length);
        try {
            this.idToExistingFeature = new HashMap(features.length);
            FeatureInfo[] featureInfoArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureInfo feature = featureInfoArray[n2];
                String id = feature.getSymbolicName();
                String location = feature.getLocation();
                if (!location.startsWith(this.eclipseCacheLocation)) {
                    this.idToExistingFeature.put(id, feature);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void getJreSusToFilter() {
        this.jreSuIdsToFilter = new HashSet();
        String installPackagedJre = this.profile.getData("install.packaged.jre.for.eclipse.ide");
        if (Boolean.valueOf(installPackagedJre).booleanValue()) {
            return;
        }
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            this.getJreSuToFilter(offeringOrFix);
            ++n2;
        }
    }

    private void getJreSuToFilter(IOfferingOrFix offeringOrFix) {
        String jreSuId = offeringOrFix.getProperties().getProperty("packaged.jre.for.eclipse.ide");
        if (jreSuId == null && offeringOrFix instanceof IFix) {
            IFix fix = (IFix)offeringOrFix;
            for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
                IOffering baseOffering = this.profile.findOffering(applicableOffering.getIdentity().getId());
                if (baseOffering != null && applicableOffering.getTolerance().isIncluded(baseOffering.getVersion()) && (jreSuId = baseOffering.getProperties().getProperty("packaged.jre.for.eclipse.ide")) != null) break;
            }
        }
        if (jreSuId == null) {
            jreSuId = "com.ibm.java.jre";
        }
        this.jreSuIdsToFilter.add(jreSuId);
    }

    private boolean checkIfUpdateOfBundlesNeeded(EclipseBundleData bundleData, IInstallableUnit unit) {
        String bundleId = bundleData.getId();
        if (this.idToExistingBundle.containsKey(bundleId) && ((List)this.idToExistingBundle.get(bundleId)).size() > 0) {
            List detailsList = (List)this.idToExistingBundle.get(bundleId);
            for (BundleDetails details : detailsList) {
                BundleDescription bundle = details.getDescription();
                if (!bundleData.isSingleton() || VersionUtil.compareToIgnoreQualifier((Version)bundle.getVersion(), (Version)unit.getVersion()) >= 0) continue;
                details.setUnit(unit);
                return true;
            }
        } else if (this.idToCachedBundle.containsKey(bundleId) && ((List)this.idToCachedBundle.get(bundleId)).size() > 0) {
            if (this.pluginHistory.isUpdated((IContent)unit)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private IStatus getFeaturesToUpdate(IProgressMonitor monitor) {
        this.siIdsWithUpdatedBundleIUs = new HashSet(this.idToExistingFeature.size());
        this.missingFeatures = new HashSet(this.idToExistingFeature.size());
        HashSet<IShareableItem> sisWithExistingFeatures = new HashSet<IShareableItem>(this.idToExistingFeature.size());
        HashMap<IShareableItem, ArrayList<EclipseFeatureData>> siToFeatureData = new HashMap<IShareableItem, ArrayList<EclipseFeatureData>>(this.unitPairs.length);
        try {
            monitor.beginTask("", this.toUnitCount);
            InstallableUnitPair[] installableUnitPairArray = this.unitPairs;
            int n = this.unitPairs.length;
            int n2 = 0;
            while (n2 < n) {
                InstallableUnitPair unitPair = installableUnitPairArray[n2];
                IInstallableUnit unit = unitPair.getTo();
                if (unit != null) {
                    IEclipseData bundleOrFeature;
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    String adapterId = unit.getAdapterId();
                    if (adapterId.equals("eclipse") && (bundleOrFeature = ModelUtils.getBundleOrFeature(unit)) != null) {
                        IShareableItem si = (IShareableItem)unit.getParent();
                        String siId = si.getIdentity().getId();
                        if (!ModelUtils.isBundle(bundleOrFeature)) {
                            if (ModelUtils.isFeature(bundleOrFeature)) {
                                EclipseFeatureData featureData = (EclipseFeatureData)bundleOrFeature;
                                ArrayList<EclipseFeatureData> features = (ArrayList<EclipseFeatureData>)siToFeatureData.get(si);
                                if (features == null) {
                                    features = new ArrayList<EclipseFeatureData>();
                                    siToFeatureData.put(si, features);
                                }
                                features.add(featureData);
                                FeatureInfo featureInfo = (FeatureInfo)this.idToExistingFeature.get(featureData.getId());
                                if (featureInfo != null) {
                                    sisWithExistingFeatures.add(si);
                                    Version featureVersion = new Version(featureInfo.getVersion());
                                    if (VersionUtil.compareToIgnoreQualifier((Version)featureVersion, (Version)unit.getVersion()) < 0) {
                                        this.siIdsWithUpdatedBundleIUs.add(siId);
                                    }
                                } else {
                                    this.siIdsWithUpdatedBundleIUs.add(siId);
                                }
                            }
                        } else if (this.checkIfUpdateOfBundlesNeeded((EclipseBundleData)bundleOrFeature, unit)) {
                            this.siIdsWithUpdatedBundleIUs.add(siId);
                        }
                    }
                }
                ++n2;
            }
            for (IShareableItem si : sisWithExistingFeatures) {
                boolean siHasNewerExistingFeatures = false;
                boolean siHasMissingFeature = false;
                ArrayList features = (ArrayList)siToFeatureData.get(si);
                for (EclipseFeatureData featureData : features) {
                    FeatureInfo featureInfo = (FeatureInfo)this.idToExistingFeature.get(featureData.getId());
                    if (featureInfo == null) {
                        if (this.isIgnoreablePatchFeature(featureData)) continue;
                        this.missingFeatures.add(featureData);
                        siHasMissingFeature = true;
                        continue;
                    }
                    Version featureVersion = new Version(featureInfo.getVersion());
                    if (VersionUtil.compareToIgnoreQualifier((Version)featureVersion, (Version)featureData.getVersion()) >= 0) continue;
                    siHasNewerExistingFeatures = true;
                }
                if (!this.siIdsWithUpdatedBundleIUs.contains(si.getIdentity().getId()) || !siHasMissingFeature && siHasNewerExistingFeatures) continue;
                this.siIdsWithUpdatedBundleIUs.remove(si.getIdentity().getId());
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isIgnoreablePatchFeature(EclipseFeatureData featureData) {
        String patchedFeatureId = featureData.getPatchedFeatureId();
        Version patchedFeatureVersion = featureData.getPatchedFeatureVersion();
        if (patchedFeatureId == null || patchedFeatureVersion == null) {
            return false;
        }
        FeatureInfo existingFeatureInfo = (FeatureInfo)this.idToExistingFeature.get(patchedFeatureId);
        if (existingFeatureInfo == null) {
            return false;
        }
        Version existingFeatureVersion = new Version(existingFeatureInfo.getVersion());
        return VersionUtil.compareToIgnoreQualifier((Version)existingFeatureVersion, (Version)patchedFeatureVersion) > 0;
    }

    private void configureBundle(BundleInfo info) {
        this.configEditor.add(info);
    }

    private void unconfigureBundle(BundleInfo info) {
        this.configEditor.remove(info);
    }

    private void unconfigureBundles() {
        if (!this.eclipseUpdateAllowed) {
            return;
        }
        for (BundleInfo info : this.bundlesToUnconfigure) {
            this.unconfigureBundle(info);
        }
    }

    private void configureFeature(FeatureInfo info) {
        this.configEditor.addFeature(info.getSymbolicName(), info.getVersion(), info.getLocation(), info.getPluginId(), info.getPluginVersion(), info.isPrimary(), info.getApplication());
    }

    private void unconfigureFeature(FeatureInfo info) {
        this.configEditor.removeFeature(info.getSymbolicName(), info.getVersion(), info.getLocation());
    }

    private void unconfigureFeatures() {
        if (!this.eclipseUpdateAllowed) {
            return;
        }
        for (FeatureInfo info : this.featuresToUnconfigure) {
            this.unconfigureFeature(info);
        }
    }

    private IStatus filterFromBundles(IProgressMonitor monitor) {
        try {
            monitor.beginTask("", this.fromUnitCount);
            InstallableUnitPair[] installableUnitPairArray = this.unitPairs;
            int n = this.unitPairs.length;
            int n2 = 0;
            while (n2 < n) {
                InstallableUnitPair unitPair = installableUnitPairArray[n2];
                IInstallableUnit unit = unitPair.getFrom();
                if (unit != null) {
                    IShareableUnit su;
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IShareableItem si = (IShareableItem)unit.getParent();
                    if (si instanceof IShareableUnit && this.jreHistory.isFiltered((IContent)(su = (IShareableUnit)si))) {
                        this.unitPairList.removeFrom(unit);
                    } else {
                        String adapterId = unit.getAdapterId();
                        if (!adapterId.equals("eclipse")) {
                            if (this.pluginHistory.isFiltered((IContent)unit)) {
                                this.unitPairList.removeFrom(unit);
                            }
                        } else {
                            IEclipseData bundleOrFeature = ModelUtils.getBundleOrFeature(unit);
                            if (bundleOrFeature != null) {
                                String historyText;
                                if (ModelUtils.isFeature(bundleOrFeature)) {
                                    historyText = this.featureHistory.get((IContent)unit);
                                    if (historyText != null) {
                                        if (historyText.startsWith("updated")) {
                                            if (this.isDecreasing(unitPair)) {
                                                this.configureFeature(this.featureHistory.createFeatureInfo(historyText));
                                            }
                                        } else {
                                            this.unitPairList.removeFrom(unit);
                                        }
                                    }
                                } else if (ModelUtils.isBundle(bundleOrFeature) && (historyText = this.pluginHistory.get((IContent)unit)) != null) {
                                    if (historyText.startsWith("updated")) {
                                        if (this.isDecreasing(unitPair)) {
                                            this.configureBundle(this.pluginHistory.createBundleInfo(historyText));
                                        }
                                    } else {
                                        this.unitPairList.removeFrom(unit);
                                    }
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isDecreasing(InstallableUnitPair unitPair) {
        IInstallableUnit fromUnit = unitPair.getFrom();
        if (fromUnit == null) {
            return false;
        }
        IInstallableUnit toUnit = unitPair.getTo();
        if (toUnit == null) {
            return true;
        }
        int cmp = fromUnit.getVersion().compareTo(toUnit.getVersion());
        if (cmp == 0) {
            IInstallableUnitContainer toParent = toUnit.getParent();
            IInstallableUnitContainer fromParent = fromUnit.getParent();
            if (toParent.getIdentity().equals(fromParent.getIdentity())) {
                cmp = fromParent.getVersion().compareTo(toParent.getVersion());
            }
        }
        return cmp > 0;
    }

    private boolean checkAndUpdateOrFilterBundle(State state, EclipseBundleData bundleData, String suId, IInstallableUnit unit, InstallableUnitPair unitPair) {
        String bundleId = bundleData.getId();
        boolean returnValue = false;
        List detailsList = (List)this.idToExistingBundle.get(bundleId);
        if (detailsList != null && detailsList.size() > 0) {
            if (!bundleData.isSingleton()) {
                BundleDetails details = (BundleDetails)detailsList.get(0);
                state.addBundle(this.createNewDescription(this.configState.getNextBundleId(), details.getDescription(), unit, bundleData));
            }
            for (BundleDetails details : detailsList) {
                BundleDescription bundle = details.getDescription();
                if (this.siIdsWithUpdatedBundleIUs.contains(suId)) {
                    details.setUnit(unit);
                    if (!bundleData.isSingleton()) continue;
                    state.updateBundle(this.createNewDescription(bundle, unit, bundleData));
                    this.addBundleToUnconfigure(details);
                    continue;
                }
                details.setUnit(unit);
                this.unitPairList.removeTo(unit);
                this.pluginHistory.addFiltered((IContent)unit);
                returnValue = true;
            }
        } else {
            detailsList = (List)this.idToCachedBundle.get(bundleId);
            if (detailsList != null && detailsList.size() > 0) {
                BundleDetails details = (BundleDetails)detailsList.get(0);
                if (bundleData.isSingleton()) {
                    state.updateBundle(this.createNewDescription(details.getDescription(), unit, bundleData));
                } else if (!this.updateCachedBundle(state, unitPair.getFrom(), unit, bundleData)) {
                    state.addBundle(this.createNewDescription(this.configState.getNextBundleId(), details.getDescription(), unit, bundleData));
                }
                if (this.pluginHistory.isFiltered((IContent)unit)) {
                    this.unitPairList.removeTo(unit);
                }
            } else if (!this.siIdsWithUpdatedBundleIUs.contains(suId)) {
                this.unitPairList.removeTo(unit);
                this.pluginHistory.addFiltered((IContent)unit);
                returnValue = true;
            }
        }
        return returnValue;
    }

    private boolean updateCachedBundle(State state, IInstallableUnit fromUnit, IInstallableUnit toUnit, EclipseBundleData bundleData) {
        if (fromUnit == null) {
            return false;
        }
        String bundleId = bundleData.getId();
        List detailsList = (List)this.idToCachedBundle.get(bundleId);
        if (detailsList == null) {
            return false;
        }
        Version fromUnitVersion = fromUnit.getVersion();
        for (BundleDetails details : detailsList) {
            BundleDescription bundle = details.getDescription();
            if (!fromUnitVersion.equals((Object)bundle.getVersion())) continue;
            state.updateBundle(this.createNewDescription(details.getDescription(), toUnit, bundleData));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private IStatus updateOrFilterBundles(State state, IProgressMonitor monitor) {
        featureIdToFeatureIU = new HashMap<String, IInstallableUnit>();
        siIdsWithRemovedBundleIUs = new HashSet<String>();
        monitor.beginTask("", 10);
        m1 = new SubProgressMonitor(monitor, 8);
        m2 = new SubProgressMonitor(monitor, 2);
        jreSuToFilter = null;
        try {
            m1.beginTask("", this.toUnitCount);
            var11_8 = this.unitPairs;
            var10_9 = this.unitPairs.length;
            var9_11 = 0;
            while (var9_11 < var10_9) {
                block27: {
                    block26: {
                        unitPair = var11_8[var9_11];
                        unit = unitPair.getTo();
                        if (unit != null) break block26;
                        unit = unitPair.getFrom();
                        bundleData = this.getBundleData(unit);
                        if (bundleData != null) {
                            this.updateCachedBundle(state, unit, unit, bundleData);
                        }
                        break block27;
                    }
                    m1.worked(1);
                    if (m1.isCanceled()) {
                        var19_20 = Status.CANCEL_STATUS;
                        return var19_20;
                    }
                    si = (IShareableItem)unit.getParent();
                    siId = si.getIdentity().getId();
                    if (!(si instanceof IShareableUnit)) ** GOTO lbl-1000
                    su = (IShareableUnit)si;
                    suId = su.getIdentity().getId();
                    if (this.jreSuIdsToFilter.contains(suId)) {
                        this.unitPairList.removeTo(unit);
                        jreSuToFilter = su;
                    } else if (this.jreHistory.isFiltered((IContent)su)) {
                        this.unitPairList.removeTo(unit);
                    } else if (!(adapterId = unit.getAdapterId()).equals("eclipse")) {
                        this.filterEclipseExecutableIUs(unit, siId);
                    } else if (!this.filterEclipseConfigurationIUs(unit, siId) && (bundleOrFeature = ModelUtils.getBundleOrFeature(unit)) != null) {
                        if (ModelUtils.isFeature(bundleOrFeature)) {
                            featureData = (EclipseFeatureData)bundleOrFeature;
                            featureIdToFeatureIU.put(featureData.getId(), unit);
                            if (this.featureHistory.isFiltered((IContent)unit)) {
                                this.unitPairList.removeTo(unit);
                            }
                        } else if (ModelUtils.isBundle(bundleOrFeature) && this.checkAndUpdateOrFilterBundle(state, (EclipseBundleData)bundleOrFeature, siId, unit, unitPair)) {
                            siIdsWithRemovedBundleIUs.add(siId);
                            iuList = (ArrayList<IInstallableUnit>)this.seIdToRemovedBundleIus.get(siId);
                            if (iuList == null) {
                                iuList = new ArrayList<IInstallableUnit>();
                                this.seIdToRemovedBundleIus.put(siId, iuList);
                            }
                            iuList.add(unit);
                        }
                    }
                }
                ++var9_11;
            }
            m2.beginTask("", featureIdToFeatureIU.size());
            for (Map.Entry<K, V> entry : featureIdToFeatureIU.entrySet()) {
                featureId = (String)entry.getKey();
                unit = (IInstallableUnit)entry.getValue();
                siId = this.getUnitParentId(unit);
                if (siIdsWithRemovedBundleIUs.contains(siId)) {
                    this.unitPairList.removeTo(unit);
                    this.featureHistory.addFiltered((IContent)unit);
                } else {
                    featureInfo = (FeatureInfo)this.idToExistingFeature.get(featureId);
                    if (featureInfo != null) {
                        this.addFeatureToUnconfigure(unit, featureInfo);
                    }
                }
                m2.worked(1);
                if (!m2.isCanceled()) continue;
                var19_21 = Status.CANCEL_STATUS;
                return var19_21;
            }
            if (jreSuToFilter != null) {
                this.jreHistory.addFiltered((IContent)jreSuToFilter);
            }
        }
        finally {
            m1.done();
            m2.done();
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private String getUnitParentId(IInstallableUnit unit) {
        return unit.getParent().getIdentity().getId();
    }

    private EclipseBundleData getBundleData(IInstallableUnit unit) {
        if (!unit.getAdapterId().equals("eclipse")) {
            return null;
        }
        IEclipseData bundleOrFeature = ModelUtils.getBundleOrFeature(unit);
        if (bundleOrFeature == null || !ModelUtils.isBundle(bundleOrFeature)) {
            return null;
        }
        return (EclipseBundleData)bundleOrFeature;
    }

    private void filterEclipseExecutableIUs(IInstallableUnit unit, String siId) {
        if (this.pluginHistory.isFiltered((IContent)unit)) {
            this.unitPairList.removeTo(unit);
            return;
        }
        if (this.siIdsWithUpdatedBundleIUs.contains(siId)) {
            return;
        }
        if (!unit.getIdentity().getId().startsWith("org.eclipse.executable") && !unit.getIdentity().getId().startsWith("org.eclipse.equinox.p2.bootstrap")) {
            return;
        }
        this.unitPairList.removeTo(unit);
        this.pluginHistory.addFiltered((IContent)unit);
    }

    private boolean filterEclipseConfigurationIUs(IInstallableUnit unit, String siId) {
        if (!siId.equals("org.eclipse.rcp.feature")) {
            return false;
        }
        String iuId = unit.getIdentity().getId();
        if (this.pluginHistory.isFiltered((IContent)unit) && iuId.startsWith("org.eclipse.configuration")) {
            this.unitPairList.removeTo(unit);
            return true;
        }
        if (this.siIdsWithUpdatedBundleIUs.contains(siId)) {
            return false;
        }
        if (iuId.startsWith("org.eclipse.configuration")) {
            this.unitPairList.removeTo(unit);
            this.pluginHistory.addFiltered((IContent)unit);
            return true;
        }
        return false;
    }

    private void addBundleToUnconfigure(BundleDetails details) {
        IInstallableUnit unit = details.getUnit();
        BundleInfo info = details.getInfo();
        BundleDescription bundle = details.getDescription();
        this.pluginHistory.add(details);
        this.bundlesToUnconfigure.add(info);
        Version bundleVersion = bundle.getVersion();
        Version unitVersion = unit.getVersion();
        if (bundle.isSingleton() && VersionUtil.compareToIgnoreQualifier((Version)bundleVersion, (Version)unitVersion) < 0) {
            String oldVersion = bundleVersion.toString();
            String newVersion = unitVersion.toString();
            this.bundlesToUpdate.put(info.getSymbolicName(), String.valueOf(oldVersion) + ';' + newVersion);
        }
    }

    private void addFeatureToUnconfigure(IInstallableUnit unit, FeatureInfo info) {
        Version oldVersion = new Version(info.getVersion());
        Version newVersion = new Version(unit.getVersion().toString());
        String siId = this.getUnitParentId(unit);
        if (oldVersion.equals((Object)newVersion) || !this.siIdsWithUpdatedBundleIUs.contains(siId)) {
            this.unitPairList.removeTo(unit);
            this.featureHistory.addFiltered((IContent)unit);
            return;
        }
        this.featureHistory.add(unit, info);
        this.featuresToUnconfigure.add(info);
        if (oldVersion.compareTo(newVersion) < 0) {
            this.featuresToUpdate.put(info.getSymbolicName(), String.valueOf(oldVersion.toString()) + ';' + newVersion.toString());
        }
    }

    private IStatus checkForUnsatisfiedConstraints(State state, IProgressMonitor monitor) {
        return ConfigurationValidator.checkForUnsatisfiedConstraints(Messages.EclipseQualificationOperation_unsatisfiedConstraintsWarning, Messages.EclipseQualificationOperation_unsatisfiedConstraintsError, Messages.EclipseQualificationOperation_unsatisfiedConstraintWarning, Messages.EclipseQualificationOperation_unsatisfiedConstraintError, state, 4, monitor);
    }

    private IStatus resolveShareableEntityRefs(IProgressMonitor monitor) {
        Collection shareableEntities = this.contextTree.getShareableEntities();
        monitor.beginTask("", shareableEntities.size());
        try {
            for (IShareableEntity se : shareableEntities) {
                String seId = se.getIdentity().getId();
                ShareableEntityRef ref = this.getShareableEntityRef(seId);
                ref.shareableEntity = se;
                String featureId = ModelUtils.getFeatureId(se);
                if (se instanceof IShareableUnit && this.seIdToRemovedBundleIus.containsKey(seId)) continue;
                for (IContentSelector selector : this.contextTree.getSelected(se)) {
                    Set reqdSEs = selector.getRequiredShareableEntities();
                    for (IRequiredShareableEntity rse : reqdSEs) {
                        String id = rse.getShareableId().getId();
                        VersionRange tolerance = rse.getTolerance();
                        ref = this.getShareableEntityRef(id);
                        ref.updateTolerance(tolerance, featureId);
                    }
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean checkToleranceForExistingBundles(String bundleId, IInstallableUnit unit, VersionRange toleranceDelta, boolean useStrictTolerances) {
        if (this.idToExistingBundle.containsKey(bundleId) && ((List)this.idToExistingBundle.get(bundleId)).size() > 0) {
            List detailsList = (List)this.idToExistingBundle.get(bundleId);
            for (BundleDetails details : detailsList) {
                Version unitVersion;
                BundleDescription bundle = details.getDescription();
                if (!bundle.isSingleton()) {
                    return true;
                }
                Version bundleVersion = bundle.getVersion();
                if (!this.isInRange(bundleVersion, unitVersion = unit.getVersion(), toleranceDelta, useStrictTolerances)) continue;
                return true;
            }
            return false;
        }
        return !this.siIdsWithUpdatedBundleIUs.contains(this.getUnitParentId(unit));
    }

    private Version getExistingBundleVersion(String bundleId) {
        if (this.idToExistingBundle.containsKey(bundleId) && ((List)this.idToExistingBundle.get(bundleId)).size() > 0) {
            List detailsList = (List)this.idToExistingBundle.get(bundleId);
            return ((BundleDetails)detailsList.get(0)).getDescription().getVersion();
        }
        return null;
    }

    private IStatus checkToleranceToExistingShareableEntities(IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ERROR.getMultiStatus(Messages.EclipseQualificationOperation_intolerableFeatures, new Object[0]);
        Collection seRefs = this.seIdToRef.values();
        monitor.beginTask("", seRefs.size());
        try {
            block3: for (ShareableEntityRef seRef : seRefs) {
                Version seVersion;
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    break;
                }
                IShareableEntity se = seRef.shareableEntity;
                if (se == null || seRef.minTolerance == VersionRange.emptyRange || !seRef.minTolerance.isIncluded(seVersion = se.getVersion())) continue;
                seRef.updateTolerance(seVersion);
                VersionRange toleranceDelta = seRef.getToleranceDelta();
                List bundleUnits = this.getRemovedBundleUnitsOfShareableEntity(se);
                if (bundleUnits == null) continue;
                boolean useStrictTolerances = true;
                if (se instanceof IAssembly) {
                    useStrictTolerances = AgentUserOptions.CIC_USE_STRICT_QUALIFICATION_TOLERANCES.isSet();
                }
                for (IInstallableUnit unit : bundleUnits) {
                    String bundleId;
                    String adapterId = unit.getAdapterId();
                    if (!adapterId.equals("eclipse") || (bundleId = ModelUtils.getBundleId(unit)) == null || this.checkToleranceForExistingBundles(bundleId, unit, toleranceDelta, useStrictTolerances)) continue;
                    EclipseFeatureData feature = ModelUtils.getFeature(se);
                    String featureId = feature == null ? se.getIdentity().getId() : feature.getId();
                    Version featureVersion = this.configEditor.findFeatureVersion(featureId);
                    if (featureVersion != null && seRef.minTolerance.isIncluded(featureVersion)) {
                        Version bundleVersion = this.getExistingBundleVersion(bundleId);
                        Version delta = ShareableEntityRef.computeAbsoluteDelta(unit.getVersion(), bundleVersion);
                        boolean subtract = unit.getVersion().compareTo(bundleVersion) > 0;
                        Version effectiveFeatureVersion = this.addOrSubtractDelta(seVersion, delta, subtract);
                        Version offeringFeatureVersion = feature == null ? seVersion : feature.getVersion();
                        status.add((IStatus)Statuses.ERROR.get(Messages.EclipseQualificationOperation_effectivelyIntolerableFeature, new Object[]{featureId, seRef.minTolerance, seRef.minReferencer, featureVersion, effectiveFeatureVersion, bundleId, unit.getVersion(), bundleVersion, offeringFeatureVersion}));
                        continue block3;
                    }
                    if (featureVersion != null) {
                        featureId = String.valueOf(featureId) + '_' + featureVersion;
                    }
                    status.add((IStatus)Statuses.ERROR.get(Messages.EclipseQualificationOperation_intolerableFeature, new Object[]{featureId, seRef.minTolerance, seRef.minReferencer}));
                    continue block3;
                }
            }
        }
        finally {
            monitor.done();
        }
        return MultiStatusUtil.convertToOKifNoChildren((CicMultiStatus)status);
    }

    private List getRemovedBundleUnitsOfShareableEntity(IShareableEntity se) {
        String seId = se.getIdentity().getId();
        List cachedBundleUnits = (List)this.seIdToRemovedBundleIus.get(seId);
        if (se instanceof IShareableUnit) {
            return cachedBundleUnits;
        }
        if (cachedBundleUnits != null) {
            return cachedBundleUnits;
        }
        IAssembly asm = (IAssembly)se;
        ArrayList result = null;
        List children = asm.getChildren();
        for (IncludedShareableEntity ise : children) {
            List bundlesOfIncluded;
            IShareableEntity includedSe;
            ShareableEntityRef ref = (ShareableEntityRef)this.seIdToRef.get(ise.getIdentity().getId());
            if (ref == null || (includedSe = ref.shareableEntity) == null || (bundlesOfIncluded = this.getRemovedBundleUnitsOfShareableEntity(includedSe)) == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(bundlesOfIncluded);
        }
        this.seIdToRemovedBundleIus.put(seId, result);
        return result;
    }

    private boolean isInRange(Version bundleVersion, Version iuVersion, VersionRange toleranceDelta, boolean useStrictTolerances) {
        int maxCheck;
        if (VersionUtil.compareToIgnoreQualifier((Version)bundleVersion, (Version)iuVersion) < 0) {
            return false;
        }
        if (!useStrictTolerances) {
            return true;
        }
        Version max = this.addDelta(iuVersion, toleranceDelta.getRight());
        int n = maxCheck = toleranceDelta.getIncludeMaximum() ? 0 : -1;
        return VersionUtil.compareToIgnoreQualifier((Version)bundleVersion, (Version)max) <= maxCheck;
    }

    private Version addDelta(Version version, Version delta) {
        return this.addOrSubtractDelta(version, delta, false);
    }

    private Version addOrSubtractDelta(Version version, Version delta, boolean subtract) {
        Version result;
        if (delta == null) {
            result = subtract ? Version.emptyVersion : null;
        } else if (delta.equals((Object)Version.emptyVersion)) {
            result = version;
        } else {
            int[] deltaParts = new int[]{delta.getMicro(), delta.getMinor(), delta.getMajor()};
            int[] minParts = new int[]{version.getMicro(), version.getMinor(), version.getMajor()};
            int[] resultParts = new int[minParts.length];
            int i = 0;
            while (i < resultParts.length && deltaParts[i] == 0) {
                resultParts[i] = 0;
                ++i;
            }
            while (i < resultParts.length) {
                if (subtract) {
                    resultParts[i] = minParts[i] - deltaParts[i];
                    if (resultParts[i] < 0) {
                        resultParts[i] = 0;
                    }
                } else {
                    resultParts[i] = minParts[i] + deltaParts[i];
                }
                ++i;
            }
            result = new Version(resultParts[2], resultParts[1], resultParts[0], null);
        }
        return result;
    }

    private BundleDescription createNewDescription(BundleDescription bundle, IInstallableUnit unit, EclipseBundleData bundleData) {
        return this.createNewDescription(bundle.getBundleId(), bundle, unit, bundleData);
    }

    private BundleDescription createNewDescription(long bundleId, BundleDescription bundle, IInstallableUnit unit, EclipseBundleData bundleData) {
        return this.factory.createBundleDescription(bundleId, bundle.getSymbolicName(), unit.getVersion(), this.getEclipseCacheLocation(bundleData), null, null, bundle.getImportPackages(), bundle.getExportPackages(), bundle.isSingleton(), bundle.attachFragments(), bundle.dynamicFragments(), bundle.getPlatformFilter(), null, bundle.getGenericRequires(), bundle.getGenericCapabilities());
    }

    private String getEclipseCacheLocation(EclipseBundleData bundleData) {
        String result = String.valueOf(this.eclipseCacheLocation) + "/plugins/" + bundleData.getId() + '_' + bundleData.getVersion().toString();
        if (!bundleData.getExploded()) {
            result = String.valueOf(result) + CicConstants.getJarFileDotExt();
        }
        return result;
    }

    private ShareableEntityRef getShareableEntityRef(String id) {
        ShareableEntityRef ref = (ShareableEntityRef)this.seIdToRef.get(id);
        if (ref == null) {
            ref = new ShareableEntityRef(id);
            this.seIdToRef.put(id, ref);
        }
        return ref;
    }

    private void initCounts(InstallableUnitPair[] installableUnitPairs) {
        this.fromUnitCount = 0;
        this.toUnitCount = 0;
        InstallableUnitPair[] installableUnitPairArray = installableUnitPairs;
        int n = installableUnitPairs.length;
        int n2 = 0;
        while (n2 < n) {
            InstallableUnitPair pair = installableUnitPairArray[n2];
            if (pair.getFrom() != null) {
                ++this.fromUnitCount;
            }
            if (pair.getTo() != null) {
                ++this.toUnitCount;
            }
            ++n2;
        }
    }
}

