/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.eclipse.internals.update.configurator;

import com.ibm.cic.eclipse.internals.update.configurator.BundleManifest;
import com.ibm.cic.eclipse.internals.update.configurator.Configuration;
import com.ibm.cic.eclipse.internals.update.configurator.ConfigurationActivator;
import com.ibm.cic.eclipse.internals.update.configurator.FeatureEntry;
import com.ibm.cic.eclipse.internals.update.configurator.FeatureParser;
import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.Messages;
import com.ibm.cic.eclipse.internals.update.configurator.PlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.PluginEntry;
import com.ibm.cic.eclipse.internals.update.configurator.PluginParser;
import com.ibm.cic.eclipse.internals.update.configurator.SitePolicy;
import com.ibm.cic.eclipse.internals.update.configurator.Utils;
import com.ibm.cic.eclipse.internals.update.configurator.VersionedIdentifier;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SiteEntry
implements IPlatformConfiguration.ISiteEntry,
IConfigurationConstants {
    private static final String MAC_OS_MARKER = ".DS_Store";
    private URL url;
    private URL resolvedURL;
    private IPlatformConfiguration.ISitePolicy policy;
    private boolean updateable = true;
    private Map featureEntries;
    private ArrayList pluginEntries;
    private long changeStamp;
    private long featuresChangeStamp;
    private long pluginsChangeStamp;
    private String linkFileName;
    private boolean enabled = true;
    private Configuration config;
    private static FeatureParser featureParser = new FeatureParser();
    private static PluginParser pluginParser = new PluginParser();
    private static boolean isMacOS = Utils.getOS().equals("macosx");

    public SiteEntry(URL url) {
        this(url, null);
    }

    public SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        if (url == null) {
            try {
                url = new URL("platform:/base/");
            }
            catch (MalformedURLException e) {
                url = PlatformConfiguration.getInstallURL();
            }
        }
        if (policy == null) {
            policy = new SitePolicy(1, DEFAULT_POLICY_LIST);
        }
        if (url.getProtocol().equals("file")) {
            try {
                this.url = new File(url.getFile()).toURL();
            }
            catch (MalformedURLException e1) {
                this.url = url;
            }
        } else {
            this.url = url;
        }
        this.policy = policy;
        this.resolvedURL = this.url;
    }

    public void setConfig(Configuration config) {
        this.config = config;
        if (this.url.getProtocol().equals("platform")) {
            try {
                this.resolvedURL = PlatformConfiguration.resolvePlatformURL(this.url, config.getInstallURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public IPlatformConfiguration.ISitePolicy getSitePolicy() {
        return this.policy;
    }

    @Override
    public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.policy = policy;
    }

    @Override
    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    @Override
    public String[] getPlugins() {
        IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
        if (policy.getType() == 0) {
            return policy.getList();
        }
        if (policy.getType() == 1) {
            String[] excludedPlugins;
            ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
            String[] stringArray = excludedPlugins = policy.getList();
            int n = excludedPlugins.length;
            int n2 = 0;
            while (n2 < n) {
                String excludedPlugin = stringArray[n2];
                if (detectedPlugins.contains(excludedPlugin)) {
                    detectedPlugins.remove(excludedPlugin);
                }
                ++n2;
            }
            return detectedPlugins.toArray(new String[0]);
        }
        if (policy.getType() == 2) {
            PluginEntry[] managedPlugins = this.getManagedPlugins();
            String[] managedPluginsURLs = new String[managedPlugins.length];
            int i = 0;
            while (i < managedPlugins.length) {
                managedPluginsURLs[i] = managedPlugins[i].getURL();
                ++i;
            }
            return managedPluginsURLs;
        }
        return new String[0];
    }

    private PluginEntry[] getManagedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        HashMap<VersionedIdentifier, PluginEntry> cachedPlugins = new HashMap<VersionedIdentifier, PluginEntry>(this.pluginEntries.size());
        int i = 0;
        while (i < this.pluginEntries.size()) {
            PluginEntry p = (PluginEntry)this.pluginEntries.get(i);
            cachedPlugins.put(p.getVersionedIdentifier(), p);
            ++i;
        }
        ArrayList managedPlugins = new ArrayList();
        for (Object feature : this.featureEntries.values()) {
            PluginEntry[] plugins;
            if (!(feature instanceof FeatureEntry)) continue;
            PluginEntry[] pluginEntryArray = plugins = ((FeatureEntry)feature).getPluginEntries();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                PluginEntry plugin = pluginEntryArray[n2];
                if (cachedPlugins.containsKey(plugin.getVersionedIdentifier())) {
                    managedPlugins.add(cachedPlugins.get(plugin.getVersionedIdentifier()));
                }
                ++n2;
            }
        }
        return managedPlugins.toArray(new PluginEntry[managedPlugins.size()]);
    }

    public PluginEntry[] getPluginEntries() {
        String[] pluginURLs = this.getPlugins();
        HashMap<String, String> map = new HashMap<String, String>(pluginURLs.length);
        String[] stringArray = pluginURLs;
        int n = pluginURLs.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginURL = stringArray[n2];
            map.put(pluginURL, pluginURL);
            ++n2;
        }
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        ArrayList<PluginEntry> plugins = new ArrayList<PluginEntry>(pluginURLs.length);
        int i = 0;
        while (i < this.pluginEntries.size()) {
            PluginEntry p = (PluginEntry)this.pluginEntries.get(i);
            if (map.containsKey(p.getURL())) {
                plugins.add(p);
            }
            ++i;
        }
        return plugins.toArray(new PluginEntry[plugins.size()]);
    }

    @Override
    public long getChangeStamp() {
        if (this.changeStamp == 0L) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    @Override
    public long getFeaturesChangeStamp() {
        if (this.featuresChangeStamp == 0L) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    @Override
    public long getPluginsChangeStamp() {
        if (this.pluginsChangeStamp == 0L) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private void detectFeatures() {
        if (this.featureEntries != null) {
            this.validateFeatureEntries();
        } else {
            this.featureEntries = new TreeMap();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            return;
        }
        File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File featuresDir = new File(siteRoot, "features");
        if (featuresDir.exists()) {
            File[] dirs;
            File[] fileArray = dirs = featuresDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    boolean valid;
                    if (isMacOS && f.getName().equals(SiteEntry.MAC_OS_MARKER)) {
                        return false;
                    }
                    boolean bl = valid = f.isDirectory() && new File(f, "feature.xml").exists();
                    if (!valid) {
                        Utils.log(NLS.bind((String)Messages.SiteEntry_cannotFindFeatureInDir, (Object[])new String[]{f.getAbsolutePath()}));
                    }
                    return valid;
                }
            });
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                try {
                    URL featureURL;
                    FeatureEntry featureEntry;
                    File featureXML = new File(dir, "feature.xml");
                    if ((featureXML.lastModified() > this.featuresChangeStamp || dir.lastModified() > this.featuresChangeStamp) && (featureEntry = featureParser.parse(featureURL = featureXML.toURL())) != null) {
                        this.addFeatureEntry(featureEntry);
                    }
                }
                catch (MalformedURLException e) {
                    Utils.log(NLS.bind((String)Messages.InstalledSiteParser_UnableToCreateURLForFile, (Object[])new String[]{featuresDir.getAbsolutePath()}));
                }
                ++n2;
            }
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.featureEntries.size() + " feature(s)");
    }

    private void detectPlugins() {
        boolean compareTimeStamps = false;
        if (this.pluginEntries != null) {
            this.validatePluginEntries();
            compareTimeStamps = true;
        } else {
            this.pluginEntries = new ArrayList();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            return;
        }
        File pluginsDir = new File(this.resolvedURL.getFile(), "plugins");
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            File[] files;
            File[] fileArray = files = pluginsDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.detectUnpackedPlugin(file, compareTimeStamps);
                } else if (file.getName().endsWith(".jar")) {
                    this.detectPackedPlugin(file, compareTimeStamps);
                }
                ++n2;
            }
        }
        Utils.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.pluginEntries.size() + " plugin(s)");
    }

    private void detectPackedPlugin(File file, boolean compareTimeStamps) {
        if (compareTimeStamps && file.lastModified() <= this.pluginsChangeStamp) {
            return;
        }
        String entryName = "META-INF/MANIFEST.MF";
        ZipFile z = null;
        InputStream bundleManifestIn = null;
        InputStream pluginManifestIn = null;
        String pluginURL = "plugins/" + file.getName();
        try {
            BundleManifest manifest;
            z = new ZipFile(file);
            if (z.getEntry(entryName) != null && (manifest = new BundleManifest(bundleManifestIn = z.getInputStream(new ZipEntry(entryName)), pluginURL)).exists()) {
                this.addPluginEntry(manifest.getPluginEntry());
                return;
            }
            try {
                entryName = "plugin.xml";
                if (z.getEntry(entryName) == null) {
                    entryName = "fragment.xml";
                }
                if (z.getEntry(entryName) != null) {
                    pluginManifestIn = z.getInputStream(new ZipEntry(entryName));
                    PluginEntry entry1 = pluginParser.parse(pluginManifestIn, pluginURL);
                    this.addPluginEntry(entry1);
                }
            }
            catch (IOException e5) {
                String pluginFileString2 = String.valueOf(pluginURL) + "!" + entryName;
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorAccessing, (Object[])new String[]{pluginFileString2}));
            }
            catch (SAXException e3) {
                String pluginFileString1 = String.valueOf(pluginURL) + "!" + entryName;
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{pluginFileString1}));
            }
        }
        finally {
            if (bundleManifestIn != null) {
                try {
                    bundleManifestIn.close();
                }
                catch (IOException iOException) {}
            }
            if (pluginManifestIn != null) {
                try {
                    pluginManifestIn.close();
                }
                catch (IOException iOException) {}
            }
            if (z != null) {
                try {
                    z.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void detectUnpackedPlugin(File file, boolean compareTimeStamps) {
        long dirTimestamp = file.lastModified();
        File pluginFile = new File(file, "META-INF/MANIFEST.MF");
        try {
            BundleManifest bundleManifest = new BundleManifest(pluginFile);
            if (bundleManifest.exists()) {
                if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                    return;
                }
                PluginEntry entry = bundleManifest.getPluginEntry();
                this.addPluginEntry(entry);
            } else {
                pluginFile = new File(file, "plugin.xml");
                if (!pluginFile.exists()) {
                    pluginFile = new File(file, "fragment.xml");
                }
                if (pluginFile.exists() && !pluginFile.isDirectory()) {
                    if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                        return;
                    }
                    PluginEntry entry = pluginParser.parse(pluginFile);
                    this.addPluginEntry(entry);
                }
            }
        }
        catch (IOException e) {
            String pluginFileString = pluginFile.getAbsolutePath();
            if (ConfigurationActivator.DEBUG) {
                Utils.log(Utils.newStatus(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{pluginFileString}), e));
            } else {
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorAccessing, (Object[])new String[]{pluginFileString}));
            }
        }
        catch (SAXException e) {
            String pluginFileString = pluginFile.getAbsolutePath();
            Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{pluginFileString}));
        }
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        String[] features = new String[this.featureEntries.size()];
        Iterator iterator = this.featureEntries.values().iterator();
        int i = 0;
        while (i < features.length) {
            features[i] = ((FeatureEntry)iterator.next()).getURL();
            ++i;
        }
        return features;
    }

    private synchronized String[] getDetectedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        String[] plugins = new String[this.pluginEntries.size()];
        int i = 0;
        while (i < plugins.length) {
            plugins[i] = ((PluginEntry)this.pluginEntries.get(i)).getURL();
            ++i;
        }
        return plugins;
    }

    private void computeChangeStamp() {
        this.changeStamp = Math.max(this.computeFeaturesChangeStamp(), this.computePluginsChangeStamp());
    }

    private synchronized long computeFeaturesChangeStamp() {
        if (this.featuresChangeStamp > 0L) {
            return this.featuresChangeStamp;
        }
        long start = 0L;
        if (ConfigurationActivator.DEBUG) {
            start = new Date().getTime();
        }
        String[] features = this.getFeatures();
        long dirStamp = 0L;
        if (PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File featuresDir = new File(root, "features");
            dirStamp = featuresDir.lastModified();
        }
        this.featuresChangeStamp = Math.max(dirStamp, this.computeStamp(features));
        if (ConfigurationActivator.DEBUG) {
            long end = new Date().getTime();
            Utils.debug(String.valueOf(this.resolvedURL.toString()) + " feature stamp: " + this.featuresChangeStamp + " in " + (end - start) + "ms");
        }
        return this.featuresChangeStamp;
    }

    private synchronized long computePluginsChangeStamp() {
        if (this.pluginsChangeStamp > 0L) {
            return this.pluginsChangeStamp;
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_computePluginStamp, (Object[])new String[]{this.resolvedURL.toExternalForm()}));
            return 0L;
        }
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File pluginsDir = new File(root, "plugins");
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_pluginsDir, (Object[])new String[]{pluginsDir.getAbsolutePath()}));
            return 0L;
        }
        this.pluginsChangeStamp = pluginsDir.lastModified();
        return this.pluginsChangeStamp;
    }

    private long computeStamp(String[] targets) {
        long result = 0L;
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            String[] stringArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                String target = stringArray[n2];
                result ^= (long)target.hashCode();
                ++n2;
            }
            Utils.debug("*WARNING* computing stamp using URL hashcodes only");
        } else {
            File rootFile = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            if (rootFile.exists()) {
                File f = null;
                String[] stringArray = targets;
                int n = targets.length;
                int n3 = 0;
                while (n3 < n) {
                    String target = stringArray[n3];
                    f = new File(rootFile, target);
                    if (f.exists()) {
                        result = Math.max(result, f.lastModified());
                    }
                    ++n3;
                }
            }
        }
        return result;
    }

    public void setLinkFileName(String linkFileName) {
        this.linkFileName = linkFileName;
    }

    public String getLinkFileName() {
        return this.linkFileName;
    }

    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().equals("");
    }

    public synchronized void refresh() {
        this.featuresChangeStamp = 0L;
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.featureEntries = null;
        this.pluginEntries = null;
    }

    public void refreshPlugins() {
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.pluginEntries = null;
    }

    public void addFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        FeatureEntry existing;
        if (this.featureEntries == null) {
            this.featureEntries = new TreeMap();
        }
        if ((existing = (FeatureEntry)this.featureEntries.get(feature.getFeatureIdentifier())) != null) {
            VersionedIdentifier newVersion;
            VersionedIdentifier existingVersion = new VersionedIdentifier(existing.getFeatureIdentifier(), existing.getFeatureVersion());
            if (!existingVersion.isGreater(newVersion = new VersionedIdentifier(feature.getFeatureIdentifier(), feature.getFeatureVersion()))) {
                this.featureEntries.put(feature.getFeatureIdentifier(), feature);
                this.pluginsChangeStamp = 0L;
            } else if (existingVersion.equals(newVersion) && feature instanceof FeatureEntry && existing instanceof FeatureEntry && !((FeatureEntry)feature).getURL().equals(existing.getURL())) {
                Utils.log(NLS.bind((String)Messages.SiteEntry_duplicateFeature, (Object[])new String[]{existing.getURL(), ((FeatureEntry)feature).getURL(), existing.getFeatureIdentifier(), this.getURL().toExternalForm()}));
            }
        } else {
            this.featureEntries.put(feature.getFeatureIdentifier(), feature);
            this.pluginsChangeStamp = 0L;
        }
        if (feature instanceof FeatureEntry) {
            ((FeatureEntry)feature).setSite(this);
        }
    }

    public FeatureEntry[] getFeatureEntries() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        if (this.featureEntries == null) {
            return new FeatureEntry[0];
        }
        return this.featureEntries.values().toArray(new FeatureEntry[this.featureEntries.size()]);
    }

    public void addPluginEntry(PluginEntry plugin) {
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(plugin);
    }

    public PluginEntry[] getAllPluginEntries() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        return this.pluginEntries.toArray(new PluginEntry[this.pluginEntries.size()]);
    }

    public void loadFromDisk(long lastChange) throws CoreException {
        this.featuresChangeStamp = lastChange;
        this.pluginsChangeStamp = lastChange;
        this.detectFeatures();
        this.detectPlugins();
    }

    public Element toXML(Document doc) {
        FeatureEntry[] feats;
        Element siteElement = doc.createElement("site");
        if (this.getURL() != null) {
            URL toPersist = this.config == null || this.config.isTransient() ? this.getURL() : Utils.makeRelative(this.config.getInstallURL(), this.getURL());
            siteElement.setAttribute("url", toPersist.toString());
        }
        siteElement.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        siteElement.setAttribute("updateable", this.isUpdateable() ? "true" : "false");
        if (this.isExternallyLinkedSite()) {
            siteElement.setAttribute("linkfile", this.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int type = this.getSitePolicy().getType();
        String typeString = "UNKNOWN";
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        siteElement.setAttribute("policy", typeString);
        String[] list = this.getSitePolicy().getList();
        if (list.length > 0) {
            StringBuffer sb = new StringBuffer(256);
            int i = 0;
            while (i < list.length - 1) {
                sb.append(list[i]);
                sb.append(',');
                ++i;
            }
            sb.append(list[list.length - 1]);
            siteElement.setAttribute("list", sb.toString());
        }
        FeatureEntry[] featureEntryArray = feats = this.getFeatureEntries();
        int n = feats.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry feat = featureEntryArray[n2];
            Element featureElement = feat.toXML(doc);
            siteElement.appendChild(featureElement);
            ++n2;
        }
        return siteElement;
    }

    private void validateFeatureEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        Iterator iterator = this.featureEntries.values().iterator();
        ArrayList<String> deletedFeatures = new ArrayList<String>();
        while (iterator.hasNext()) {
            FeatureEntry feature = (FeatureEntry)iterator.next();
            File featureXML = new File(root, feature.getURL());
            if (featureXML.exists()) continue;
            deletedFeatures.add(feature.getFeatureIdentifier());
        }
        Iterator it = deletedFeatures.iterator();
        while (it.hasNext()) {
            this.featureEntries.remove(it.next());
        }
    }

    private void validatePluginEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        ArrayList<PluginEntry> deletedPlugins = new ArrayList<PluginEntry>();
        int i = 0;
        while (i < this.pluginEntries.size()) {
            PluginEntry plugin = (PluginEntry)this.pluginEntries.get(i);
            File pluginLocation = new File(root, plugin.getURL());
            if (!pluginLocation.exists()) {
                deletedPlugins.add(plugin);
            }
            ++i;
        }
        Iterator it = deletedPlugins.iterator();
        while (it.hasNext()) {
            this.pluginEntries.remove(it.next());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public FeatureEntry getFeatureEntry(String id) {
        FeatureEntry[] features;
        FeatureEntry[] featureEntryArray = features = this.getFeatureEntries();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry feature = featureEntryArray[n2];
            if (feature.getFeatureIdentifier().equals(id)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        FeatureEntry existingFeature = this.getFeatureEntry(feature.getFeatureIdentifier());
        if (existingFeature != null) {
            if (this.isSameVersion(feature, existingFeature)) {
                this.featureEntries.remove(existingFeature.getFeatureIdentifier());
            } else {
                existingFeature = null;
            }
        }
        return existingFeature != null;
    }

    private boolean isSameVersion(IPlatformConfiguration.IFeatureEntry f1, IPlatformConfiguration.IFeatureEntry f2) {
        String v2;
        String v1 = f1.getFeatureVersion();
        if (v1 == (v2 = f2.getFeatureVersion())) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public void initialized() {
        if (this.featureEntries == null) {
            this.featureEntries = new TreeMap();
        }
    }

    public void noPlugins() {
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
    }
}

