/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.eclipse.internals.update.configurator;

import com.ibm.cic.eclipse.internals.update.configurator.Configuration;
import com.ibm.cic.eclipse.internals.update.configurator.ConfigurationActivator;
import com.ibm.cic.eclipse.internals.update.configurator.ConfigurationParser;
import com.ibm.cic.eclipse.internals.update.configurator.FeatureEntry;
import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.Messages;
import com.ibm.cic.eclipse.internals.update.configurator.PluginEntry;
import com.ibm.cic.eclipse.internals.update.configurator.SiteEntry;
import com.ibm.cic.eclipse.internals.update.configurator.SitePolicy;
import com.ibm.cic.eclipse.internals.update.configurator.Utils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SyncFailedException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Locker;
import org.eclipse.update.internal.configurator.Locker_JavaNio;
import org.eclipse.update.internal.configurator.XMLPrintHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PlatformConfiguration
implements IPlatformConfiguration,
IConfigurationConstants {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private static final String XML_ENCODING = "UTF-8";
    private Configuration config;
    private URL configLocation;
    private HashMap externalLinkSites;
    private long changeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid;
    private Locker lock = null;
    private static boolean checkNio = false;
    private static boolean useNio;
    private static final String ECLIPSE = "eclipse";
    private static final String CONFIG_HISTORY = "history";
    private static final String PLATFORM_XML = "platform.xml";
    private static final String CONFIG_NAME = "org.eclipse.update/platform.xml";
    private static final String CONFIG_INI = "config.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String LINKS = "links";
    private static final String[] BOOTSTRAP_PLUGINS;
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.ide.workbench";
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static URL installURL;

    static {
        BOOTSTRAP_PLUGINS = new String[0];
    }

    private PlatformConfiguration(Location platformConfigLocation) throws CoreException, IOException {
        this.externalLinkSites = new HashMap();
        this.config = null;
        this.initializeCurrent(platformConfigLocation);
        if (!this.isTransient()) {
            this.configureExternalLinks();
        }
        this.validateSites();
        if (this.isTransient()) {
            return;
        }
        this.changeStamp = this.computeChangeStamp();
        if (this.changeStamp > this.config.getDate().getTime()) {
            this.reconcile();
        }
    }

    PlatformConfiguration(URL url) throws Exception {
        this.externalLinkSites = new HashMap();
        this.initialize(url, Utils.getInstallURL());
    }

    public PlatformConfiguration(URL url, URL installLocation, boolean create, boolean discover) throws Exception {
        try {
            this.externalLinkSites = new HashMap();
            this.initialize(url, installLocation);
        }
        catch (Exception e) {
            if (create) {
                this.createDefaultConfiguration(url, installLocation, discover);
                this.configLocation = url;
            }
            throw e;
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.saveAsXML(os);
            return ((Object)os).toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public IPlatformConfiguration.ISiteEntry createSiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        return new SiteEntry(url, policy);
    }

    @Override
    public IPlatformConfiguration.ISitePolicy createSitePolicy(int type, String[] list) {
        return new SitePolicy(type, list);
    }

    @Override
    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginVersion, primary, application, root);
    }

    @Override
    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, root);
    }

    @Override
    public void configureSite(IPlatformConfiguration.ISiteEntry entry) {
        this.configureSite(entry, false);
    }

    @Override
    public synchronized void configureSite(IPlatformConfiguration.ISiteEntry entry, boolean replace) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        if (this.config.getSiteEntry(key) != null && !replace) {
            return;
        }
        if (entry instanceof SiteEntry) {
            this.config.addSiteEntry(key, (SiteEntry)entry);
        }
    }

    @Override
    public synchronized void unconfigureSite(IPlatformConfiguration.ISiteEntry entry) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        if (entry instanceof SiteEntry) {
            this.config.removeSiteEntry(key);
        }
    }

    @Override
    public IPlatformConfiguration.ISiteEntry[] getConfiguredSites() {
        if (this.config == null) {
            return new IPlatformConfiguration.ISiteEntry[0];
        }
        SiteEntry[] sites = this.config.getSites();
        ArrayList<SiteEntry> enabledSites = new ArrayList<SiteEntry>(sites.length);
        SiteEntry[] siteEntryArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            if (site.isEnabled()) {
                enabledSites.add(site);
            }
            ++n2;
        }
        return enabledSites.toArray(new IPlatformConfiguration.ISiteEntry[enabledSites.size()]);
    }

    @Override
    public IPlatformConfiguration.ISiteEntry findConfiguredSite(URL url) {
        return this.findConfiguredSite(url, true);
    }

    public SiteEntry findConfiguredSite(URL url, boolean checkPlatformURL) {
        if (url == null) {
            return null;
        }
        String key = url.toExternalForm();
        SiteEntry result = this.config.getSiteEntry(key);
        if (result == null) {
            try {
                key = URLDecoder.decode(key, XML_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            result = this.config.getSiteEntry(key);
        }
        if (result == null && checkPlatformURL) {
            try {
                result = this.findConfiguredSite(Utils.asPlatformURL(url), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public synchronized void configureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        SiteEntry[] sites;
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                SiteEntry site = siteEntryArray[n2];
                try {
                    URL url = new URL(site.getURL(), "features/" + entry.getFeatureIdentifier() + "_" + entry.getFeatureVersion() + "/");
                    try {
                        url = PlatformConfiguration.resolvePlatformURL(url, this.config.getInstallURL());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (new File(url.getFile()).exists()) {
                        site.addFeatureEntry(entry);
                        break block12;
                    }
                    url = new URL(site.getURL(), "features/" + entry.getFeatureIdentifier() + "/");
                    try {
                        url = PlatformConfiguration.resolvePlatformURL(url, this.config.getInstallURL());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (new File(url.getFile()).exists()) {
                        site.addFeatureEntry(entry);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    @Override
    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.config.unconfigureFeatureEntry(entry);
    }

    @Override
    public IPlatformConfiguration.IFeatureEntry[] getConfiguredFeatureEntries() {
        SiteEntry[] sites;
        ArrayList<FeatureEntry> configFeatures = new ArrayList<FeatureEntry>();
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry[] features;
            SiteEntry site = siteEntryArray[n2];
            FeatureEntry[] featureEntryArray = features = site.getFeatureEntries();
            int n3 = features.length;
            int n4 = 0;
            while (n4 < n3) {
                FeatureEntry feature = featureEntryArray[n4];
                configFeatures.add(feature);
                ++n4;
            }
            ++n2;
        }
        return configFeatures.toArray(new FeatureEntry[configFeatures.size()]);
    }

    @Override
    public IPlatformConfiguration.IFeatureEntry findConfiguredFeatureEntry(String id) {
        SiteEntry[] sites;
        if (id == null) {
            return null;
        }
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            FeatureEntry f = site.getFeatureEntry(id);
            if (f != null) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    @Override
    public long getChangeStamp() {
        if (this.config.getLinkedConfig() == null) {
            return this.config.getDate().getTime();
        }
        return Math.max(this.config.getDate().getTime(), this.config.getLinkedConfig().getDate().getTime());
    }

    @Override
    public long getFeaturesChangeStamp() {
        return 0L;
    }

    @Override
    public long getPluginsChangeStamp() {
        return 0L;
    }

    public String getApplicationIdentifier() {
        IPlatformConfiguration.IFeatureEntry fe;
        String application = ConfigurationActivator.getBundleContext().getProperty("eclipse.application");
        if (application != null) {
            return application;
        }
        String feature = this.getPrimaryFeatureIdentifier();
        if (feature != null && (fe = this.findConfiguredFeatureEntry(feature)) != null && fe.getFeatureApplication() != null) {
            return fe.getFeatureApplication();
        }
        return DEFAULT_FEATURE_APPLICATION;
    }

    @Override
    public String getPrimaryFeatureIdentifier() {
        IPlatformConfiguration.IFeatureEntry feature;
        String primaryFeatureId = ConfigurationActivator.getBundleContext().getProperty("eclipse.product");
        if (primaryFeatureId != null && (feature = this.findConfiguredFeatureEntry(primaryFeatureId)) != null && feature.canBePrimary()) {
            return primaryFeatureId;
        }
        return null;
    }

    @Override
    public URL[] getPluginPath() {
        IPlatformConfiguration.ISiteEntry[] sites;
        ArrayList<URL> path = new ArrayList<URL>();
        Utils.debug("computed plug-in path:");
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = sites = this.getConfiguredSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] plugins;
            IPlatformConfiguration.ISiteEntry site = iSiteEntryArray[n2];
            String[] stringArray = plugins = site.getPlugins();
            int n3 = plugins.length;
            int n4 = 0;
            while (n4 < n3) {
                String plugin = stringArray[n4];
                try {
                    URL pathURL = new URL(((SiteEntry)site).getResolvedURL(), plugin);
                    path.add(pathURL);
                    Utils.debug("   " + pathURL.toString());
                }
                catch (MalformedURLException e) {
                    Utils.debug("   bad URL: " + e);
                }
                ++n4;
            }
            ++n2;
        }
        return path.toArray(new URL[0]);
    }

    public Set getPluginPaths() {
        IPlatformConfiguration.ISiteEntry[] sites;
        HashSet<String> paths = new HashSet<String>();
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = sites = this.getConfiguredSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] plugins;
            IPlatformConfiguration.ISiteEntry site = iSiteEntryArray[n2];
            String[] stringArray = plugins = site.getPlugins();
            int n3 = plugins.length;
            int n4 = 0;
            while (n4 < n3) {
                String plugin = stringArray[n4];
                paths.add(plugin);
                ++n4;
            }
            ++n2;
        }
        return paths;
    }

    public PluginEntry[] getPlugins() {
        ArrayList<PluginEntry> allPlugins = new ArrayList<PluginEntry>();
        Utils.debug("computed plug-ins:");
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            if (!(sites[i] instanceof SiteEntry)) {
                Utils.debug("Site " + sites[i].getURL() + " is not a SiteEntry");
            } else {
                PluginEntry[] plugins;
                PluginEntry[] pluginEntryArray = plugins = ((SiteEntry)sites[i]).getPluginEntries();
                int n = plugins.length;
                int n2 = 0;
                while (n2 < n) {
                    PluginEntry plugin = pluginEntryArray[n2];
                    allPlugins.add(plugin);
                    Utils.debug("   " + plugin.getURL());
                    ++n2;
                }
            }
            ++i;
        }
        return allPlugins.toArray(new PluginEntry[0]);
    }

    @Override
    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    @Override
    public void setBootstrapPluginLocation(String id, URL location) {
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public boolean isTransient() {
        if (this.config != null) {
            return this.config.isTransient();
        }
        return false;
    }

    @Override
    public void isTransient(boolean value) {
        if (this != PlatformConfiguration.getCurrent() && this.config != null) {
            this.config.setTransient(value);
        }
    }

    @Override
    public synchronized void refresh() {
        IPlatformConfiguration.ISiteEntry[] sites;
        IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = sites = this.getConfiguredSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformConfiguration.ISiteEntry site = iSiteEntryArray[n2];
            if (site.isUpdateable()) {
                ((SiteEntry)site).refresh();
            }
            ++n2;
        }
    }

    @Override
    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    @Override
    public synchronized void save(URL url) throws IOException {
        block30: {
            File workingDir;
            if (url == null) {
                throw new IOException(Messages.cfig_unableToSave_noURL);
            }
            OutputStream os = null;
            if (!url.getProtocol().equals("file")) {
                URLConnection uc = url.openConnection();
                uc.setDoOutput(true);
                os = uc.getOutputStream();
                try {
                    try {
                        this.saveAsXML(os);
                        this.config.setDirty(false);
                        break block30;
                    }
                    catch (CoreException e) {
                        Utils.log(e.getMessage());
                        Utils.log(e.getStatus());
                        throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{url.toExternalForm()}));
                    }
                }
                finally {
                    os.close();
                }
            }
            File cfigFile = new File(url.getFile().replace('/', File.separatorChar));
            if (!cfigFile.getName().equals(PLATFORM_XML)) {
                if (cfigFile.exists() && cfigFile.isFile()) {
                    Utils.log(String.valueOf(Messages.PlatformConfiguration_expectingPlatformXMLorDirectory) + cfigFile.getName());
                    cfigFile = cfigFile.getParentFile();
                }
                cfigFile = new File(cfigFile, CONFIG_NAME);
            }
            if ((workingDir = cfigFile.getParentFile()) != null && !workingDir.exists()) {
                workingDir.mkdirs();
            }
            File cfigFileOriginal = new File(cfigFile.getAbsolutePath());
            File cfigTmp = new File(String.valueOf(cfigFile.getAbsolutePath()) + CONFIG_FILE_TEMP_SUFFIX);
            if (cfigFile.exists()) {
                File backupDir = new File(workingDir, CONFIG_HISTORY);
                if (!backupDir.exists()) {
                    backupDir.mkdir();
                }
                long timestamp = cfigFile.lastModified();
                File preservedFile = new File(backupDir, String.valueOf(String.valueOf(timestamp)) + ".xml");
                long increment = 1L;
                while (preservedFile.exists() && increment < 100L) {
                    preservedFile = new File(backupDir, String.valueOf(String.valueOf(timestamp + increment++)) + ".xml");
                }
                if (!preservedFile.exists() && !cfigFile.renameTo(preservedFile)) {
                    Utils.log(Messages.PlatformConfiguration_cannotBackupConfig);
                }
            }
            os = new FileOutputStream(cfigTmp);
            try {
                try {
                    this.saveAsXML(os);
                    try {
                        os.flush();
                        ((FileOutputStream)os).getFD().sync();
                    }
                    catch (SyncFailedException e2) {
                        Utils.log(e2.getMessage());
                    }
                    catch (IOException e2) {
                        Utils.log(e2.getMessage());
                    }
                    try {
                        os.close();
                        os = null;
                    }
                    catch (IOException e1) {
                        Utils.log(NLS.bind((String)Messages.PlatformConfiguration_cannotCloseStream, (Object)cfigTmp));
                        Utils.log(e1.getMessage());
                    }
                    cfigTmp.setLastModified(this.config.getDate().getTime());
                    this.config.setLastModified(cfigTmp.lastModified());
                    this.changeStamp = this.config.getDate().getTime();
                    this.config.setDirty(false);
                }
                catch (CoreException e) {
                    throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{cfigTmp.getAbsolutePath()}));
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseTempFile) + cfigTmp);
                    }
                }
            }
            boolean ok = cfigTmp.renameTo(cfigFileOriginal);
            if (!ok) {
                Utils.log(Messages.PlatformConfiguration_cannotRenameTempFile);
                throw new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{cfigTmp.getAbsolutePath()}));
            }
        }
    }

    public static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    public static synchronized void startup(URL installURL, Location platformConfigLocation) throws Exception {
        PlatformConfiguration.installURL = installURL;
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(platformConfigLocation);
            if (PlatformConfiguration.currentPlatformConfiguration.config == null) {
                throw new Exception(NLS.bind((String)Messages.PlatformConfiguration_cannotLoadConfig, (Object)platformConfigLocation.getURL()));
            }
            if (PlatformConfiguration.currentPlatformConfiguration.config.isDirty() && !currentPlatformConfiguration.isTransient()) {
                currentPlatformConfiguration.save();
            }
        }
    }

    public static synchronized void shutdown() throws IOException {
        PlatformConfiguration config = PlatformConfiguration.getCurrent();
        if (config != null && config.config.isDirty() && !config.isTransient()) {
            try {
                config.save();
            }
            catch (IOException e) {
                Utils.debug("Unable to save configuration " + e.toString());
            }
        }
    }

    private synchronized void initializeCurrent(Location platformConfigLocation) throws IOException {
        block11: {
            URL configFileURL = new URL(platformConfigLocation.getURL(), CONFIG_NAME);
            try {
                this.getConfigurationLock(platformConfigLocation.getURL());
                try {
                    this.config = this.loadConfig(configFileURL, installURL);
                    Utils.debug("Using configuration " + configFileURL.toString());
                }
                catch (Exception e) {
                    block12: {
                        try {
                            Location parentLocation = platformConfigLocation.getParentLocation();
                            if (parentLocation == null) {
                                throw new IOException();
                            }
                            URL sharedConfigFileURL = new URL(parentLocation.getURL(), CONFIG_NAME);
                            this.config = this.loadConfig(sharedConfigFileURL, installURL);
                            if (!sharedConfigFileURL.equals(configFileURL)) {
                                this.linkInitializedState(this.config, parentLocation, platformConfigLocation);
                                Utils.debug("Configuration initialized from    " + sharedConfigFileURL.toString());
                            }
                            this.configLocation = configFileURL;
                            if (this.config.getURL() != null) break block12;
                            this.config.setURL(configFileURL);
                        }
                        catch (Exception ioe) {
                            Utils.debug("Creating default configuration from " + configFileURL.toExternalForm());
                            this.createDefaultConfiguration(configFileURL, installURL, true);
                            break block11;
                        }
                    }
                    PlatformConfiguration.verifyPath(this.configLocation, this.config.getInstallURL());
                    Utils.debug("Creating configuration " + configFileURL.toString());
                    this.clearConfigurationLock();
                    return;
                }
            }
            finally {
                this.configLocation = configFileURL;
                if (this.config.getURL() == null) {
                    this.config.setURL(configFileURL);
                }
                PlatformConfiguration.verifyPath(this.configLocation, this.config.getInstallURL());
                Utils.debug("Creating configuration " + configFileURL.toString());
                this.clearConfigurationLock();
            }
        }
    }

    private synchronized void initialize(URL url, URL installLocation) throws Exception {
        if (url != null) {
            this.config = this.loadConfig(url, installLocation);
            Utils.debug("Using configuration " + url.toString());
        }
        if (this.config == null) {
            this.config = new Configuration();
            Utils.debug("Creating empty configuration object");
        }
        this.config.setURL(url);
        this.config.setInstallLocation(installLocation);
        this.configLocation = url;
    }

    private void createDefaultConfiguration(URL url, URL installLocation, boolean discover) throws IOException {
        this.config = new Configuration();
        this.config.setURL(url);
        this.config.setInstallLocation(installLocation);
        SiteEntry defaultSite = (SiteEntry)this.getRootSite();
        this.configureSite(defaultSite);
        if (!discover) {
            defaultSite.noPlugins();
            defaultSite.initialized();
            return;
        }
        try {
            defaultSite.loadFromDisk(0L);
        }
        catch (CoreException e1) {
            Utils.log(NLS.bind((String)Messages.PlatformConfiguration_cannotLoadDefaultSite, (Object)defaultSite.getResolvedURL()));
            return;
        }
    }

    private IPlatformConfiguration.ISiteEntry getRootSite() {
        IPlatformConfiguration.ISitePolicy defaultPolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        URL siteURL = null;
        try {
            siteURL = new URL("platform:/base/");
        }
        catch (MalformedURLException e) {
            siteURL = PlatformConfiguration.getInstallURL();
        }
        IPlatformConfiguration.ISiteEntry defaultSite = this.createSiteEntry(siteURL, defaultPolicy);
        return defaultSite;
    }

    private void getConfigurationLock(URL url) {
        if (!url.getProtocol().equals("file")) {
            return;
        }
        File lockFile = new File(url.getFile(), "org.eclipse.update" + File.separator + CONFIG_FILE_LOCK_SUFFIX);
        PlatformConfiguration.verifyPath(url, this.config == null ? null : this.config.getInstallURL());
        this.lock = PlatformConfiguration.createLocker(lockFile);
        try {
            this.lock.lock();
        }
        catch (IOException ioe) {
            this.lock = null;
        }
    }

    private void clearConfigurationLock() {
        if (this.lock != null) {
            this.lock.release();
        }
    }

    private static Locker createLocker(File lock) {
        if (!checkNio) {
            useNio = true;
            try {
                Class.forName("java.nio.channels.FileLock");
            }
            catch (ClassNotFoundException e) {
                useNio = false;
            }
        }
        return new Locker_JavaNio(lock);
    }

    private long computeChangeStamp() {
        this.featuresChangeStamp = this.computeFeaturesChangeStamp();
        this.pluginsChangeStamp = this.computePluginsChangeStamp();
        this.changeStamp = Math.max(this.featuresChangeStamp, this.pluginsChangeStamp);
        this.changeStamp = this.changeStamp / 1000L * 1000L;
        return this.changeStamp;
    }

    private long computeFeaturesChangeStamp() {
        SiteEntry[] sites;
        if (this.featuresChangeStampIsValid) {
            return this.featuresChangeStamp;
        }
        long result = 0L;
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            result = Math.max(result, site.getFeaturesChangeStamp());
            ++n2;
        }
        this.featuresChangeStamp = result;
        this.featuresChangeStampIsValid = true;
        return this.featuresChangeStamp;
    }

    private long computePluginsChangeStamp() {
        SiteEntry[] sites;
        if (this.pluginsChangeStampIsValid) {
            return this.pluginsChangeStamp;
        }
        long result = 0L;
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            result = Math.max(result, site.getPluginsChangeStamp());
            ++n2;
        }
        this.pluginsChangeStamp = result;
        this.pluginsChangeStampIsValid = true;
        return this.pluginsChangeStamp;
    }

    private void configureExternalLinks() {
        URL linkURL = PlatformConfiguration.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(linkURL, this.config.getInstallURL())) {
            return;
        }
        try {
            linkURL = new URL(linkURL, "links/");
        }
        catch (MalformedURLException e) {
            Utils.debug("Unable to obtain link URL");
            return;
        }
        File linkDir = new File(linkURL.getFile());
        File[] links = linkDir.listFiles();
        if (links == null || links.length == 0) {
            Utils.debug("No links detected in " + linkURL.toExternalForm());
            return;
        }
        File[] fileArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                File link = fileArray[n2];
                if (!link.isDirectory()) {
                    Utils.debug("Link file " + link.getAbsolutePath());
                    Properties props = new Properties();
                    FileInputStream is = null;
                    try {
                        try {
                            is = new FileInputStream(link);
                            props.load(is);
                            this.configureExternalLinkSite(link, props);
                        }
                        catch (IOException e) {
                            Utils.debug("   unable to load link file " + e);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void configureExternalLinkSite(File linkFile, Properties props) {
        URL siteURL;
        String link;
        String path = props.getProperty(LINK_PATH);
        if (path == null) {
            Utils.debug("   no path definition");
            return;
        }
        boolean updateable = true;
        if (path.startsWith("r ")) {
            updateable = false;
            link = path.substring(2).trim();
        } else {
            link = path.startsWith("rw ") ? path.substring(3).trim() : path.trim();
        }
        try {
            File siteFile = new File(link);
            siteFile = new File(siteFile, ECLIPSE);
            siteURL = siteFile.toURL();
            if (this.findConfiguredSite(siteURL, true) != null) {
                return;
            }
        }
        catch (MalformedURLException e) {
            Utils.debug("  bad URL " + e);
            return;
        }
        SiteEntry linkSite = (SiteEntry)this.externalLinkSites.get(siteURL);
        if (linkSite == null) {
            IPlatformConfiguration.ISitePolicy linkSitePolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
            linkSite = (SiteEntry)this.createSiteEntry(siteURL, linkSitePolicy);
        }
        linkSite.setUpdateable(updateable);
        linkSite.setLinkFileName(linkFile.getAbsolutePath());
        this.configureSite(linkSite);
        this.config.setDirty(true);
        Utils.debug("   " + (updateable ? "R/W -> " : "R/O -> ") + siteURL.toString());
    }

    private void validateSites() {
        SiteEntry[] list;
        SiteEntry[] siteEntryArray = list = this.config.getSites();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry element = siteEntryArray[n2];
            URL siteURL = element.getResolvedURL();
            if (PlatformConfiguration.supportsDetection(siteURL, this.config.getInstallURL())) {
                File linkFile;
                String linkName;
                File siteRoot = new File(siteURL.getFile().replace('/', File.separatorChar));
                if (!siteRoot.exists()) {
                    this.unconfigureSite(element);
                    Utils.debug("Site " + siteURL + " does not exist ... removing from configuration");
                }
                if ((linkName = element.getLinkFileName()) != null && !(linkFile = new File(linkName)).exists()) {
                    this.unconfigureSite(element);
                    this.config.setDirty(true);
                    Utils.debug("Site " + siteURL + " is no longer linked ... removing from configuration");
                }
            }
            ++n2;
        }
    }

    private void linkInitializedState(Configuration sharedConfig, Location sharedConfigLocation, Location newConfigLocation) {
        try {
            URL newConfigIniURL = new URL(newConfigLocation.getURL(), CONFIG_INI);
            if (!newConfigIniURL.getProtocol().equals("file")) {
                return;
            }
            File configIni = new File(newConfigIniURL.getFile());
            Properties props = new Properties();
            String externalForm = Utils.makeRelative(this.config.getInstallURL(), sharedConfigLocation.getURL()).toExternalForm();
            props.put("osgi.sharedConfiguration.area", externalForm);
            props.store(new FileOutputStream(configIni), "Linked configuration");
            this.config = new Configuration(new Date());
            this.config.setURL(new URL(newConfigLocation.getURL(), CONFIG_NAME));
            this.config.setLinkedConfig(sharedConfig);
            this.config.setDirty(true);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private Configuration loadConfig(URL url, URL installLocation) throws Exception {
        if (url == null) {
            throw new IOException(Messages.cfig_unableToLoad_noURL);
        }
        ConfigurationParser parser = null;
        try {
            parser = new ConfigurationParser();
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        this.config = null;
        Exception originalException = null;
        try {
            this.config = parser.parse(url, installLocation);
            if (this.config == null) {
                throw new Exception(Messages.PlatformConfiguration_cannotFindConfigFile);
            }
        }
        catch (Exception e1) {
            originalException = e1;
            try {
                URL tempURL = new URL(String.valueOf(url.toExternalForm()) + CONFIG_FILE_TEMP_SUFFIX);
                this.config = parser.parse(tempURL, installLocation);
                if (this.config == null) {
                    throw new Exception();
                }
                this.config.setDirty(true);
            }
            catch (Exception e2) {
                try {
                    File[] backups;
                    File cfigFile;
                    File workingDir;
                    if ("file".equals(url.getProtocol()) && (workingDir = (cfigFile = new File(url.getFile().replace('/', File.separatorChar))).getParentFile()) != null && workingDir.exists() && (backups = workingDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().endsWith(".xml");
                        }
                    })) != null && backups.length > 0) {
                        URL backupUrl = backups[backups.length - 1].toURL();
                        this.config = parser.parse(backupUrl, installLocation);
                    }
                    if (this.config == null) {
                        throw originalException;
                    }
                    this.config.setDirty(true);
                }
                catch (IOException e3) {
                    throw originalException;
                }
            }
        }
        return this.config;
    }

    public static boolean supportsDetection(URL url, URL configuration) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return true;
        }
        if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url, configuration);
            }
            catch (IOException e) {
                return false;
            }
            return resolved.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL url, URL configuration) {
        File dir;
        String protocol = url.getProtocol();
        String path = null;
        if (protocol.equals("file")) {
            path = url.getFile();
        } else if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url, configuration);
                if (resolved.getProtocol().equals("file")) {
                    path = resolved.getFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (path != null && (dir = new File(path).getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    public static URL resolvePlatformURL(URL url, URL installLocation) throws IOException {
        if (url.getProtocol().equals("platform")) {
            if (installLocation == null) {
                url = FileLocator.toFileURL((URL)url);
                File f = new File(url.getFile());
                url = f.toURL();
            } else {
                String BASE = "platform:/base/";
                String toResolve = url.toExternalForm();
                if (toResolve.startsWith("platform:/base/")) {
                    return new URL(installLocation, toResolve.substring("platform:/base/".length()));
                }
                return installLocation;
            }
        }
        return url;
    }

    public static URL getInstallURL() {
        return installURL;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    private void saveAsXML(OutputStream stream) throws CoreException, IOException {
        BufferedWriter xmlWriter = new BufferedWriter(new OutputStreamWriter(stream, XML_ENCODING));
        try {
            try {
                DocumentBuilderFactory factory = PlatformConfiguration.createDocumentBuilderFactory();
                factory.setExpandEntityReferences(false);
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                if (this.config == null) {
                    throw Utils.newCoreException(Messages.PlatformConfiguration_cannotSaveNonExistingConfig, null);
                }
                this.config.setDate(new Date());
                Element configElement = this.config.toXML(doc);
                doc.appendChild(configElement);
                XMLPrintHandler.printNode((Writer)xmlWriter, (Node)doc, (String)XML_ENCODING);
            }
            catch (Exception e) {
                throw Utils.newCoreException("", e);
            }
        }
        finally {
            xmlWriter.flush();
        }
    }

    private void reconcile() throws CoreException {
        SiteEntry[] sites;
        long lastChange = this.config.getDate().getTime();
        SiteEntry[] siteEntryArray = sites = this.config.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            long siteTimestamp = site.getChangeStamp();
            if (siteTimestamp > lastChange) {
                site.loadFromDisk(lastChange);
            }
            ++n2;
        }
        this.config.setDirty(true);
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

