/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.executeAdapter.execAdv;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class StateCondition {
    public static final int TYPE_OR = 1;
    public static final int TYPE_AND = 2;
    public static final int TYPE_NOT = 3;
    public static final int TYPE_FILE = 4;
    public static final int TYPE_LOG = 5;
    public static final String OPERATOR_AND = "AND";
    public static final String OPERATOR_OR = "OR";
    public static final String OPERATOR_NOT = "NOT";
    public static final String KEY_TYPE = "Type";
    public static final String KEY_VALUE = "Value";
    public static final String KEY_PATH = "Path";
    public static final String KEY_EVALUATE = "Evaluate";
    public static final String KEY_FILE = "File";
    public static final String KEY_PATTERN = "Pattern";
    private int type = 0;
    private Properties properties = null;
    private Vector operands = null;

    public StateCondition(int type) {
        this.type = type;
        if (type == 2 || type == 1 || type == 3) {
            this.operands = new Vector();
        }
    }

    public void setFileCondition(String path, String eval) {
        Properties p = new Properties();
        p.setProperty(KEY_PATH, path);
        p.setProperty(KEY_EVALUATE, eval);
        this.properties = p;
    }

    public void setLogCondition(String file, String pattern, String eval) {
        Properties p = new Properties();
        p.setProperty(KEY_FILE, file);
        p.setProperty(KEY_PATTERN, pattern);
        p.setProperty(KEY_EVALUATE, eval);
        this.properties = p;
    }

    public void addOperand(StateCondition c) {
        this.operands.add(c);
    }

    public boolean isTrue() {
        if (this.type == 4) {
            return this.isFileConditionTrue();
        }
        if (this.type == 5) {
            return this.isLogConditionTrue();
        }
        if (this.type == 2) {
            for (StateCondition c : this.operands) {
                if (c.isTrue()) continue;
                return false;
            }
            return true;
        }
        if (this.type == 1) {
            for (StateCondition c : this.operands) {
                if (!c.isTrue()) continue;
                return true;
            }
            return false;
        }
        if (this.type == 3) {
            Iterator iter = this.operands.iterator();
            if (iter.hasNext()) {
                StateCondition c = (StateCondition)iter.next();
                return !c.isTrue();
            }
            return false;
        }
        return true;
    }

    private boolean isFileConditionTrue() {
        String path = this.properties.getProperty(KEY_PATH);
        String evaluate = this.properties.getProperty(KEY_EVALUATE);
        File file = new File(path);
        boolean isFileExist = file.exists();
        if (evaluate.equalsIgnoreCase("true") || evaluate.equalsIgnoreCase("yes")) {
            return isFileExist;
        }
        return !isFileExist;
    }

    private boolean isLogConditionTrue() {
        String fileName = this.properties.getProperty(KEY_FILE);
        String evaluate = this.properties.getProperty(KEY_EVALUATE);
        File file = new File(fileName);
        boolean isFileExist = file.exists();
        if (evaluate.equalsIgnoreCase("true") || evaluate.equalsIgnoreCase("yes")) {
            return isFileExist;
        }
        return !isFileExist;
    }
}

