/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.executeAdapter.execAdv;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ExecInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.agent.internal.adapters.executeAdapter.execAdv.StateCondition;
import com.ibm.cic.common.commonNativeAdapterData.ExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.executeAdapterData.IExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.AndExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ArgExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.ExecAdvExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.FileExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.LogExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.NotExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.OrExecuteData;
import com.ibm.cic.common.executeAdapterData.execAdv.StateExecuteData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ExecAdvInstallOperation
extends ExecInstallOperation {
    public ExecAdvInstallOperation(int phase, IInstallableUnit unit, InstallContext context, ExecAdvExecuteData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, (ExecCommonNativeData)data, performData, writer);
    }

    protected void doExec(ExecInstallOperation.ProcessRunner runner, IProgressMonitor monitor) throws CoreException {
        new CustomOperationThread((Runnable)runner).runCustomOperationThread(monitor);
    }

    protected String[] getArguments() {
        ArgExecuteData[] argsData = this.getExecAdvData().getArgs().getArguments();
        String[] result = new String[argsData.length];
        int i = 0;
        while (i < argsData.length) {
            try {
                result[i] = this.performVariableSubstitutions(argsData[i].getArgText(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                result[i] = argsData[i].getArgText();
            }
            ++i;
        }
        return result;
    }

    private ExecAdvExecuteData getExecAdvData() {
        return (ExecAdvExecuteData)this.getData();
    }

    private class CustomOperationThread
    extends Thread {
        public CustomOperationThread(Runnable runnable) {
            super(runnable);
        }

        public void runCustomOperationThread(IProgressMonitor monitor) throws CoreException {
            try {
                int worked = 0;
                monitor.beginTask(null, 100);
                monitor.subTask(this.getSubtask(0));
                this.start();
                StateExecuteData[] stateList = ExecAdvInstallOperation.this.getExecAdvData().getProgress().getStates();
                int i = 0;
                block2: while (i < stateList.length) {
                    StateExecuteData currState = stateList[i];
                    IExecuteData currCondition = currState.getCondition();
                    StateCondition conditionObj = this.createConditionObj(currCondition);
                    while (!conditionObj.isTrue()) {
                        if (!this.isAlive()) break block2;
                        CustomOperationThread.sleep(1000L);
                    }
                    monitor.worked(currState.getPercent() - worked);
                    worked = currState.getPercent();
                    monitor.subTask(this.getSubtask(worked));
                    ++i;
                }
                this.join();
                monitor.done();
            }
            catch (Exception e) {
                throw Util.coreException((Throwable)e, (String)e.toString(), (Object[])new Object[0]);
            }
        }

        private String getSubtask(int worked) throws AbstractVariableSubstitution.VariableSubstitutionException {
            String operation = ExecAdvInstallOperation.this.performVariableSubstitutions(ExecAdvInstallOperation.this.getExecAdvData().getDescription());
            int percent = worked > 100 ? 100 : (worked < 0 ? 0 : worked);
            return NLS.bind((String)Messages.CustomOperationThread_ProgressDesOnGoing, (Object)String.valueOf(percent), (Object)operation);
        }

        private StateCondition createConditionObj(IExecuteData execData) throws AbstractVariableSubstitution.VariableSubstitutionException {
            StateCondition currCondition;
            if (execData instanceof FileExecuteData) {
                FileExecuteData currData = (FileExecuteData)execData;
                currCondition = new StateCondition(4);
                currCondition.setFileCondition(ExecAdvInstallOperation.this.performVariableSubstitutions(currData.getPath(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE), String.valueOf(currData.isEvaluate()));
            } else if (execData instanceof LogExecuteData) {
                LogExecuteData currData = (LogExecuteData)execData;
                currCondition = new StateCondition(5);
                currCondition.setLogCondition(ExecAdvInstallOperation.this.performVariableSubstitutions(currData.getFile(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE), currData.getPattern(), String.valueOf(currData.isEvaluate()));
            } else if (execData instanceof NotExecuteData) {
                NotExecuteData currData = (NotExecuteData)execData;
                IExecuteData child = currData.getCondition();
                currCondition = new StateCondition(3);
                if (child != null) {
                    StateCondition childCondition = this.createConditionObj(child);
                    currCondition.addOperand(childCondition);
                }
            } else if (execData instanceof AndExecuteData) {
                AndExecuteData currData = (AndExecuteData)execData;
                IExecuteData[] children = currData.getConditions();
                currCondition = new StateCondition(2);
                if (children != null) {
                    IExecuteData[] iExecuteDataArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExecuteData element = iExecuteDataArray[n2];
                        StateCondition childCondition = this.createConditionObj(element);
                        currCondition.addOperand(childCondition);
                        ++n2;
                    }
                }
            } else if (execData instanceof OrExecuteData) {
                OrExecuteData currData = (OrExecuteData)execData;
                IExecuteData[] children = currData.getConditions();
                currCondition = new StateCondition(1);
                if (children != null) {
                    IExecuteData[] iExecuteDataArray = children;
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IExecuteData element = iExecuteDataArray[n3];
                        StateCondition childCondition = this.createConditionObj(element);
                        currCondition.addOperand(childCondition);
                        ++n3;
                    }
                }
            } else {
                currCondition = null;
            }
            return currCondition;
        }
    }
}

