/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.eclipseAdapterData.internal;

import com.ibm.cic.common.core.artifactrepo.IArtifactRepositoryAdapter;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IArtifactTypeKeyMapper;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import org.eclipse.core.runtime.IPath;

public class EclipseDataRepositoryAdapter
implements IArtifactRepositoryAdapter {
    private static final String[] TOPLEVEL_DIRS = new String[]{"plugins", "features", "root"};

    public IPath toNamespaceUniquePath(IArtifactKey key) {
        if (!"eclipse".equals(key.getNamespace())) {
            throw new IllegalArgumentException();
        }
        return EclipseArtifact.toNamespaceUniquePath(key);
    }

    public String[] enumerateTopLevelDirs() {
        return TOPLEVEL_DIRS;
    }

    public String toUserString(IArtifactKey key, int options) {
        if (!"eclipse".equals(key.getNamespace())) {
            throw new IllegalArgumentException();
        }
        return EclipseArtifact.toUserString(key, options);
    }

    public IArtifactKey toNamespaceArtifactKey(IPath relPath) {
        IArtifactKey key = EclipseArtifact.toNamespaceArtifactKey(relPath);
        if (key == null) {
            return null;
        }
        IPath path2 = this.toNamespaceUniquePath(key);
        if (!relPath.equals((Object)path2)) {
            return null;
        }
        return key;
    }

    public String[] getSupportedArtifactTypes() {
        return EclipseArtifact.getSupportedArtifactTypes();
    }

    public IArtifactTypeKeyMapper getTypeKeyMapper(String type) {
        return EclipseArtifact.getReferenceParser(type);
    }
}

