/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.eclipseAdapterData.internal;

import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.adapterdata.SizeInfoParserHelper;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAddProgramArgumentsData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAddVMArgumentsData;
import com.ibm.cic.common.eclipseAdapterData.EclipseAgentBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.EclipseRestartData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetConfigPreferenceData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetPropertyData;
import com.ibm.cic.common.eclipseAdapterData.EclipseSetVirtualMachineData;
import com.ibm.cic.common.eclipseAdapterData.EclipseVMArgumentData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import com.ibm.cic.common.eclipseAdapterData.internal.IXMLConstants;
import com.ibm.cic.common.eclipseAdapterData.internal.Messages;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

public class EclipseAdapterDataParser
implements IAdapterDataParser,
IXMLConstants {
    private static final int INITIAL_STATE = 0;
    private static final int BUNDLE_STATE = 2;
    private static final int FEATURE_STATE = 3;
    private static final int AGENT_BUNDLE_STATE = 4;
    private static final int RESTART_STATE = 5;
    private static final int SET_VM_STATE = 6;
    private static final int VM_ARGS_STATE = 7;
    private static final int VM_ARG_STATE = 8;
    private static final int PROPERTY_STATE = 9;
    private static final int CONFIG_PREFERENCE_STATE = 10;
    private static final int PROGRAM_ARGS_STATE = 11;
    private static final int SIZE_INFO_STATE = 12;
    private IInstallableUnit iu;
    private EclipseAdapterData adapterData;
    private IErrorReporter reporter;
    private SizeInfoParserHelper commonParser;
    private int state = 0;

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public void initialize(IInstallableUnit anIU, IErrorReporter theReporter) {
        this.iu = anIU;
        this.adapterData = new EclipseAdapterData();
        this.reporter = theReporter;
        this.commonParser = new SizeInfoParserHelper(this.reporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return this.handleArtifactAttributes(key, attributes);
    }

    public void endArtifact() {
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return this.handleArtifactAttributes(aca, attributes);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        if ("bundle".equals(name)) {
            this.state = 2;
            this.parseBundleAttributes(attributes);
        } else if ("feature".equals(name)) {
            this.state = 3;
            this.parseFeatureAttributes(attributes);
        } else if ("agentBundle".equals(name)) {
            this.state = 4;
            this.parseAgentBundleAttributes(attributes);
        } else if ("restart".equals(name)) {
            this.state = 5;
            this.parseRestartAttributes(attributes);
        } else if ("setvm".equals(name)) {
            this.state = 6;
            this.parseSetVMAttributes(attributes);
        } else if ("vmargs".equals(name)) {
            this.state = 7;
            this.parseVMArgsAttributes(attributes);
        } else if ("arg".equals(name)) {
            if (this.state != 7 && this.state != 11) {
                this.reporter.unexpectedElement("arg", attributes);
            } else {
                this.state = 8;
                this.parseVMArgAttributes(attributes);
            }
        } else if ("programargs".equals(name)) {
            this.state = 11;
            this.parseProgramArgsAttributes(attributes);
        } else if ("property".equals(name)) {
            this.state = 9;
            this.parsePropertyAttributes(attributes);
        } else if ("preference".equals(name)) {
            this.state = 10;
            this.parseConfigPreferenceAttributes(attributes);
        } else if ("sizeInfo".equals(name)) {
            this.state = 12;
            IInstallSizeInfo installSizeInfo = this.commonParser.parseSizeInfoElement(name, qName, attributes);
            if (installSizeInfo != null) {
                this.adapterData.addInstallSizeInfo(installSizeInfo, true);
            }
        } else {
            this.reporter.unexpectedElement(name, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        switch (this.state) {
            case 8: {
                this.state = 7;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    public void characters(String chars) {
        switch (this.state) {
            case 8: {
                this.handleVMArgText(chars);
                break;
            }
            default: {
                this.reporter.unexpectedCharacterData(chars);
            }
        }
    }

    public IAdapterData getAdapterData() {
        return this.adapterData;
    }

    private void handleVMArgText(String argText) {
        EclipseVMArgumentData lastArgument;
        IEclipseData data = this.adapterData.getLastData();
        if (data instanceof EclipseAddVMArgumentsData) {
            EclipseAddVMArgumentsData addVMArgsData = (EclipseAddVMArgumentsData)data;
            lastArgument = addVMArgsData.getLastArgument();
        } else if (data instanceof EclipseAddProgramArgumentsData) {
            EclipseAddProgramArgumentsData addCommandArgsData = (EclipseAddProgramArgumentsData)data;
            lastArgument = addCommandArgsData.getLastArgument();
        } else {
            this.reporter.unexpectedCharacterData(argText);
            return;
        }
        lastArgument.addArgText(argText);
    }

    private IArtifact handleArtifactAttributes(String key, Attributes attributes) {
        int type = 0;
        boolean explode = false;
        boolean gotExplode = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("type")) {
                if (value.equals("plugin")) {
                    type = 2;
                } else if (value.equals("feature")) {
                    type = 3;
                    if (gotExplode && !explode) {
                        this.reporter.error(Messages.bind((String)Messages.EclipseData_artifact_unexploded_feature, (Object)key));
                    }
                } else if (value.equals("root")) {
                    type = 1;
                } else {
                    this.reporter.invalidAttributeValue("artifact", name, value);
                }
            } else if (name.equals("exploded")) {
                explode = Boolean.valueOf(value);
                if (type == 3 && !explode) {
                    this.reporter.error(Messages.bind((String)Messages.EclipseData_artifact_unexploded_feature, (Object)key));
                }
                gotExplode = true;
            } else {
                this.reporter.unexpectedAttribute("artifact", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("artifact", "type", (Object)(type != 0 ? Integer.valueOf(type) : null));
        EclipseArtifact artifact = new EclipseArtifact(key);
        artifact.setExploded(type != 3 ? explode : true);
        artifact.setType(type);
        if (this.iu != null) {
            artifact.initKey(this.iu);
        }
        this.adapterData.addArtifact((IArtifact)artifact);
        return artifact;
    }

    private IArtifact handleArtifactAttributes(ArtifactCommonAttributes aca, Attributes attributes) {
        int type = 0;
        Boolean explode = null;
        if (aca.getType().equals("plugin")) {
            type = 2;
        } else if (aca.getType().equals("feature")) {
            type = 3;
        } else {
            this.reporter.invalidAttributeValue("artifact", "type", aca.getType());
        }
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("exploded")) {
                explode = Boolean.valueOf(value);
                if (type == 3 && !explode.booleanValue()) {
                    this.reporter.error(Messages.bind((String)Messages.EclipseData_artifact_unexploded_feature, (Object)aca));
                }
            } else {
                this.reporter.unexpectedAttribute("artifact", name, value);
            }
            ++i;
        }
        EclipseArtifact artifact = new EclipseArtifact(aca, explode, type);
        this.adapterData.addArtifact((IArtifact)artifact);
        return artifact;
    }

    private void parseBundleAttributes(Attributes attributes) {
        String id = null;
        Version version = null;
        Integer startLevel = null;
        Integer expectedState = null;
        boolean exploded = false;
        boolean singleton = true;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            try {
                if ("id".equals(name)) {
                    id = value;
                } else if ("version".equals(name)) {
                    version = new Version(value);
                } else if ("level".equals(name)) {
                    startLevel = Integer.valueOf(value);
                } else if ("state".equals(name)) {
                    expectedState = EclipseBundleData.convertState(value);
                } else if ("exploded".equals(name)) {
                    exploded = Boolean.valueOf(value);
                } else if ("singleton".equals(name)) {
                    singleton = Boolean.valueOf(value);
                } else {
                    this.reporter.unexpectedAttribute("bundle", name, value);
                }
            }
            catch (IllegalArgumentException iae) {
                this.reporter.invalidAttributeValue("bundle", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("bundle", "id", id);
        this.reporter.checkRequiredAttribute("bundle", "version", (Object)(version != null ? version.toString() : null));
        this.reporter.checkRequiredAttribute("bundle", "level", (Object)(startLevel != null ? startLevel.toString() : null));
        this.reporter.checkRequiredAttribute("bundle", "state", (Object)(expectedState != null ? expectedState.toString() : null));
        EclipseBundleData bundleData = new EclipseBundleData(id, version, startLevel != null ? startLevel : 5, expectedState != null ? expectedState : 4, exploded, singleton);
        this.adapterData.addData(bundleData);
    }

    private void parseFeatureAttributes(Attributes attributes) {
        String id = null;
        Version version = null;
        String pluginId = null;
        Version pluginVersion = null;
        boolean primary = false;
        String application = null;
        String patchedFeatureId = null;
        Version patchedFeatureVersion = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            try {
                if ("id".equals(name)) {
                    id = value;
                } else if ("version".equals(name)) {
                    version = new Version(value);
                } else if ("pluginId".equals(name) && value.length() > 0) {
                    pluginId = value;
                } else if ("pluginVersion".equals(name) && value.length() > 0) {
                    pluginVersion = new Version(value);
                } else if ("primary".equals(name)) {
                    primary = Boolean.valueOf(value);
                } else if ("application".equals(name)) {
                    application = value;
                } else if ("patchedFeatureId".equals(name) && value.length() > 0) {
                    patchedFeatureId = value;
                } else if ("patchedFeatureVersion".equals(name) && value.length() > 0) {
                    patchedFeatureVersion = new Version(value);
                } else {
                    this.reporter.unexpectedAttribute("feature", name, value);
                }
            }
            catch (Exception iae) {
                this.reporter.invalidAttributeValue("feature", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("feature", "id", id);
        this.reporter.checkRequiredAttribute("feature", "version", (Object)(version != null ? version.toString() : null));
        EclipseFeatureData featureData = new EclipseFeatureData(id, version, pluginId, pluginVersion, primary, application, patchedFeatureId, patchedFeatureVersion);
        this.adapterData.addData(featureData);
    }

    private void parseAgentBundleAttributes(Attributes attributes) {
        String id = null;
        Version version = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            try {
                if ("id".equals(name)) {
                    id = value;
                } else if ("version".equals(name)) {
                    version = new Version(value);
                } else {
                    this.reporter.unexpectedAttribute("agentBundle", name, value);
                }
            }
            catch (Exception iae) {
                this.reporter.invalidAttributeValue("agentBundle", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("agentBundle", "id", id);
        this.reporter.checkRequiredAttribute("agentBundle", "version", (Object)(version != null ? version.toString() : null));
        EclipseAgentBundleData agentbundleData = new EclipseAgentBundleData(id, version);
        this.adapterData.addData(agentbundleData);
    }

    private void parseRestartAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            this.reporter.unexpectedAttribute("restart", name, value);
            ++i;
        }
        EclipseRestartData restartData = new EclipseRestartData();
        this.adapterData.addData(restartData);
    }

    private void parseSetVMAttributes(Attributes attributes) {
        String vmLocation = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if ("location".equals(name)) {
                vmLocation = value;
            } else {
                this.reporter.unexpectedAttribute("setvm", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("setvm", "location", vmLocation);
        EclipseSetVirtualMachineData vmData = new EclipseSetVirtualMachineData(vmLocation);
        this.adapterData.addData(vmData);
    }

    private void parseVMArgsAttributes(Attributes attributes) {
        String vmArgs = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if ("args".equals(name)) {
                vmArgs = value;
            } else {
                this.reporter.unexpectedAttribute("vmargs", name, value);
            }
            ++i;
        }
        EclipseAddVMArgumentsData vmData = new EclipseAddVMArgumentsData(vmArgs);
        this.adapterData.addData(vmData);
    }

    private void parseVMArgAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            this.reporter.unexpectedAttribute("arg", name, value);
            ++i;
        }
        EclipseVMArgumentData vmData = new EclipseVMArgumentData();
        IEclipseData data = this.adapterData.getLastData();
        if (data instanceof EclipseAddVMArgumentsData) {
            EclipseAddVMArgumentsData addVMArgsData = (EclipseAddVMArgumentsData)data;
            addVMArgsData.addArgument(vmData);
        } else if (data instanceof EclipseAddProgramArgumentsData) {
            EclipseAddProgramArgumentsData addCommandArgsData = (EclipseAddProgramArgumentsData)data;
            addCommandArgsData.addArgument(vmData);
        }
    }

    private void parseProgramArgsAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            this.reporter.unexpectedAttribute("programargs", name, value);
            ++i;
        }
        this.adapterData.addData(new EclipseAddProgramArgumentsData());
    }

    private void parsePropertyAttributes(Attributes attributes) {
        String propertyKey = null;
        String propertyValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if ("key".equals(name)) {
                propertyKey = value;
            } else if ("value".equals(name)) {
                propertyValue = value;
            } else {
                this.reporter.unexpectedAttribute("property", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("property", "key", propertyKey);
        this.reporter.checkRequiredAttribute("property", "value", propertyValue);
        EclipseSetPropertyData propertyData = new EclipseSetPropertyData(propertyKey, propertyValue);
        this.adapterData.addData(propertyData);
    }

    private void parseConfigPreferenceAttributes(Attributes attributes) {
        String preferenceNode = null;
        String preferenceKey = null;
        String preferenceValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if ("node".equals(name)) {
                preferenceNode = value;
            } else if ("key".equals(name)) {
                preferenceKey = value;
            } else if ("value".equals(name)) {
                preferenceValue = value;
            } else {
                this.reporter.unexpectedAttribute("preference", name, value);
            }
            ++i;
        }
        this.reporter.checkRequiredAttribute("preference", "node", preferenceNode);
        this.reporter.checkRequiredAttribute("preference", "key", preferenceKey);
        this.reporter.checkRequiredAttribute("preference", "value", preferenceValue);
        EclipseSetConfigPreferenceData preferenceData = new EclipseSetConfigPreferenceData(preferenceNode, preferenceKey, preferenceValue);
        this.adapterData.addData(preferenceData);
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.eclipseAdapterData");
        Path path = new Path("schema/eclipseAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }
}

