/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.eclipseAdapterData;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.AbstractArtifact;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.ArtifactTypeInfo;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IArtifactTypeKeyMapper;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactReferenceParseUtil;
import com.ibm.cic.common.core.model.adapterdata.impl.MapToLegacyKeyUtil;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.ContentInfoUtil;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.eclipseAdapterData.internal.IXMLConstants;
import com.ibm.cic.common.eclipseAdapterData.internal.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class EclipseArtifact
extends AbstractArtifact
implements IXMLConstants {
    public static final String KIND_FEATURE_NAME = "feature";
    public static final String KIND_PLUGIN_NAME = "plugin";
    private static final String KIND_ROOT_NAME = "root";
    private static final String QUALIFIER_FEATURE = "feature";
    private static final String QUALIFIER_PLUGIN = "plugin";
    private static final String QUALIFIER_ROOT = "root";
    private static final String[] TYPES = new String[]{"plugin", "feature"};
    public static final int NO_KIND = 0;
    public static final int KIND_ROOT = 1;
    public static final int KIND_PLUGIN = 2;
    public static final int KIND_FEATURE = 3;
    private int type = 0;
    private String rawKey;
    private IArtifactKey key;
    private ArtifactCommonAttributes aca;
    public static final IPath ECLIPSE_JAR_PATH = new Path(CicConstants.getJarFileDotExt());

    public static String getTypeName(int kind) {
        switch (kind) {
            case 1: {
                return "root";
            }
            case 2: {
                return "plugin";
            }
            case 3: {
                return "feature";
            }
        }
        return "unknown";
    }

    public EclipseArtifact(String rawKey) {
        this.rawKey = rawKey;
    }

    public EclipseArtifact(IInstallableUnit iu, IIdentity id, Version version, int kind, boolean exploded) {
        this(iu != null ? iu.getIdentity() : null, iu != null ? iu.getVersion() : null, id, version, kind, exploded);
    }

    public EclipseArtifact(IIdentity iuIdentity, Version iuVersion, IIdentity id, Version version, int kind, boolean exploded) {
        this.setExploded(exploded);
        this.key = new ArtifactKey(this.getPath(), "eclipse", EclipseArtifact.getTypeName(kind), id, version);
        this.type = kind;
    }

    public EclipseArtifact(ArtifactCommonAttributes aca, Boolean exploded, int type) {
        this.setType(type);
        if (type != 3) {
            if (exploded != null) {
                this.setExploded(exploded);
            }
        } else {
            this.setExploded(true);
        }
        this.key = new ArtifactKey(this.getPath(), "eclipse", aca.getType(), (IIdentity)new SimpleIdentity(aca.getId()), aca.getVersion());
        this.aca = aca;
    }

    public String toXML(boolean forInconsistentIuCheck) {
        if (this.aca != null) {
            return this.toNoKeyXML(forInconsistentIuCheck);
        }
        return this.toLegacyKeyXML(forInconsistentIuCheck);
    }

    private String toLegacyKeyXML(boolean forInconsistentIuCheck) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append("artifact");
        buffer.append(' ');
        buffer.append("key");
        buffer.append("='");
        buffer.append(this.getXMLKey());
        buffer.append("' ");
        buffer.append("type");
        buffer.append("='");
        buffer.append(this.getTypeName());
        buffer.append("' ");
        buffer.append("exploded");
        buffer.append("='");
        buffer.append(this.isExploded());
        buffer.append('\'');
        ContentInfoUtil.appendContentInfoXML((StringBuffer)buffer, (IContentInfo)this.getContentInfo(), (boolean)forInconsistentIuCheck);
        buffer.append("/>");
        return buffer.toString();
    }

    private String toNoKeyXML(boolean forInconsistentIuCheck) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append("artifact");
        buffer.append(' ');
        buffer.append("type");
        buffer.append("='");
        buffer.append(this.getTypeName());
        buffer.append("' ");
        buffer.append("id");
        buffer.append("='");
        buffer.append(this.aca.getId());
        buffer.append("' ");
        buffer.append("version");
        buffer.append("='");
        buffer.append(this.aca.getVersion());
        buffer.append("' ");
        buffer.append("exploded");
        buffer.append("='");
        buffer.append(this.isExploded());
        buffer.append('\'');
        ContentInfoUtil.appendContentInfoXML((StringBuffer)buffer, (IContentInfo)this.getContentInfo(), (boolean)forInconsistentIuCheck);
        buffer.append("/>");
        return buffer.toString();
    }

    private String getXMLKey() {
        if (this.rawKey != null) {
            return this.rawKey;
        }
        IPath path = this.key.getPath();
        if (EclipseArtifact.isRestrictedPath(path)) {
            MapToLegacyKeyUtil.ColonArtifactKeyInfo colonKey = new MapToLegacyKeyUtil.ColonArtifactKeyInfo();
            colonKey.setIdentity(this.key.getId().getId());
            colonKey.setVersion(this.key.getVersion().toString());
            colonKey.setQualns(this.key.getQualifier());
            return MapToLegacyKeyUtil.createKeyString((MapToLegacyKeyUtil.ColonArtifactKeyInfo)colonKey);
        }
        return path.toString();
    }

    public void initKey(IInstallableUnit iu) {
        this.key = this.createKey(iu);
    }

    public IArtifactKey getKey() {
        return this.key;
    }

    private IPath getPath() {
        if (UserOptions.maintainAtocCompatibility()) {
            return this.isExploded() ? Path.EMPTY : ECLIPSE_JAR_PATH;
        }
        return Path.EMPTY;
    }

    private static boolean isRestrictedPath(IPath path) {
        if (UserOptions.maintainAtocCompatibility()) {
            return path.isEmpty() || path.equals((Object)ECLIPSE_JAR_PATH);
        }
        return path.isEmpty();
    }

    private IArtifactKey createKey(IInstallableUnit iu) {
        MapToLegacyKeyUtil.ColonArtifactKeyInfo artifactColonKey = MapToLegacyKeyUtil.parseForColonArtifactKey((String)this.rawKey);
        if (artifactColonKey != null) {
            return new ArtifactKey(this.getPath(), "eclipse", artifactColonKey.getQualns(), (IIdentity)new SimpleIdentity(artifactColonKey.getIdentity()), new Version(artifactColonKey.getVersion()));
        }
        IPath path = MapToLegacyKeyUtil.parseForNonColonArtifactKey((String)this.rawKey);
        return new ArtifactKey(path, "eclipse", EclipseArtifact.getTypeName(this.type), iu.getIdentity(), iu.getVersion());
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return EclipseArtifact.getTypeName(this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public static String toUserString(IArtifactKey key, int options) {
        String qualifier = key.getQualifier();
        IPath path = key.getPath();
        String localizedQualifier = "plugin".equals(qualifier) ? Messages.EclipseData_artifact_qualifier_plugin : ("feature".equals(qualifier) ? Messages.EclipseData_artifact_qualifier_feature : ("root".equals(qualifier) ? Messages.EclipseData_artifact_qualifier_root : qualifier));
        if (EclipseArtifact.isRestrictedPath(path)) {
            if (options == 2) {
                return NLS.bind((String)Messages.EclipseData_artifact_user_string_id_only, (Object[])new Object[]{localizedQualifier, key.getId()});
            }
            assert (options == 1);
            return NLS.bind((String)Messages.EclipseData_artifact_user_string, (Object[])new Object[]{localizedQualifier, key.getId(), key.getVersion()});
        }
        return NLS.bind((String)Messages.EclipseData_artifact_user_string_path, (Object)localizedQualifier, (Object)path);
    }

    public String toUserString() {
        return EclipseArtifact.toUserString(this.key, 1);
    }

    public static IPath toNamespaceUniquePath(IArtifactKey k) {
        String id = k.getId().getId();
        String version = k.getVersion().toString();
        String qualifier = k.getQualifier();
        String ext = CicConstants.getJarFileDotExt();
        String dir = qualifier.equals("plugin") ? "plugins" : (qualifier.equals("feature") ? "features" : qualifier);
        return new Path(String.valueOf(dir) + '/' + id + '_' + version + ext);
    }

    public static IArtifactKey toNamespaceArtifactKey(IPath relPath) {
        if (relPath.segmentCount() == 2) {
            String name = relPath.lastSegment();
            if (!PathUtil.hasExtension((String)name, (String)"jar", (boolean)true)) {
                return null;
            }
            String dir = relPath.segment(0);
            String qualifier = "plugins".equals(dir) ? "plugin" : ("features".equals(dir) ? "feature" : dir);
            Path path = Path.EMPTY;
            String nameWithoutExtension = relPath.removeFileExtension().lastSegment();
            Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)nameWithoutExtension);
            String id = (String)idAndVersion[0];
            Version version = (Version)idAndVersion[1];
            if (version == null) {
                return null;
            }
            return new ArtifactKey((IPath)path, "eclipse", qualifier, (IIdentity)new SimpleIdentity(id), version);
        }
        return null;
    }

    public static ArtifactTypeInfo toArtifactTypeInfo(String type) {
        if ("plugin".equals(type)) {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setType(type);
            ati.setKeyNamespace("eclipse");
            ati.setKeyQualifier("plugin");
            return ati;
        }
        if ("feature".equals(type)) {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setType(type);
            ati.setKeyNamespace("eclipse");
            ati.setKeyQualifier("feature");
            return ati;
        }
        return null;
    }

    public static String[] getSupportedArtifactTypes() {
        return TYPES;
    }

    public static IArtifactTypeKeyMapper getReferenceParser(String type) {
        ArtifactTypeInfo ati = EclipseArtifact.toArtifactTypeInfo(type);
        if (ati != null) {
            ArtifactReferenceParseUtil.BaseArtifactsTypeKeyMapper refParser = new ArtifactReferenceParseUtil.BaseArtifactsTypeKeyMapper(ati);
            return refParser;
        }
        return null;
    }
}

