/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.utils;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class WindowUtils {
    private static final String JUNIT_APPS1 = "org.eclipse.pde.junit.runtime.";
    private static final String JUNIT_APPS2 = "org.eclipse.test.";

    private WindowUtils() {
    }

    public static Shell calculateShell() {
        IWorkbenchWindow window;
        if (CicCommonSettings.isZOS()) {
            return null;
        }
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    public static boolean runningUI() {
        if (CicCommonSettings.isZOS()) {
            return false;
        }
        return PlatformUI.isWorkbenchRunning() && !WindowUtils.isJUnitApp();
    }

    public static boolean isJUnitApp() {
        BundleContext context = CicCommonUiPlugin.getBundleContext();
        if (context == null) {
            return false;
        }
        String app = context.getProperty("eclipse.application");
        if (app == null) {
            return false;
        }
        if (app.startsWith(JUNIT_APPS1)) {
            return true;
        }
        return app.startsWith(JUNIT_APPS2);
    }
}

