/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.viewers;

import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.AddRepositoryDialog;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RepositoryTable
implements ISelectionProvider {
    private final Logger logger = Logger.getLogger(RepositoryTable.class);
    private CheckboxTableViewer repositoriesViewer;
    private Button bUp;
    private Button bDown;
    private Button bRemove;
    private Button bEdit;
    private Button bAdd;
    private Button bCredentials;
    private Button bTestConnection;
    private CommonUILabelProvider commonUILabelProvider;
    private final RepositoryLocationsContentProvider repositoriesContentProvider = new RepositoryLocationsContentProvider();
    protected final List repLocations;
    private final List importEnabledRepLocations = new ArrayList();
    protected final Map locationProperties;
    protected Map repStatus = new HashMap();
    protected Map repOpen = new HashMap();
    private String repositoryLocation;
    private final List propertyChangeListeners = new ArrayList();
    private final List selectionChangeListeners = new ArrayList();
    public static final String ADD_REP = "AddRepository";
    public static final String REMOVE_REP = "RemoveRepository";
    public static final String OPEN_STATUS = "OpenOrCloseRepository";
    public static final String CHANGE_SPECIAL_SETTINGS = "ChangeSpecialSettings";
    public static final String MOVE_UP = "MoveUp";
    public static final String MOVE_DOWN = "MoveDown";
    private Table repsTable;
    private static final int DEFAULT_COL1_WIDTH_FORM = 200;
    private static final int DEFAULT_COL1_WIDTH = 400;
    private static final int DEFAULT_COL2_WIDTH = 80;
    private int col1_width = 0;
    private int col2_width = 0;
    public static final String REP_CONNECTION_STATUS_UNKNOW = "UNKNOWN";

    private RepositoryTable(List locations, Map locProperties, Map locOpen, Map locStatus) {
        this.repLocations = locations;
        this.locationProperties = locProperties;
        this.repOpen = locOpen;
        this.repStatus = locStatus;
    }

    public RepositoryTable(List locations, Map locProperties, Map locOpen, Map locStatus, int col1_width, int col2_width) {
        this(locations, locProperties, locOpen, locStatus);
        this.col1_width = col1_width;
        this.col2_width = col2_width;
    }

    public Composite createControl(Composite ancestor, boolean formTable, FormToolkit toolkit, int hSpan) {
        return this.createControl(ancestor, formTable, true, toolkit, hSpan);
    }

    public Composite createControl(Composite ancestor, boolean formTable, boolean displayRepLabel, FormToolkit toolkit, int hSpan) {
        Composite parent = null;
        parent = formTable ? toolkit.createComposite(ancestor, 0) : new Composite(ancestor, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginWidth = 5;
        glayout.marginHeight = 5;
        glayout.numColumns = 2;
        parent.setLayout((Layout)glayout);
        GridData data = new GridData(1808);
        data.horizontalSpan = hSpan;
        parent.setLayoutData((Object)data);
        this.commonUILabelProvider = CicCommonUiPlugin.getDefault().getLabelProvider();
        this.commonUILabelProvider.connect(this);
        if (displayRepLabel) {
            Label prefValueDescr = null;
            if (formTable) {
                prefValueDescr = toolkit.createLabel(parent, Messages.AgentProperties_RepositoriesPrefs_repositories);
            } else {
                prefValueDescr = new Label(parent, 0);
                prefValueDescr.setText(Messages.AgentProperties_RepositoriesPrefs_repositories);
            }
            data = new GridData();
            data.horizontalSpan = 2;
            prefValueDescr.setLayoutData((Object)data);
        }
        int style = 66338;
        this.repsTable = formTable ? toolkit.createTable(parent, toolkit.getBorderStyle() | style) : new Table(parent, 0x800 | style);
        data = new GridData(1808);
        if (!formTable) {
            int itemHeight = this.repsTable.getItemHeight() * 10;
            Rectangle rec = this.repsTable.computeTrim(0, 0, 0, itemHeight);
            data.heightHint = rec.height;
        }
        this.repsTable.setLayoutData((Object)data);
        if (formTable) {
            UiServices.getInstance().paintBordersFor(toolkit, parent);
        }
        this.repsTable.setHeaderVisible(true);
        this.repsTable.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.repsTable, 16384);
        col1.setText(Messages.AgentProperties_RepositoriesPrefs_locationCol);
        if (this.col1_width == 0) {
            col1.setWidth(formTable ? 200 : 400);
        } else {
            col1.setWidth(this.col1_width);
        }
        TableColumn col2 = new TableColumn(this.repsTable, 16384);
        col2.setText(Messages.AgentProperties_RepositoriesPrefs_statusCol);
        if (this.col2_width == 0) {
            col2.setWidth(80);
        } else {
            col2.setWidth(this.col2_width);
        }
        this.repositoriesViewer = new CheckboxTableViewer(this.repsTable);
        this.repositoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selected = (IStructuredSelection)event.getSelection();
                RepositoryTable.this.repositoryLocation = (String)selected.getFirstElement();
                RepositoryTable.this.notifySelectionChangedEvent(event);
                RepositoryTable.this.updateUpDownEditRemoveTestButton();
            }
        });
        this.repositoriesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RepositoryTable.this.repositoryLocation = (String)event.getElement();
                RepositoryTable.this.repOpen.put(RepositoryTable.this.repositoryLocation, event.getChecked());
                if (event.getChecked()) {
                    IStatus status = RepositoryTable.this.checkSelectedRepositoryStatus(true, RepositoryTable.this.repositoryLocation);
                    RepositoryTable.this.updateRepositoryTableViewer();
                    if (status.isOK() && status.getPlugin().equals(CicCommonUiPlugin.getPluginId()) && status.getCode() == 1) {
                        MessageDialog.openInformation((Shell)RepositoryTable.this.repositoriesViewer.getControl().getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)status.getMessage());
                    } else if (status.getSeverity() == 2) {
                        MessageDialog.openWarning((Shell)RepositoryTable.this.repositoriesViewer.getControl().getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepWarning, (String)status.getMessage());
                    } else if (status.getSeverity() == 4) {
                        WrapDetailUIDErrorDialog.openError(RepositoryTable.this.repositoriesViewer.getControl().getShell(), com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, null, status);
                    } else if (status.getSeverity() == 1 && status.getMessage().length() > 0) {
                        MessageDialog.openInformation((Shell)RepositoryTable.this.repositoriesViewer.getControl().getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)status.getMessage());
                    }
                }
                CheckboxTableViewer viewer = (CheckboxTableViewer)event.getSource();
                viewer.update((Object)RepositoryTable.this.repositoryLocation, null);
                PropertyChangeEvent propertyChangeEvt = new PropertyChangeEvent((Object)this, RepositoryTable.OPEN_STATUS, null, null);
                RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt);
                RepositoryTable.this.updateTestConnectionButton();
                RepositoryTable.this.updateClearCredentialButton();
                viewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
            }
        });
        this.repositoriesViewer.setContentProvider((IContentProvider)this.repositoriesContentProvider);
        this.repositoriesViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTableLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.repositoriesViewer.setInput((Object)this.repLocations);
        Object[] openReps = this.getOpenRepositories(this.repOpen);
        this.repositoriesViewer.setCheckedElements(openReps);
        Composite buttonComp = null;
        buttonComp = formTable ? toolkit.createComposite(parent) : new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComp.setLayoutData((Object)data);
        if (formTable) {
            this.bAdd = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_add, 8);
        } else {
            this.bAdd = new Button(buttonComp, 0);
            this.bAdd.setText(Messages.AgentProperties_RepositoriesPrefs_button_add);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.bAdd.setLayoutData((Object)data);
        final Shell finalShell = this.repositoriesViewer.getTable().getShell();
        final RepositoryTable finalThis = this;
        this.bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> repositoryLocations = new HashSet<String>();
                for (Object element : RepositoryGroup.getDefault()) {
                    String name = ((IRepository)element).getLocationStr();
                    repositoryLocations.add(name);
                }
                HashSet currentRepositoryLocations = new HashSet(RepositoryTable.this.repLocations);
                repositoryLocations.removeAll(currentRepositoryLocations);
                ArrayList repAlreadyInList = new ArrayList();
                Iterator it = currentRepositoryLocations.iterator();
                while (it.hasNext()) {
                    repAlreadyInList.add(it.next());
                }
                boolean originalHelpAvailableValue = TrayDialog.isDialogHelpAvailable();
                TrayDialog.setDialogHelpAvailable((boolean)false);
                AddRepositoryDialog dlg = new AddRepositoryDialog(finalShell, repositoryLocations, repAlreadyInList, null, null, false);
                if (dlg.open() == 0) {
                    RepositoryTable.this.repositoryLocation = dlg.getLocation();
                    String settings = dlg.getSpecialSettings();
                    boolean isRepOk = dlg.getIfRepositoryIsOk();
                    if (isRepOk) {
                        RepositoryTable.this.checkImportEnabledRepository(RepositoryTable.this.repositoryLocation);
                    }
                    RepositoryTable.this.repStatus.put(RepositoryTable.this.repositoryLocation, Boolean.valueOf(isRepOk).toString());
                    List properties = RepositoryTable.this.loadSettings(settings);
                    RepositoryTable.this.repLocations.add(RepositoryTable.this.repositoryLocation);
                    RepositoryTable.this.locationProperties.put(RepositoryTable.this.repositoryLocation, properties);
                    RepositoryTable.this.repOpen.put(RepositoryTable.this.repositoryLocation, Boolean.TRUE);
                    RepositoryTable.this.repositoriesViewer.add((Object)RepositoryTable.this.repositoryLocation);
                    RepositoryTable.this.repositoriesViewer.setChecked((Object)RepositoryTable.this.repositoryLocation, true);
                    RepositoryTable.this.repositoriesViewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryTable.this.repositoryLocation));
                    PropertyChangeEvent propertyChangeEvt1 = new PropertyChangeEvent((Object)this, RepositoryTable.ADD_REP, null, null);
                    RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt1);
                    PropertyChangeEvent propertyChangeEvt2 = new PropertyChangeEvent((Object)this, RepositoryTable.OPEN_STATUS, null, null);
                    RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt2);
                    PropertyChangeEvent propertyChangeEvt3 = new PropertyChangeEvent((Object)this, RepositoryTable.CHANGE_SPECIAL_SETTINGS, null, null);
                    RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt3);
                    StructuredSelection selection = new StructuredSelection(new Object[0]);
                    SelectionChangedEvent selectionChangedEvt = new SelectionChangedEvent((ISelectionProvider)finalThis, (ISelection)selection);
                    RepositoryTable.this.notifySelectionChangedEvent(selectionChangedEvt);
                    RepositoryTable.this.updateUpDownEditRemoveTestButton();
                    RepositoryTable.this.updateClearCredentialButton();
                }
                TrayDialog.setDialogHelpAvailable((boolean)originalHelpAvailableValue);
            }
        });
        if (!formTable) {
            this.bEdit = new Button(buttonComp, 0);
            this.bEdit.setText(Messages.AgentProperties_RepositoriesPrefs_button_edit);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            this.bEdit.setLayoutData((Object)data);
            this.bEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = RepositoryTable.this.repositoriesViewer.getTable().getSelectionIndex();
                    TableItem item = RepositoryTable.this.repositoriesViewer.getTable().getItem(index);
                    if (item != null) {
                        RepositoryTable.this.repositoryLocation = (String)item.getData();
                        if (RepositoryTable.this.repositoryLocation != null && RepositoryTable.this.repositoryLocation.length() > 0) {
                            HashSet<String> repositoryLocations = new HashSet<String>();
                            for (Object element : RepositoryGroup.getDefault()) {
                                String name = ((IRepository)element).getLocationStr();
                                repositoryLocations.add(name);
                            }
                            HashSet currentRepositoryLocations = new HashSet(RepositoryTable.this.repLocations);
                            repositoryLocations.removeAll(currentRepositoryLocations);
                            ArrayList repAlreadyInList = new ArrayList();
                            Iterator it = currentRepositoryLocations.iterator();
                            while (it.hasNext()) {
                                repAlreadyInList.add(it.next());
                            }
                            List initProperties = (List)RepositoryTable.this.locationProperties.get(RepositoryTable.this.repositoryLocation);
                            boolean originalHelpAvailableValue = TrayDialog.isDialogHelpAvailable();
                            TrayDialog.setDialogHelpAvailable((boolean)false);
                            AddRepositoryDialog dlg = new AddRepositoryDialog(finalShell, repositoryLocations, repAlreadyInList, RepositoryTable.this.repositoryLocation, initProperties, true);
                            if (dlg.open() == 0) {
                                String newRepositoryLocation = dlg.getLocation();
                                String settings = dlg.getSpecialSettings();
                                boolean isRepOk = dlg.getIfRepositoryIsOk();
                                if (isRepOk) {
                                    RepositoryTable.this.checkImportEnabledRepository(newRepositoryLocation);
                                }
                                RepositoryTable.this.repStatus.remove(RepositoryTable.this.repositoryLocation);
                                RepositoryTable.this.repStatus.put(newRepositoryLocation, Boolean.valueOf(isRepOk).toString());
                                List properties = RepositoryTable.this.loadSettings(settings);
                                RepositoryTable.this.locationProperties.remove(RepositoryTable.this.repositoryLocation);
                                RepositoryTable.this.locationProperties.put(newRepositoryLocation, properties);
                                RepositoryTable.this.repOpen.remove(RepositoryTable.this.repositoryLocation);
                                RepositoryTable.this.repOpen.put(newRepositoryLocation, Boolean.TRUE);
                                int repIndex = RepositoryTable.this.repLocations.indexOf(RepositoryTable.this.repositoryLocation);
                                if (repIndex != -1) {
                                    RepositoryTable.this.repLocations.remove(index);
                                    RepositoryTable.this.repLocations.add(index, newRepositoryLocation);
                                }
                                RepositoryTable.this.repositoriesViewer.getTable().remove(index);
                                RepositoryTable.this.repositoriesViewer.insert((Object)newRepositoryLocation, index);
                                RepositoryTable.this.repositoriesViewer.setChecked((Object)newRepositoryLocation, true);
                                RepositoryTable.this.repositoriesViewer.setSelection((ISelection)new StructuredSelection((Object)newRepositoryLocation));
                                RepositoryTable.this.repositoryLocation = newRepositoryLocation;
                                RepositoryTable.this.updateUpDownEditRemoveTestButton();
                            }
                            TrayDialog.setDialogHelpAvailable((boolean)originalHelpAvailableValue);
                        }
                    }
                }
            });
        }
        if (formTable) {
            this.bRemove = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_remove, 8);
        } else {
            this.bRemove = new Button(buttonComp, 0);
            this.bRemove.setText(Messages.AgentProperties_RepositoriesPrefs_button_remove);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        this.bRemove.setLayoutData((Object)data);
        this.bRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table repTable = RepositoryTable.this.repositoriesViewer.getTable();
                int[] selectionIndice = repTable.getSelectionIndices();
                if (selectionIndice.length > 0) {
                    int maxSelectionIndex = -1;
                    ArrayList<String> repToBeRemoved = new ArrayList<String>();
                    int[] nArray = selectionIndice;
                    int n = selectionIndice.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int element = nArray[n2];
                        RepositoryTable.this.repositoryLocation = (String)repTable.getItem(element).getData();
                        if (RepositoryTable.this.repositoryLocation != null && RepositoryTable.this.repositoryLocation.length() > 0) {
                            RepositoryTable.this.repLocations.remove(RepositoryTable.this.repositoryLocation);
                            RepositoryTable.this.locationProperties.remove(RepositoryTable.this.repositoryLocation);
                            RepositoryTable.this.repOpen.remove(RepositoryTable.this.repositoryLocation);
                            RepositoryTable.this.repStatus.remove(RepositoryTable.this.repositoryLocation);
                            PropertyChangeEvent propertyChangeEvt = new PropertyChangeEvent((Object)this, RepositoryTable.REMOVE_REP, null, null);
                            RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt);
                            repToBeRemoved.add(RepositoryTable.this.repositoryLocation);
                        }
                        if (element > maxSelectionIndex) {
                            maxSelectionIndex = element;
                        }
                        ++n2;
                    }
                    TableItem nextItemToSelect = null;
                    if (repTable.getItemCount() - 1 > maxSelectionIndex) {
                        nextItemToSelect = repTable.getItem(maxSelectionIndex + 1);
                    }
                    if (!repToBeRemoved.isEmpty()) {
                        RepositoryTable.this.repositoriesViewer.remove(repToBeRemoved.toArray());
                    }
                    if (nextItemToSelect != null) {
                        repTable.setSelection(nextItemToSelect);
                    } else if (repTable.getItemCount() > 0) {
                        repTable.setSelection(repTable.getItemCount() - 1);
                    }
                    RepositoryTable.this.updateUpDownEditRemoveTestButton();
                    RepositoryTable.this.updateClearCredentialButton();
                    TableItem[] selectedItems = RepositoryTable.this.repositoriesViewer.getTable().getSelection();
                    if (selectedItems == null || selectedItems.length == 0) {
                        RepositoryTable.this.repositoryLocation = null;
                    } else {
                        RepositoryTable.this.repositoryLocation = (String)selectedItems[0].getData();
                    }
                    StructuredSelection selection = new StructuredSelection(new Object[0]);
                    SelectionChangedEvent selectionChangedEvt = new SelectionChangedEvent((ISelectionProvider)finalThis, (ISelection)selection);
                    RepositoryTable.this.notifySelectionChangedEvent(selectionChangedEvt);
                }
            }
        });
        if (formTable) {
            this.bUp = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_up, 8);
        } else {
            this.bUp = new Button(buttonComp, 0);
            this.bUp.setText(Messages.AgentProperties_RepositoriesPrefs_button_up);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        this.bUp.setLayoutData((Object)data);
        this.bUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = RepositoryTable.this.repositoriesViewer.getTable();
                int index = table.getSelectionIndex();
                if (index < 0 || index >= table.getItemCount()) {
                    return;
                }
                RepositoryTable.this.repositoryLocation = (String)table.getItem(index).getData();
                if (RepositoryTable.this.repositoryLocation != null) {
                    PropertyChangeEvent propertyChangeEvt = new PropertyChangeEvent((Object)this, RepositoryTable.MOVE_UP, null, null);
                    RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt);
                    if (index != 0) {
                        RepositoryTable.this.repLocations.remove(index);
                        RepositoryTable.this.repLocations.add(index - 1, RepositoryTable.this.repositoryLocation);
                        RepositoryTable.this.repositoriesViewer.insert((Object)RepositoryTable.this.repositoryLocation, index - 1);
                        RepositoryTable.this.repositoriesViewer.setChecked((Object)RepositoryTable.this.repositoryLocation, ((Boolean)RepositoryTable.this.repOpen.get(RepositoryTable.this.repositoryLocation)).booleanValue());
                        table.remove(index + 1);
                        table.select(index - 1);
                    }
                    RepositoryTable.this.updateUpDownEditRemoveButton();
                }
            }
        });
        if (formTable) {
            this.bDown = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_down, 8);
        } else {
            this.bDown = new Button(buttonComp, 0);
            this.bDown.setText(Messages.AgentProperties_RepositoriesPrefs_button_down);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        this.bDown.setLayoutData((Object)data);
        this.bDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table = RepositoryTable.this.repositoriesViewer.getTable();
                int index = table.getSelectionIndex();
                if (index < 0 || index >= table.getItemCount()) {
                    return;
                }
                RepositoryTable.this.repositoryLocation = (String)table.getItem(index).getData();
                if (RepositoryTable.this.repositoryLocation != null) {
                    PropertyChangeEvent propertyChangeEvt = new PropertyChangeEvent((Object)this, RepositoryTable.MOVE_DOWN, null, null);
                    RepositoryTable.this.notifyPropertyChangeEvent(propertyChangeEvt);
                    if (index != table.getItemCount() - 1) {
                        RepositoryTable.this.repLocations.remove(index);
                        RepositoryTable.this.repLocations.add(index + 1, RepositoryTable.this.repositoryLocation);
                        RepositoryTable.this.repLocations.add(index + 2, RepositoryTable.this.repositoryLocation);
                        RepositoryTable.this.repLocations.remove(index + 1);
                        RepositoryTable.this.repositoriesViewer.insert((Object)RepositoryTable.this.repositoryLocation, index + 2);
                        table.remove(index);
                        RepositoryTable.this.repositoriesViewer.setChecked((Object)RepositoryTable.this.repositoryLocation, ((Boolean)RepositoryTable.this.repOpen.get(RepositoryTable.this.repositoryLocation)).booleanValue());
                        table.select(index + 1);
                    }
                    RepositoryTable.this.updateUpDownEditRemoveButton();
                }
            }
        });
        if (formTable) {
            this.bCredentials = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_credentials, 8);
        } else {
            this.bCredentials = new Button(buttonComp, 8);
            this.bCredentials.setText(Messages.AgentProperties_RepositoriesPrefs_button_credentials);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        this.bCredentials.setLayoutData((Object)data);
        this.bCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean answer = MessageDialog.openConfirm((Shell)RepositoryTable.this.bCredentials.getShell(), (String)Messages.ClearCredentialDlgTitle, (String)com.ibm.cic.common.core.sharedUI.Messages.ClearCredentialDlgMsg);
                if (answer) {
                    CredentialStore.INSTANCE.removeAllCredentials();
                }
                RepositoryTable.this.bCredentials.setEnabled(CredentialStore.INSTANCE.isAnyCredentialSaved());
            }
        });
        if (formTable) {
            this.bTestConnection = toolkit.createButton(buttonComp, Messages.AgentProperties_RepositoriesPrefs_button_checkStatus, 8);
        } else {
            this.bTestConnection = new Button(buttonComp, 0);
            this.bTestConnection.setText(Messages.AgentProperties_RepositoriesPrefs_button_checkStatus);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        this.bTestConnection.setLayoutData((Object)data);
        this.bTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStatus status = RepositoryTable.this.testAllRepositoryStatus(true);
                if (status.matches(8)) {
                    return;
                }
                if (!status.isOK()) {
                    WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(RepositoryTable.this.bTestConnection.getShell(), Messages.TestConnectionResultDlg_title, null, status, 15);
                    errorDialog.open();
                } else {
                    String displayMsg = status.getMessage();
                    if (displayMsg == null || displayMsg.length() == 0) {
                        displayMsg = Messages.TestConnectionResultDlg_connected;
                    }
                    MessageDialog.openInformation((Shell)RepositoryTable.this.bTestConnection.getShell(), (String)Messages.TestConnectionResultDlg_title, (String)displayMsg);
                }
            }
        });
        this.updateUpDownEditRemoveTestButton();
        this.updateClearCredentialButton();
        return parent;
    }

    private void checkImportEnabledRepository(IRepository repository, String repLoc, IProgressMonitor monitor) {
        if (CicPreferenceManager.getInstance().isSet(ICicPreferenceConstants.IMPORT_ENABLED.key())) {
            return;
        }
        List offerings = UpdateOfferingUtils.getAllOfferingsUpdatesAndFixes((IRepository)repository, (IProgressMonitor)monitor);
        int i = 0;
        while (i < offerings.size()) {
            IOfferingOrFix offeringOrFix = (IOfferingOrFix)offerings.get(i);
            if (OfferingProperty.isImportEnabled((IOfferingOrFix)offeringOrFix)) {
                if (!this.importEnabledRepLocations.contains(repLoc)) {
                    this.importEnabledRepLocations.add(repLoc);
                }
                return;
            }
            ++i;
        }
    }

    private void checkImportEnabledRepository(final String repLoc) {
        if (CicPreferenceManager.getInstance().isSet(ICicPreferenceConstants.IMPORT_ENABLED.key())) {
            return;
        }
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    RepositoryGroup temRepGroup = new RepositoryGroup("checkImportEnabled");
                    IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)temRepGroup, (String)repLoc, null, null, (String)repLoc, (String)"");
                    IRepository rep = RepositoryUtils.addExistingRepository((IRepositoryGroup)temRepGroup, (IRepositoryInfo)repInfo, (boolean)true);
                    if (rep != null) {
                        RepositoryTable.this.checkImportEnabledRepository(rep, repLoc, monitor);
                    }
                    temRepGroup.removeAllRepositories();
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private IStatus testAllRepositoryStatus(final boolean resetCachedFiles) {
        final IStatus[] status = new IStatus[1];
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    status[0] = Statuses.ST.createMultiStatus();
                    CheckRepositoriesTask task = RepositoryTable.this.createCheckRepositoryTask();
                    if (!task.isTaskEmpty()) {
                        status[0] = task.checkAccessibility(resetCachedFiles, true, monitor);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        this.updateRepositoryTableViewer();
        if (status[0] != null) {
            return status[0];
        }
        return Statuses.ST.createMultiStatus();
    }

    public IRepositoryInfo constructRepInfo(String repLocation) {
        List properties = (List)this.locationProperties.get(repLocation);
        String specialSettings = "";
        String repType = "";
        if (properties != null) {
            for (Map map : properties) {
                Map.Entry entry = map.entrySet().iterator().next();
                String name = (String)entry.getKey();
                if (!name.equals("Type")) continue;
                repType = (String)entry.getValue();
                break;
            }
            specialSettings = this.constructSettings(properties);
        }
        String defaultVersion = this.getDefaultVersionForType(repType);
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)RepositoryGroup.getDefault(), (String)repLocation, null, (String)defaultVersion, (String)repLocation, (String)specialSettings);
        return repInfo;
    }

    private IStatus checkRepositoryStatus(String repLocation, boolean resetCachedFiles, Map repMsgMap, SubProgressMonitor monitor) {
        String msg = NLS.bind((String)Messages.ProgressDialog_Check_Repository, (Object)repLocation);
        try {
            monitor.beginTask(msg, 1);
            monitor.setTaskName(msg);
            IRepositoryInfo repInfo = this.constructRepInfo(repLocation);
            RepositoryGroup repGroup = RepositoryGroup.getDefault();
            if (resetCachedFiles) {
                repGroup.getFileCacheManager().resetPathTree(repInfo.getLocation());
            }
            IStatus return_status = RepositoryUtils.addRepositoryOrRefreshStatus((IRepositoryInfo)repInfo, (IProgressMonitor)monitor);
            CommonSharedUIUtils.generateRepositoryStatusList((IRepositoryInfo)repInfo, (Map)repMsgMap);
            IRepository rep = repGroup.findRepository(repInfo);
            if (rep != null) {
                this.checkImportEnabledRepository(rep, repLocation, (IProgressMonitor)monitor);
            }
            IStatus iStatus = return_status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private String getDefaultVersionForType(String type) {
        RepositoryDescriptor[] des;
        String defaultVersion = null;
        if (type == null || type.length() == 0) {
            return defaultVersion;
        }
        RepositoryDescriptor[] repositoryDescriptorArray = des = RepositoryGroup.getDefault().getRepositoryDescriptors();
        int n = des.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryDescriptor de = repositoryDescriptorArray[n2];
            String defaultType = de.getType();
            if (defaultType.equals(type)) {
                defaultVersion = de.getVersion();
            }
            ++n2;
        }
        return defaultVersion;
    }

    public Object[] getOpenRepositories(Map repOpenMap) {
        ArrayList openReps = new ArrayList();
        for (Map.Entry entry : repOpenMap.entrySet()) {
            Boolean isOpen = (Boolean)entry.getValue();
            if (isOpen == null || !isOpen.booleanValue()) continue;
            openReps.add(entry.getKey());
        }
        return openReps.toArray();
    }

    private void updateUpDownEditRemoveTestButton() {
        this.updateUpDownEditRemoveButton();
        this.updateTestConnectionButton();
    }

    private void updateUpDownEditRemoveButton() {
        if (this.repositoriesViewer == null || this.repositoriesViewer.getTable() == null) {
            return;
        }
        Table repTable = this.repositoriesViewer.getTable();
        int selectionCount = repTable.getSelectionCount();
        if (selectionCount > 1) {
            this.bUp.setEnabled(false);
            this.bDown.setEnabled(false);
            this.bRemove.setEnabled(true);
            if (this.bEdit != null) {
                this.bEdit.setEnabled(false);
            }
        } else {
            int selectionIndex = repTable.getSelectionIndex();
            if (selectionIndex == -1) {
                this.bRemove.setEnabled(false);
                if (this.bEdit != null) {
                    this.bEdit.setEnabled(false);
                }
            } else {
                this.bRemove.setEnabled(true);
                if (this.bEdit != null) {
                    this.bEdit.setEnabled(true);
                }
            }
            if (selectionIndex > 0 && selectionIndex < repTable.getItemCount()) {
                this.bUp.setEnabled(true);
            } else {
                this.bUp.setEnabled(false);
            }
            if (selectionIndex >= 0 && selectionIndex < repTable.getItemCount() - 1) {
                this.bDown.setEnabled(true);
            } else {
                this.bDown.setEnabled(false);
            }
        }
    }

    private void updateTestConnectionButton() {
        if (this.repositoriesViewer == null || this.repositoriesViewer.getTable() == null) {
            return;
        }
        Table repTable = this.repositoriesViewer.getTable();
        int itemCount = repTable.getItemCount();
        int i = 0;
        while (i < itemCount) {
            TableItem item = repTable.getItem(i);
            if (item.getChecked()) {
                this.bTestConnection.setEnabled(true);
                return;
            }
            ++i;
        }
        this.bTestConnection.setEnabled(false);
    }

    public void updateClearCredentialButton() {
        if (this.repositoriesViewer == null || this.repositoriesViewer.getTable() == null) {
            return;
        }
        this.bCredentials.setEnabled(CredentialStore.INSTANCE.isAnyCredentialSaved());
    }

    public String getCurrentRepositoryLocation() {
        return this.repositoryLocation;
    }

    public void dispose() {
        this.commonUILabelProvider.disconnect(this);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void notifyPropertyChangeEvent(PropertyChangeEvent event) {
        Iterator it = this.propertyChangeListeners.iterator();
        while (it.hasNext()) {
            ((IPropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    public void notifySelectionChangedEvent(SelectionChangedEvent event) {
        Iterator it = this.selectionChangeListeners.iterator();
        while (it.hasNext()) {
            ((ISelectionChangedListener)it.next()).selectionChanged(event);
        }
    }

    public List loadSettings(String settings) {
        String repositoryType = "";
        ArrayList return_value = new ArrayList();
        StringTokenizer propertyTokenizer = new StringTokenizer(settings, ",");
        while (propertyTokenizer.hasMoreTokens()) {
            String propertyToken = propertyTokenizer.nextToken();
            HashMap<String, String> nameValueMap = new HashMap<String, String>();
            int index = propertyToken.indexOf("=");
            if (index != -1) {
                String name = propertyToken.substring(0, index);
                String value = propertyToken.substring(index + 1);
                nameValueMap.put(name, value);
                if (name.equals("Type")) {
                    repositoryType = value;
                }
            } else {
                nameValueMap.put(propertyToken, "");
            }
            return_value.add(nameValueMap);
        }
        Set defaultPropertyNames = this.getDefaultPropertyNames(repositoryType);
        for (String defaultName : defaultPropertyNames) {
            boolean found = false;
            int i = 0;
            while (i < return_value.size()) {
                Map nameValueMap = (Map)return_value.get(i);
                if (nameValueMap.keySet().contains(defaultName)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            HashMap<String, String> nameValueMap = new HashMap<String, String>();
            nameValueMap.put(defaultName, "");
            return_value.add(nameValueMap);
        }
        return return_value;
    }

    private Set getDefaultPropertyNames(String repType) {
        RepositoryDescriptor[] des;
        HashSet<String> defaultNames = new HashSet<String>();
        RepositoryDescriptor[] repositoryDescriptorArray = des = RepositoryGroup.getDefault().getRepositoryDescriptors();
        int n = des.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryDescriptor de = repositoryDescriptorArray[n2];
            String type = de.getType();
            if (repType.equals(type)) {
                RepositoryDescriptor.RepositoryParameter[] pars;
                RepositoryDescriptor.RepositoryParameter[] repositoryParameterArray = pars = de.getRepositoryParameters();
                int n3 = pars.length;
                int n4 = 0;
                while (n4 < n3) {
                    RepositoryDescriptor.RepositoryParameter par = repositoryParameterArray[n4];
                    String name = par.tag.label();
                    defaultNames.add(name);
                    ++n4;
                }
                return defaultNames;
            }
            ++n2;
        }
        return defaultNames;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public String constructSettings(List nameValueMaps) {
        StringBuffer settings = new StringBuffer();
        if (nameValueMaps != null && !nameValueMaps.isEmpty()) {
            int i = 0;
            while (i < nameValueMaps.size()) {
                Map keyValueMap = (Map)nameValueMaps.get(i);
                Map.Entry entry = keyValueMap.entrySet().iterator().next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value != null && value.length() > 0) {
                    settings.append(name);
                    settings.append("=");
                    settings.append(value);
                    if (i < nameValueMaps.size() - 1) {
                        settings.append(",");
                    }
                }
                ++i;
            }
        }
        return settings.toString();
    }

    public void setEnabled(boolean enabled) {
        this.repositoriesViewer.getTable().setEnabled(enabled);
        this.bAdd.setEnabled(enabled);
        if (enabled) {
            this.updateUpDownEditRemoveTestButton();
        } else {
            this.bUp.setEnabled(enabled);
            this.bDown.setEnabled(enabled);
            this.bRemove.setEnabled(enabled);
            if (this.bEdit != null) {
                this.bEdit.setEnabled(enabled);
            }
        }
    }

    public CheckboxTableViewer getRepositoriesViewer() {
        return this.repositoriesViewer;
    }

    public Table getTable() {
        return this.repsTable;
    }

    public List getImportEnabledRepLocations() {
        return this.importEnabledRepLocations;
    }

    private IStatus checkSelectedRepositoryStatus(final boolean resetCachedFiles, String repLocation) {
        final IStatus[] returnStatus = new IStatus[]{Status.OK_STATUS};
        try {
            final CheckRepositoriesTask task = new CheckRepositoriesTask();
            task.addRepositoryLocation(repLocation);
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    returnStatus[0] = task.checkAccessibility(resetCachedFiles, false, monitor);
                }
            });
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        return returnStatus[0];
    }

    public void resetRepositoryStatus() {
        CheckRepositoriesTask task = this.createCheckRepositoryTask();
        if (task.isTaskEmpty()) {
            return;
        }
        task.resetCheckedRepositoryAccessibility();
    }

    private CheckRepositoriesTask createCheckRepositoryTask() {
        final CheckRepositoriesTask task = new CheckRepositoriesTask();
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Table table = RepositoryTable.this.repositoriesViewer.getTable();
                int i = 0;
                while (i < table.getItemCount()) {
                    TableItem tableItem = table.getItem(i);
                    if (tableItem.getChecked()) {
                        task.addRepositoryLocation((String)tableItem.getData());
                    }
                    ++i;
                }
            }
        });
        return task;
    }

    public void updateRepositoryTableViewer() {
        Table table = this.repositoriesViewer.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            this.repositoriesViewer.update(table.getItem(i).getData(), null);
            ++i;
        }
    }

    public void addRepositoriesToGroup(IProgressMonitor monitor) {
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        monitor.beginTask(com.ibm.cic.common.core.sharedUI.Messages.ProgressDialog_Checking_Repositories, this.repLocations.size());
        try {
            IRepository existingRep;
            RepositoryGroup group;
            IRepositoryInfo repInfo;
            Boolean isOpen;
            String repLocation;
            HashMap repLocationMsg = new HashMap();
            boolean isCanceled = monitor.isCanceled();
            int i = 0;
            while (i < this.repLocations.size()) {
                repLocation = (String)this.repLocations.get(i);
                isOpen = (Boolean)this.repOpen.get(repLocation);
                if (!isOpen.booleanValue()) {
                    repInfo = this.constructRepInfo(repLocation);
                    group = RepositoryGroup.getDefault();
                    existingRep = group.findRepository(repInfo);
                    if (existingRep != null) {
                        group.removeRepository(existingRep);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.repLocations.size()) {
                repLocation = (String)this.repLocations.get(i);
                isOpen = (Boolean)this.repOpen.get(repLocation);
                if (isOpen.booleanValue()) {
                    repInfo = this.constructRepInfo(repLocation);
                    group = RepositoryGroup.getDefault();
                    existingRep = group.findRepository(repInfo);
                    if (existingRep == null) {
                        IStatus repoStatus = this.checkRepositoryStatus(repLocation, true, repLocationMsg, new SubProgressMonitor(monitor, 1));
                        isCanceled = monitor.isCanceled();
                        if (isCanceled) {
                            this.repStatus.put(repLocation, REP_CONNECTION_STATUS_UNKNOW);
                        } else {
                            this.repStatus.put(repLocation, Boolean.valueOf(repoStatus.isOK()).toString());
                        }
                        if (isCanceled) {
                            break;
                        }
                    }
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            rememberPrompts.forget();
            monitor.done();
        }
    }

    private void addToMultiStatus(CicMultiStatus multiStatus, IStatus status) {
        if (!status.isMultiStatus()) {
            multiStatus.add(status);
        } else {
            IStatus[] nested;
            IStatus[] iStatusArray = nested = status.getChildren();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                boolean hasSameMsg = false;
                IStatus[] children = multiStatus.getChildren();
                if (children != null) {
                    IStatus[] iStatusArray2 = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IStatus element2 = iStatusArray2[n4];
                        if (element2.getMessage().equals(element.getMessage())) {
                            hasSameMsg = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!hasSameMsg) {
                    multiStatus.add(element);
                }
                ++n2;
            }
        }
    }

    private class CheckRepositoriesTask {
        private final List repositoryLocations = new LinkedList();

        private CheckRepositoriesTask() {
        }

        void addRepositoryLocation(String location) {
            this.repositoryLocations.add(location);
        }

        boolean isTaskEmpty() {
            return this.repositoryLocations.isEmpty();
        }

        public void resetCheckedRepositoryAccessibility() {
            int i = 0;
            while (i < this.repositoryLocations.size()) {
                String repLocation = (String)this.repositoryLocations.get(i);
                RepositoryTable.this.repStatus.put(repLocation, RepositoryTable.REP_CONNECTION_STATUS_UNKNOW);
                ++i;
            }
        }

        IStatus checkAccessibility(boolean resetCachedFiles, boolean testAllConnection, IProgressMonitor monitor) {
            RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
            monitor.beginTask(com.ibm.cic.common.core.sharedUI.Messages.ProgressDialog_Checking_Repositories, this.repositoryLocations.size() + 2);
            monitor.worked(1);
            try {
                int i = 0;
                while (i < this.repositoryLocations.size()) {
                    String repLocation = (String)this.repositoryLocations.get(i);
                    RepositoryTable.this.repStatus.put(repLocation, RepositoryTable.REP_CONNECTION_STATUS_UNKNOW);
                    ++i;
                }
                CicMultiStatus multiStatus = Statuses.ST.createMultiStatus();
                ArrayList<String> errorRepList = new ArrayList<String>();
                HashMap repLocationMsg = new HashMap();
                boolean isCanceled = monitor.isCanceled();
                int i2 = 0;
                while (i2 < this.repositoryLocations.size()) {
                    String repLocation = (String)this.repositoryLocations.get(i2);
                    IStatus status = RepositoryTable.this.checkRepositoryStatus(repLocation, resetCachedFiles, repLocationMsg, new SubProgressMonitor(monitor, 1));
                    isCanceled = monitor.isCanceled();
                    if (isCanceled) {
                        RepositoryTable.this.repStatus.put(repLocation, RepositoryTable.REP_CONNECTION_STATUS_UNKNOW);
                    } else {
                        RepositoryTable.this.repStatus.put(repLocation, Boolean.valueOf(status.isOK()).toString());
                    }
                    if (!status.isOK()) {
                        String msg = NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_msg, (Object)TextProcessor.process((String)repLocation));
                        RepositoryStatus.StatusAndErrorType displayStatus = RepositoryStatus.getDisplayStatusForCanAddExisting((String)msg, (IStatus)status);
                        RepositoryTable.this.addToMultiStatus(multiStatus, (IStatus)displayStatus);
                        errorRepList.add(repLocation);
                    }
                    if (isCanceled) break;
                    ++i2;
                }
                if (isCanceled) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (testAllConnection) {
                    if (multiStatus.isOK()) {
                        String displayMsg = Messages.TestConnectionResultDlg_connected;
                        String repMessages = CommonSharedUIUtils.constructRepositoryMessages(repLocationMsg, (boolean)false);
                        if (repMessages.length() > 0) {
                            displayMsg = String.valueOf(displayMsg) + "\n\n";
                            displayMsg = String.valueOf(displayMsg) + repMessages;
                        }
                        multiStatus.setMessage(displayMsg);
                    } else {
                        CicMultiStatus warningStatus;
                        StringBuffer msg = new StringBuffer(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected);
                        msg.append("\n\n");
                        int i3 = 0;
                        while (i3 < errorRepList.size()) {
                            msg.append("-");
                            msg.append(TextProcessor.process((String)((String)errorRepList.get(i3))));
                            msg.append("\n");
                            ++i3;
                        }
                        String repMessages = CommonSharedUIUtils.constructRepositoryMessages(repLocationMsg, (boolean)false);
                        if (repMessages.length() > 0) {
                            msg.append("\n\n");
                            msg.append(repMessages);
                        }
                        multiStatus = warningStatus = Statuses.ST.createMultiStatus(multiStatus.getPlugin(), 2, multiStatus.getCode(), multiStatus.getChildren(), multiStatus.getException(), msg.toString());
                    }
                } else if (!repLocationMsg.isEmpty()) {
                    Collection values = repLocationMsg.values();
                    List repStatusList = (List)values.iterator().next();
                    if (!repStatusList.isEmpty()) {
                        if (multiStatus.isOK()) {
                            IStatus iStatus = CommonSharedUIUtils.constructRepositoryStatus(repLocationMsg);
                            return iStatus;
                        }
                        IStatus iStatus = (IStatus)repStatusList.get(0);
                        return iStatus;
                    }
                } else if (!multiStatus.isOK() && !errorRepList.isEmpty()) {
                    String repLocation = (String)errorRepList.get(0);
                    String msg = NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_msg, (Object)TextProcessor.process((String)repLocation));
                    Status status = new Status(1, multiStatus.getPlugin(), msg);
                    return status;
                }
                monitor.worked(1);
                CicMultiStatus cicMultiStatus = multiStatus;
                return cicMultiStatus;
            }
            finally {
                rememberPrompts.forget();
                monitor.done();
            }
        }
    }

    private static class RepositoryLocationsContentProvider
    implements IStructuredContentProvider {
        private RepositoryLocationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class RepositoryTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final Color closedRepColor;

        public RepositoryTableLabelProvider(Display display) {
            this.closedRepColor = CommonUIUtils.createDisabledColor(display);
        }

        public void dispose() {
            this.closedRepColor.dispose();
        }

        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return TextProcessor.process((String)obj.toString());
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 1) {
                Boolean openStatus = (Boolean)RepositoryTable.this.repOpen.get(obj.toString());
                if (openStatus.equals(Boolean.TRUE)) {
                    String connectionStatus = (String)RepositoryTable.this.repStatus.get(obj.toString());
                    if (connectionStatus == null) {
                        return RepositoryTable.this.commonUILabelProvider.get(CommonImages.REP_UNKNOWN);
                    }
                    if (connectionStatus.equals(Boolean.TRUE.toString())) {
                        return RepositoryTable.this.commonUILabelProvider.get(CommonImages.REP_UP);
                    }
                    if (connectionStatus.equals(Boolean.FALSE.toString())) {
                        return RepositoryTable.this.commonUILabelProvider.get(CommonImages.REP_DOWN);
                    }
                    return RepositoryTable.this.commonUILabelProvider.get(CommonImages.REP_UNKNOWN);
                }
                return RepositoryTable.this.commonUILabelProvider.get(CommonImages.REP_UNKNOWN);
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            Boolean openStatus = (Boolean)RepositoryTable.this.repOpen.get(element.toString());
            if (openStatus.equals(Boolean.FALSE)) {
                return this.closedRepColor;
            }
            return null;
        }
    }
}

