/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.viewers;

import com.ibm.cic.common.ui.internal.model.ITreeNode;
import com.ibm.cic.common.ui.internal.model.TreeNode;
import com.ibm.cic.common.ui.internal.viewers.INodeProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;

public abstract class BaseTreeNodeContentProvider
implements ITreeContentProvider,
INodeProvider {
    protected abstract ITreeNode getRoot();

    public void dispose() {
    }

    public Object getParent(Object element) {
        ITreeNode node = (ITreeNode)element;
        return node.getParent();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.getRoot());
    }

    protected Object[] createChildNodes(ITreeNode parentNode, Object[] childObjects) {
        List oldChildNodeList = parentNode.removeChildren();
        if (childObjects != null) {
            Object[] objectArray = childObjects;
            int n = childObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object childObject = objectArray[n2];
                ITreeNode oldChildNode = this.getExistingNodeForChild(oldChildNodeList, childObject);
                if (oldChildNode == null) {
                    parentNode.addChild(this.createChildNode(parentNode, childObject));
                } else {
                    parentNode.addChild(oldChildNode);
                    oldChildNodeList.remove(oldChildNode);
                }
                ++n2;
            }
        }
        if (oldChildNodeList.size() > 0) {
            this.onOrphansAbandoned(oldChildNodeList);
        }
        return parentNode.getChildren();
    }

    protected void onOrphansAbandoned(List orphans) {
    }

    protected ITreeNode getExistingNodeForChild(List oldChildNodeList, Object childObject) {
        for (ITreeNode oldChildNode : oldChildNodeList) {
            if (!childObject.equals(oldChildNode.getObject())) continue;
            return oldChildNode;
        }
        return null;
    }

    protected ITreeNode createChildNode(ITreeNode parentNode, Object childObject) {
        return new TreeNode(childObject, parentNode);
    }

    @Override
    public ITreeNode getNode(Object object) {
        return this.getNode(this.getRoot(), object);
    }

    @Override
    public List getNodes(ITreeNode parentNode, List objects) {
        ArrayList<ITreeNode> newNodes = new ArrayList<ITreeNode>();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            newNodes.add(this.getNode(parentNode, it.next()));
        }
        return newNodes;
    }

    @Override
    public ITreeNode getNode(ITreeNode parentNode, Object object) {
        for (ITreeNode node : parentNode.getChildList()) {
            if (!node.getObject().equals(object)) continue;
            return node;
        }
        return null;
    }

    @Override
    public List getNodes(Class[] objectTypes) {
        Vector nodes = new Vector();
        this.appendNodes(this.getRoot(), objectTypes, nodes);
        return nodes;
    }

    private void appendNodes(ITreeNode branch, Class[] objectTypes, List nodes) {
        if (this.checkTypes(branch.getObject(), objectTypes)) {
            nodes.add(branch);
        }
        for (ITreeNode node : branch.getChildList()) {
            this.appendNodes(node, objectTypes, nodes);
        }
    }

    private boolean checkTypes(Object object, Class[] objectTypes) {
        Class[] classArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class objectType = classArray[n2];
            if (objectType.isInstance(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

