/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.parts;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.parts.CicProgressMonitorPart;

public class CicProgressLabelUpdater
implements Runnable {
    private static final String className = CicProgressLabelUpdater.class.getName();
    private final Logger log = Logger.getLogger((String)className);
    private Thread updateThread;
    private final CicProgressMonitorPart part;
    private static final long UPDATE_LABEL_INTERVAL = 250L;
    private boolean running = false;

    public CicProgressLabelUpdater(CicProgressMonitorPart part) {
        this.part = part;
        this.updateThread = new Thread((Runnable)this, className);
    }

    public void start() {
        if (this.updateThread == null) {
            this.log.debug("Prevented attempt to re-start thread " + className);
            return;
        }
        if (this.running) {
            this.log.debug("Prevented attempt to start again thread " + className);
            return;
        }
        this.running = true;
        this.updateThread.start();
        this.log.debug(String.valueOf(className) + " has started.");
    }

    public void stop() {
        this.running = false;
        this.updateThread = null;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.part.isDisposed()) continue;
            this.part.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CicProgressLabelUpdater.this.part.isDisposed()) {
                        CicProgressLabelUpdater.this.part.updateLabelAndTooltip();
                    }
                }
            });
        }
        this.log.debug(String.valueOf(className) + " has quit.");
    }
}

