/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.auth.AuthorizationInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPromptConversation;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserPasswordDialog
extends TitleAreaDialog {
    private final CredentialPromptConversation c;
    private Text uidText;
    private Text pwdText;
    private Text domainText;
    private Button persist;
    private Link messageLink;
    private final Map images = new HashMap();

    public UserPasswordDialog(Shell parentShell, ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous) {
        super(parentShell);
        this.c = new CredentialPromptConversation(validator, connectMessage, requested, previous);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setMessage(this.c.getConnectMessage());
        this.setTitle(Messages.UserPasswordDialog_title);
    }

    void createPersistWarning(Composite comp) {
        Label warningLabel = new Label(comp, 0);
        warningLabel.setImage(UserPasswordDialog.getImage((String)"dialog_messasge_warning_image"));
        warningLabel.setLayoutData((Object)new GridData(34));
        Label warningText = new Label(comp, 64);
        warningText.setText(Messages.UserPasswordDialog_persist_warning);
        GridData data = new GridData(768);
        data.widthHint = 300;
        warningText.setLayoutData((Object)data);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite comp = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        comp.setLayoutData((Object)gridData);
        this.c.startConversation();
        Label uidLabel = new Label(comp, 0);
        uidLabel.setFont(font);
        uidLabel.setText(Messages.UserPasswordDialog_username_label);
        this.uidText = new Text(comp, 2048);
        this.uidText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserPasswordDialog.this.clearError();
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        this.uidText.setLayoutData((Object)data);
        Label pwdLabel = new Label(comp, 0);
        pwdLabel.setFont(font);
        pwdLabel.setText(Messages.UserPasswordDialog_password_label);
        this.pwdText = new Text(comp, 0x400800);
        if (this.c.getPwdText().getText() != null) {
            this.pwdText.setText(this.c.getPwdText().getText());
        }
        this.pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserPasswordDialog.this.clearError();
            }
        });
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        this.pwdText.setLayoutData((Object)data);
        CredentialPromptConversation.SimpleTextBox domain = this.c.getDomainText();
        if (domain != null) {
            Label domainLabel = new Label(comp, 0);
            domainLabel.setFont(font);
            domainLabel.setText(Messages.UserPasswordDialog_domain_label);
            this.domainText = new Text(comp, 2048);
            this.domainText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UserPasswordDialog.this.clearError();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 1;
            this.domainText.setLayoutData((Object)data);
        }
        this.persist = new Button(comp, 32);
        this.persist.setSelection(this.c.getPersist().getSelection());
        this.persist.setText(Messages.UserPasswordDialog_persist_btn_label);
        layout = new GridLayout();
        layout.numColumns = 2;
        data = new GridData(768);
        data.horizontalSpan = 3;
        Composite warning = new Composite(comp, 0);
        warning.setLayout((Layout)layout);
        warning.setLayoutData((Object)data);
        if (AuthorizationInfo.isLegacyKeyringActive()) {
            this.createPersistWarning(warning);
        }
        Dialog.applyDialogFont((Control)parent);
        CredentialPromptConversation.SimpleTextBox links = this.c.getLinksText();
        if (links != null) {
            this.messageLink = new Link(comp, 72);
            this.messageLink.setText(links.getText());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            this.messageLink.setLayoutData((Object)data);
            this.messageLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (!UiServices.getInstance().launchProgram(event.text)) {
                        String msg = NLS.bind((String)Messages.UserPasswordDialog_launchFailed_msg, (Object)event.text);
                        Status status = new Status(4, CicCommonUiPlugin.getPluginId(), -1, msg, null);
                        WrapDetailUIDErrorDialog.openError(UserPasswordDialog.this.getParentShell(), Messages.UserPasswordDialog_title, null, (IStatus)status);
                    }
                }
            });
        }
        if (this.c.getUidText().isNonEmptyText()) {
            this.uidText.setText(this.c.getUidText().getText());
            if (this.c.getPwdText().isNonEmptyText()) {
                this.pwdText.setText(this.c.getPwdText().getText());
                this.uidText.setFocus();
            } else {
                this.pwdText.setFocus();
            }
        } else {
            this.uidText.setFocus();
        }
        return parentComposite;
    }

    private void clearError() {
        this.setErrorMessage(null);
    }

    protected void modifyPathText() {
        this.clearError();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.UserPasswordDialog_title);
        super.configureShell(newShell);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        String uid = this.uidText.getText().trim();
        String pwd = this.pwdText.getText().trim();
        this.c.getUidText().setText(uid);
        this.c.getPwdText().setText(pwd);
        CredentialPromptConversation.SimpleTextBox domain = this.c.getDomainText();
        if (domain != null) {
            this.c.getDomainText().setText(this.domainText.getText().trim());
        }
        this.c.getPersist().setSelection(this.persist.getSelection());
        IStatus okStatus = this.c.ok();
        if (okStatus.matches(4)) {
            this.setErrorMessage(okStatus.getMessage());
            return;
        }
        super.okPressed();
    }

    public CredentialInfo getCredentialInfo() {
        return this.c.getCredentialInfo();
    }

    public IStatus getOkStatus() {
        return this.c.getOkStatus();
    }

    public boolean close() {
        this.disposeMyImages();
        return super.close();
    }

    private void disposeMyImages() {
        Iterator iter = this.images.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
    }
}

