/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.sharedUI.IRepositoryOpener;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenRepositoryDialog
extends TitleAreaDialog {
    private final String dlgTitle;
    private Text pathText;
    private Button browseButton;
    private final Map images = new HashMap();
    private final IRepositoryOpener opener;
    private final IRepositoryInfo oldRepoInfo;
    private IStatus okStatus;
    private final ImageDescriptor titleImageDescriptor;
    private final String message;
    private final String prompt;
    private final boolean wantAbort;

    public OpenRepositoryDialog(Shell parentShell, IRepositoryOpener opener, IRepositoryInfo oldRepoInfo, String title, ImageDescriptor titleImageDescriptor, String message, String prompt, String browseMessage, boolean wantAbort) {
        super(parentShell);
        this.dlgTitle = title;
        this.titleImageDescriptor = titleImageDescriptor;
        this.message = message;
        this.prompt = prompt;
        this.opener = opener;
        this.oldRepoInfo = oldRepoInfo;
        this.wantAbort = wantAbort;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle(this.dlgTitle);
        if (this.titleImageDescriptor != null) {
            this.setTitleImage(this.getImageItem(this.titleImageDescriptor));
        }
        this.setMessage(this.message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite comp = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 350;
        comp.setLayoutData((Object)gridData);
        Label promptLabel = new Label(comp, 64);
        promptLabel.setFont(font);
        promptLabel.setText(this.prompt);
        promptLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pathText = new Text(comp, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.pathText.setLayoutData((Object)data);
        this.pathText.setFont(font);
        this.pathText.setText(this.oldRepoInfo.getLocationStr());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenRepositoryDialog.this.modifyPathText();
            }
        });
        this.browseButton = new Button(comp, 8);
        this.browseButton.setFont(font);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.setText(Messages.OpenRepositoryDialog_browseButtonText);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenRepositoryDialog.this.browseButtonPressed();
            }
        });
        return parentComposite;
    }

    private void clearError() {
        this.setErrorMessage(null);
        this.setMessage(this.message);
    }

    protected void modifyPathText() {
        this.clearError();
    }

    protected void browseButtonPressed() {
        String selectedDirectoryName = UiServices.getInstance().getFileDialog(this.getShell()).filterExtensions("repository.config;diskTag.inf;*.jar;*.zip").filterPath(this.pathText.getText()).title(Messages.AddRepositoryDlg_selectRepTitle).run();
        if (selectedDirectoryName != null) {
            this.pathText.setText(selectedDirectoryName);
            this.clearError();
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.dlgTitle);
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceResources.getString((String)"ok"), true);
        if (this.wantAbort) {
            this.createButton(parent, 7, JFaceResources.getString((String)"abort"), false);
        } else {
            this.createButton(parent, 1, JFaceResources.getString((String)"cancel"), false);
        }
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1 || buttonId == 7) {
            this.cancelPressed();
        } else if (buttonId == 0) {
            this.okPressed();
        }
    }

    protected void okPressed() {
        String path = this.pathText.getText().trim();
        this.okStatus = this.opener.openAndValidateRepository(path, (IProgressMonitor)new NullProgressMonitor());
        if (this.okStatus.isOK()) {
            if (CommonSharedUIUtils.isRepositoryOpenerOKMessage((IStatus)this.okStatus)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)this.okStatus.getMessage());
            }
            super.okPressed();
        } else if (this.okStatus.getSeverity() == 2) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepWarning, (String)this.okStatus.getMessage());
            super.okPressed();
        } else {
            WrapDetailUIDErrorDialog msgDialog = new WrapDetailUIDErrorDialog(this.getShell(), null, null, this.okStatus, 5);
            msgDialog.open();
        }
    }

    public IStatus getOkStatus() {
        return this.okStatus;
    }

    private Image getImageItem(ImageDescriptor imageDes) {
        if (imageDes != null) {
            Image image = (Image)this.images.get(imageDes);
            if (image == null) {
                image = imageDes.createImage();
                this.images.put(imageDes, image);
            }
            return image;
        }
        return null;
    }

    public boolean close() {
        this.disposeMyImages();
        return super.close();
    }

    private void disposeMyImages() {
        Iterator iter = this.images.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
    }
}

