/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.api.utils.EncryptionUtils;
import com.ibm.cic.common.ui.internal.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EncryptStringDialog
extends TitleAreaDialog {
    private Text stringToEncrypt;
    private Text encryptedString;
    private final String m_strToEncrypt;

    public EncryptStringDialog(Shell parentShell, String strToEncrypt) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_strToEncrypt = strToEncrypt;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.EncryptString_title_explanation);
        this.setTitle(Messages.EncryptString_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite comp = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 1, true, false);
        comp.setLayoutData((Object)gridData);
        Label fillerLabel = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        fillerLabel.setLayoutData((Object)gd);
        Label pwdLabel = new Label(comp, 0);
        pwdLabel.setFont(font);
        pwdLabel.setText(Messages.EncryptString_string_to_encrypt_label);
        this.stringToEncrypt = new Text(comp, 2048);
        this.stringToEncrypt.setText(this.m_strToEncrypt);
        this.stringToEncrypt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EncryptStringDialog.this.clearError();
            }
        });
        GridData data = new GridData(4, 1, true, false);
        this.stringToEncrypt.setLayoutData((Object)data);
        Label pwdReLabel = new Label(comp, 0);
        pwdReLabel.setFont(font);
        pwdReLabel.setText(Messages.EncryptString_encrypted_string_label);
        this.encryptedString = new Text(comp, 2056);
        this.encryptedString.setText(EncryptionUtils.encrypt((String)this.stringToEncrypt.getText().trim()));
        this.encryptedString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EncryptStringDialog.this.clearError();
            }
        });
        data = new GridData(4, 1, true, false);
        this.encryptedString.setLayoutData((Object)data);
        return parentComposite;
    }

    private void clearError() {
        this.setErrorMessage(null);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.EncryptString_title);
        super.configureShell(newShell);
    }

    protected void okPressed() {
        this.stringToEncrypt.setText(this.stringToEncrypt.getText().trim());
        this.encryptedString.setText(EncryptionUtils.encrypt((String)this.stringToEncrypt.getText()));
    }
}

