/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.internal.viewers.PropertyTable;
import com.ibm.cic.common.ui.services.IFileDialogService;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddRepositoryDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(AddRepositoryDialog.class);
    private Combo repLocationCombo;
    private Button browseBtn;
    private Button specifyTypeBtn;
    private Group settingsGroup;
    private Combo typeCombo;
    private Composite tableComp;
    private PropertyTable propertyTable;
    private String repLocation;
    private String repType;
    private String specialSettings = "";
    private String[] initialRepList;
    private String[] repositoryTypes;
    private String[] repositoryDefaultVersions;
    private final Map typeProperties = new HashMap();
    private boolean repIsOk = false;
    private final List repAlreadyInList;
    private IRepositoryInfo repInfo;
    private final List initProperties;
    private final String initRepLocation;
    private final CommonUILabelProvider labelProvider;
    private final boolean edit;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private static final int DEFAULT_DIALOG_WIDTH = 600;
    private static final int DEFAULT_DIALOG_HEIGHT = 350;

    public AddRepositoryDialog(Shell parentShell, Set initialReps, List repAlreadyInList, String initLocation, List initProperties, boolean edit) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (initialReps != null && !initialReps.isEmpty()) {
            if (initLocation != null && !initialReps.contains(initLocation)) {
                initialReps.add(initLocation);
            }
            this.initialRepList = initialReps.toArray(new String[initialReps.size()]);
        }
        this.repAlreadyInList = repAlreadyInList;
        this.initRepLocation = initLocation;
        this.repLocation = initLocation;
        this.initProperties = initProperties;
        this.edit = edit;
        this.labelProvider = CicCommonUiPlugin.getDefault().getLabelProvider();
        this.labelProvider.connect((Object)this);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (!this.edit) {
            newShell.setText(Messages.AddRepositoryDialog_title);
        } else {
            newShell.setText(Messages.AddRepositoryDialog_edit_title);
        }
        this.readConfiguration();
        if (this.dialogLocation != null) {
            newShell.setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            newShell.setSize(this.dialogSize);
        } else {
            newShell.setSize(600, 350);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, null);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        if (!this.edit) {
            this.setTitle(Messages.AddRepositoryDialog_des);
            this.setMessage(Messages.AddRepositoryDialog_info);
        } else {
            this.setTitle(Messages.AddRepositoryDialog_edit_des);
            this.setMessage(Messages.AddRepositoryDialog_edit_info);
        }
        this.setTitleImage(this.labelProvider.get(CommonImages.WIZ_ADDREP));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        comp.setLayout((Layout)layout);
        GridData compLayout = new GridData(1808);
        comp.setLayoutData((Object)compLayout);
        Label repLocationLabel = new Label(comp, 0);
        repLocationLabel.setText(Messages.AddRepositoryDialog_repLocation);
        repLocationLabel.setFont(font);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        repLocationLabel.setLayoutData((Object)data);
        this.repLocationCombo = new Combo(comp, 4);
        this.repLocationCombo.setFont(font);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.repLocationCombo.setLayoutData((Object)data);
        if (this.initialRepList != null) {
            this.repLocationCombo.setItems(this.initialRepList);
        }
        if (this.repLocation != null) {
            this.repLocationCombo.setText(TextProcessor.process((String)this.repLocation));
        }
        this.repLocationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryDialog.this.checkIfAlreadyExist();
            }
        });
        this.browseBtn = new Button(comp, 0);
        this.browseBtn.setFont(font);
        this.browseBtn.setText(Messages.AddRepositoryDialog_browseBtn);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.browseBtn.setLayoutData((Object)data);
        this.browseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = DisplayKeeper.INSTANCE.getDisplay().getActiveShell();
                String dir = AddRepositoryDialog.this.repLocationCombo.getText();
                IFileDialogService service = UiServices.getInstance().getFileDialog(shell);
                if (Platform.getOS().equals("macosx")) {
                    service.filterExtensions("*.config;*.inf;*.jar;*.zip");
                } else {
                    service.filterExtensions("repository.config;diskTag.inf;*.jar;*.zip");
                }
                String selectedPath = service.title(Messages.AddRepositoryDlg_selectRepTitle).filterPath(TextProcessor.deprocess((String)dir)).run();
                if (selectedPath != null) {
                    AddRepositoryDialog.this.repLocationCombo.setText(TextProcessor.process((String)selectedPath));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite typeComp = new Composite(comp, 0);
        typeComp.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 1;
        typeComp.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        typeComp.setLayoutData((Object)data);
        String initType = null;
        if (this.initProperties != null) {
            initType = this.getInitType();
        }
        this.specifyTypeBtn = new Button(typeComp, 32);
        this.specifyTypeBtn.setText(Messages.AddRepositoryDialog_specifyType);
        this.specifyTypeBtn.setFont(font);
        this.specifyTypeBtn.setVisible(false);
        data = new GridData();
        this.specifyTypeBtn.setLayoutData((Object)data);
        this.specifyTypeBtn.setSelection(initType != null);
        this.specifyTypeBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AddRepositoryDialog.this.specifyTypeBtn.getSelection()) {
                    AddRepositoryDialog.this.settingsGroup.setVisible(true);
                } else {
                    AddRepositoryDialog.this.settingsGroup.setVisible(false);
                }
            }
        });
        this.settingsGroup = new Group(typeComp, 0);
        this.settingsGroup.setFont(font);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        this.settingsGroup.setLayout((Layout)gridLayout);
        data = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)data);
        this.settingsGroup.setVisible(initType != null);
        Composite groupComp = new Composite((Composite)this.settingsGroup, 0);
        groupComp.setFont(font);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        groupComp.setLayout((Layout)gridLayout);
        data = new GridData(768);
        groupComp.setLayoutData((Object)data);
        Label repTypeLabel = new Label(groupComp, 0);
        repTypeLabel.setText(Messages.AddRepositoryDialog_repType);
        repTypeLabel.setFont(font);
        this.typeCombo = new Combo(groupComp, 12);
        this.typeCombo.setFont(font);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.typeCombo.setLayoutData((Object)data);
        this.getRepositoryTypes();
        this.typeCombo.setItems(this.repositoryTypes);
        if (initType != null) {
            this.typeCombo.setText(initType);
        }
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                List properties = null;
                String type = AddRepositoryDialog.this.typeCombo.getText().trim();
                if (type != null && type.length() > 0) {
                    properties = (List)AddRepositoryDialog.this.typeProperties.get(type);
                }
                if (AddRepositoryDialog.this.propertyTable != null) {
                    AddRepositoryDialog.this.propertyTable.setProperties(properties);
                    AddRepositoryDialog.this.propertyTable.populateTableContents();
                }
                AddRepositoryDialog.this.checkIfAlreadyExist();
            }
        });
        this.tableComp = new Composite((Composite)this.settingsGroup, 0);
        this.tableComp.setFont(font);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.tableComp.setLayout((Layout)gridLayout);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.horizontalIndent = 0;
        this.tableComp.setLayoutData((Object)data);
        Label settingsLabel = new Label(this.tableComp, 0);
        settingsLabel.setText(Messages.AddRepositoryDialog_specialSettings);
        settingsLabel.setFont(font);
        data = new GridData();
        settingsLabel.setLayoutData((Object)data);
        List properties = null;
        String type = this.typeCombo.getText().trim();
        if (type != null && type.length() > 0) {
            properties = (List)this.typeProperties.get(type);
        }
        this.propertyTable = new PropertyTable(this.tableComp, false, null, properties, type, 1);
        return comp;
    }

    private void constructSpecialSettings() {
        String type;
        this.specialSettings = "";
        if (this.specifyTypeBtn.getSelection() && (type = this.typeCombo.getText().trim()) != null && type.length() > 0) {
            this.specialSettings = String.valueOf(this.specialSettings) + "Type";
            this.specialSettings = String.valueOf(this.specialSettings) + "=";
            this.specialSettings = String.valueOf(this.specialSettings) + type;
            if (this.typeProperties != null && this.typeProperties.size() > 0) {
                List properties = (List)this.typeProperties.get(type);
                for (Map keyValueMap : properties) {
                    Map.Entry entry = keyValueMap.entrySet().iterator().next();
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value == null || value.length() <= 0) continue;
                    this.specialSettings = String.valueOf(this.specialSettings) + ",";
                    this.specialSettings = String.valueOf(this.specialSettings) + name;
                    this.specialSettings = String.valueOf(this.specialSettings) + "=";
                    this.specialSettings = String.valueOf(this.specialSettings) + value;
                }
            }
        }
    }

    private void checkIfAlreadyExist() {
        boolean enableOKButton = false;
        boolean error = false;
        String errorMsg = com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_error;
        String location = this.repLocationCombo.getText().trim();
        this.repLocation = TextProcessor.deprocess((String)location);
        if (this.repLocation != null && this.repLocation.length() > 0) {
            if (this.specifyTypeBtn.getSelection()) {
                this.repType = this.typeCombo.getText().trim();
            }
            this.constructSpecialSettings();
            boolean exist = false;
            Iterator it = this.repAlreadyInList.iterator();
            while (it.hasNext()) {
                if (!this.repLocation.equals(it.next())) continue;
                exist = true;
                break;
            }
            if (exist) {
                enableOKButton = false;
                error = true;
            } else {
                enableOKButton = true;
                error = false;
            }
        } else {
            enableOKButton = false;
        }
        this.getButton(0).setEnabled(enableOKButton);
        if (error) {
            this.setErrorMessage(errorMsg);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        if (this.initRepLocation == null) {
            this.checkIfAlreadyExist();
        }
        return result;
    }

    public String getLocation() {
        return this.repLocation;
    }

    public String getType() {
        return this.repType;
    }

    public String getSpecialSettings() {
        return this.specialSettings;
    }

    protected void okPressed() {
        String lcPassportAdvantageSiteLocation;
        String lcRepositoryLocation;
        int index;
        String type;
        String location = this.repLocationCombo.getText().trim();
        this.repLocation = TextProcessor.deprocess((String)location);
        if (this.specifyTypeBtn.getSelection()) {
            this.repType = this.typeCombo.getText().trim();
        }
        this.constructSpecialSettings();
        String version = null;
        if (this.specifyTypeBtn != null && this.specifyTypeBtn.getSelection() && (type = this.typeCombo.getText().trim()) != null && type.length() > 0 && (index = this.typeCombo.getSelectionIndex()) != -1) {
            version = this.repositoryDefaultVersions[index];
        }
        if ((lcRepositoryLocation = this.repLocation.toLowerCase()).startsWith(lcPassportAdvantageSiteLocation = CommonDef.Urls.EntitledRepositoryUrl.toLowerCase())) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_title, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_passportAdvantagedRepositoryUsedMsg);
            return;
        }
        RepositoryGroup repGroup = RepositoryGroup.getDefault();
        this.repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)repGroup, (String)this.repLocation, null, version, (String)this.repLocation, (String)this.specialSettings);
        repGroup.getFileCacheManager().resetPathTree(this.repInfo.getLocation());
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        try {
            IStatus status = this.checkCanAddExistingRepository(this.repInfo);
            if (status.isOK()) {
                this.repIsOk = true;
                HashMap repLocationMsgList = new HashMap();
                CommonSharedUIUtils.generateRepositoryStatusList((IRepositoryInfo)this.repInfo, repLocationMsgList);
                String repMsg = CommonSharedUIUtils.constructRepositoryMessages(repLocationMsgList, (boolean)false);
                if (repMsg.length() > 0) {
                    if (CommonSharedUIUtils.repositoryMessageContainWarning(repLocationMsgList)) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepWarning, (String)repMsg);
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)repMsg);
                    }
                }
                super.okPressed();
            } else {
                RepositoryStatus.StatusAndErrorType displayStatusAndType;
                this.repIsOk = false;
                String msg = NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_msg, (Object)TextProcessor.process((String)this.repLocation));
                msg = String.valueOf(msg) + "\n\n";
                IStatus repStatus = this.repInfo.getRepositoryReportedStatus();
                if (repStatus != null && repStatus.getSeverity() == 4 && repStatus.getMessage().trim().length() > 0) {
                    msg = String.valueOf(msg) + repStatus.getMessage();
                    msg = String.valueOf(msg) + "\n\n";
                }
                if ((displayStatusAndType = RepositoryStatus.getDisplayStatusForCanAddExisting((String)(msg = String.valueOf(msg) + com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_confirmMsg), (IStatus)status)).isKnownInvalidLocation()) {
                    if (displayStatusAndType.getCode() == 6002) {
                        Status newDisplayStatus = new Status(displayStatusAndType.getSeverity(), displayStatusAndType.getPlugin(), String.valueOf(displayStatusAndType.getMessage()) + "\n\n" + com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_confirmMsg);
                        YesNoErrorDialog msgDialog = new YesNoErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_title, null, (IStatus)newDisplayStatus, 5);
                        if (msgDialog.open() == 2) {
                            super.okPressed();
                        }
                    } else {
                        WrapDetailUIDErrorDialog msgDialog = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_title, null, (IStatus)displayStatusAndType, 5);
                        msgDialog.open();
                    }
                } else {
                    YesNoErrorDialog msgDialog = new YesNoErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_title, null, (IStatus)displayStatusAndType, 5);
                    if (msgDialog.open() == 2) {
                        super.okPressed();
                    }
                }
                this.repInfo = null;
            }
        }
        finally {
            rememberPrompts.forget();
        }
    }

    private IStatus checkCanAddExistingRepository(final IRepositoryInfo info) {
        final IStatus[] status = new IStatus[1];
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Checking repository", 3);
                    try {
                        block8: {
                            monitor.worked(1);
                            SubProgressMonitor sm = new SubProgressMonitor(monitor, 1);
                            try {
                                try {
                                    String msg = NLS.bind((String)Messages.ProgressDialog_Check_Repository, (Object)info.getLocationStr());
                                    sm.beginTask(msg, 1);
                                    sm.setTaskName(msg);
                                    status[0] = RepositoryGroup.getDefault().canAddExistingRepository(info, (IProgressMonitor)sm);
                                }
                                catch (Exception e) {
                                    status[0] = new Status(4, CicCommonUiPlugin.getPluginId(), -1, "Error while executing runnable with progress", (Throwable)e);
                                    sm.done();
                                    break block8;
                                }
                            }
                            catch (Throwable throwable) {
                                sm.done();
                                throw throwable;
                            }
                            sm.done();
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("Unable to check if repository can be added: " + info.getLocationStr());
            logger.error((Throwable)e);
        }
        return status[0];
    }

    public boolean getIfRepositoryIsOk() {
        return this.repIsOk;
    }

    private void getRepositoryTypes() {
        RepositoryDescriptor[] des = RepositoryGroup.getDefault().getRepositoryDescriptors();
        this.repositoryTypes = new String[des.length];
        this.repositoryDefaultVersions = new String[des.length];
        int i = 0;
        while (i < des.length) {
            String type;
            this.repositoryTypes[i] = type = des[i].getType();
            this.repositoryDefaultVersions[i] = des[i].getVersion();
            RepositoryDescriptor.RepositoryParameter[] pars = des[i].getRepositoryParameters();
            ArrayList nameValuePairs = new ArrayList();
            RepositoryDescriptor.RepositoryParameter[] repositoryParameterArray = pars;
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryDescriptor.RepositoryParameter par = repositoryParameterArray[n2];
                String name = par.tag.label();
                String defaultValue = par.defaultValue;
                String value = null;
                if (this.edit && this.initProperties != null && type.equals(this.getInitType())) {
                    Iterator it = this.initProperties.iterator();
                    while (it.hasNext() && value == null) {
                        Map pair = (Map)it.next();
                        if (!name.equals(pair.keySet().iterator().next())) continue;
                        value = (String)pair.get(name);
                    }
                }
                if (value != null) {
                    defaultValue = value;
                }
                HashMap<String, String> nameValueMap = new HashMap<String, String>();
                nameValueMap.put(name, defaultValue);
                nameValuePairs.add(nameValueMap);
                ++n2;
            }
            this.typeProperties.put(type, nameValuePairs);
            ++i;
        }
    }

    public boolean close() {
        this.writeConfiguration();
        if (this.labelProvider != null) {
            this.labelProvider.disconnect((Object)this);
        }
        return super.close();
    }

    private String getInitType() {
        String initType = null;
        for (Map nameValueMap : this.initProperties) {
            Map.Entry entry = nameValueMap.entrySet().iterator().next();
            String name = (String)entry.getKey();
            if (!name.equals("Type")) continue;
            initType = (String)entry.getValue();
            break;
        }
        return initType;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = CicCommonUiPlugin.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }
}

