/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.actions;

import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.SelectionProperties;
import com.ibm.cic.common.ui.internal.model.ITreeNode;
import com.ibm.cic.common.ui.internal.viewers.INodeProvider;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ViewerAction
extends Action {
    private final StructuredViewer viewer;
    private Image image;

    public ViewerAction(StructuredViewer viewer, String text) {
        this(viewer, text, null);
    }

    public ViewerAction(StructuredViewer viewer, String text, ImageDescriptor descr) {
        super(text, descr);
        this.viewer = viewer;
        if (descr != null) {
            this.image = CicCommonUiPlugin.getDefault().getLabelProvider().get(descr);
        }
    }

    public IAction createTextlessClone() {
        ViewerAction clone = new ViewerAction(this.getViewer(), null){

            @Override
            public void setEnabled(SelectionProperties sp) {
                ViewerAction.this.setEnabled(sp);
            }

            public void run() {
                ViewerAction.this.run();
            }

            public void runWithEvent(Event event) {
                ViewerAction.this.runWithEvent(event);
            }
        };
        clone.setImageDescriptor(this.getImageDescriptor());
        clone.setDisabledImageDescriptor(this.getDisabledImageDescriptor());
        return clone;
    }

    public abstract void setEnabled(SelectionProperties var1);

    public Image getImage() {
        return this.image;
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    protected void selectNode(ITreeNode node) {
        this.viewer.reveal((Object)node);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
        this.viewer.getControl().setFocus();
    }

    protected void selectNodes(List nodes) {
        this.refreshViewer();
        for (ITreeNode node : nodes) {
            this.viewer.reveal((Object)node);
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(nodes), true);
        this.viewer.getControl().setFocus();
    }

    protected void checkNodes(List nodes) {
        TreeItem[] items;
        this.refreshViewer();
        for (ITreeNode node : nodes) {
            this.viewer.reveal((Object)node);
        }
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.viewer;
        TreeItem[] treeItemArray = items = ctv.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            ctv.setSubtreeChecked(element, false);
            ++n2;
        }
        ctv.setCheckedElements(nodes.toArray());
        this.viewer.getControl().setFocus();
    }

    protected INodeProvider getNodeProvider() {
        return (INodeProvider)this.viewer.getContentProvider();
    }
}

