/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.ui.internal.PixelConverter;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SWTUtil {
    public static Display getStandardDisplay() {
        return DisplayKeeper.INSTANCE.getDisplay();
    }

    public static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Dialog.applyDialogFont((Control)button);
        assert (button != null);
        Object gd = button.getLayoutData();
        if (gd == null) {
            gd = new GridData();
            button.setLayoutData(gd);
        }
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
        }
    }

    public static void setDialogSize(Dialog dialog, int width, int height) {
        Point computedSize = dialog.getShell().computeSize(-1, -1);
        width = Math.max(computedSize.x, width);
        height = Math.max(computedSize.y, height);
        dialog.getShell().setSize(width, height);
    }
}

