/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.ui.internal.ImageOverlayIcon;
import com.ibm.cic.common.ui.internal.OverlayIcon;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractCICLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    Hashtable images = new Hashtable();
    ArrayList consumers = new ArrayList();

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.size() == 0) {
            this.reset();
        }
    }

    public void dispose() {
        this.reset();
        super.dispose();
    }

    private void reset() {
        Enumeration iterator = this.images.elements();
        while (iterator.hasMoreElements()) {
            Image image = (Image)iterator.nextElement();
            image.dispose();
        }
        this.images.clear();
    }

    public Image get(ImageDescriptor desc) {
        return this.get(desc, 0);
    }

    public Image get(ImageDescriptor desc, int flags) {
        Image image;
        Object key = desc;
        if (flags != 0) {
            key = this.getKey(desc.hashCode(), flags);
        }
        if ((image = (Image)this.images.get(key)) == null) {
            image = this.createImage(desc, flags);
            this.images.put(key, image);
        }
        return image;
    }

    public Image get(Image image, int flags) {
        if (flags == 0) {
            return image;
        }
        String key = this.getKey(image.hashCode(), flags);
        Image resultImage = (Image)this.images.get(key);
        if (resultImage == null) {
            resultImage = this.createImage(image, flags);
            this.images.put(key, resultImage);
        }
        return resultImage;
    }

    private String getKey(long hashCode, int flags) {
        return hashCode + ":" + flags;
    }

    private Image createImage(ImageDescriptor baseDesc, int flags) {
        if (flags == 0) {
            return baseDesc.createImage();
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        OverlayIcon compDesc = new OverlayIcon(baseDesc, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private Image createImage(Image baseImage, int flags) {
        if (flags == 0) {
            return baseImage;
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        ImageOverlayIcon compDesc = new ImageOverlayIcon(baseImage, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    protected ImageDescriptor[] getLowerLeftOverlays(int flags) {
        return null;
    }

    protected ImageDescriptor[] getLowerRightOverlays(int flags) {
        return null;
    }

    protected ImageDescriptor[] getUpperLeftOverlays(int flags) {
        return null;
    }

    protected ImageDescriptor[] getUpperRightOverlays(int flags) {
        return null;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImageFromURL(URL installURL, String subdirectoryAndFilename) {
        Image image = null;
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            String key = newURL.toString();
            image = (Image)this.images.get(key);
            if (image == null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)newURL);
                image = desc.createImage();
                this.images.put(key, image);
            }
        }
        catch (MalformedURLException e) {
            this.logException(e);
        }
        catch (SWTException e) {
            this.logException(e);
        }
        return image;
    }

    protected abstract void logException(Throwable var1);
}

