/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ZipInstallOperation;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class TempUnzipUtil {
    public static final String UNZIP_PROPERTIES = "unzip.properties";

    public static ZipEntryFileMap unzipAndDetermineEntries(boolean isUndoable, ContentInfoComputation.IValidatingInputStream visZip, String taskName, TempUtil.UniqueTempDir utdForUnzip, IProgressMonitor unzipPM) throws CoreException {
        File dirForUnzip = utdForUnzip.getUniqueTempDir();
        ZipEntryFileMap zipMapFile = new ZipEntryFileMap(dirForUnzip);
        try {
            TempUnzipUtil.writeUnzipProperties(visZip, dirForUnzip);
            IStatus status = Util.unzipStream((boolean)isUndoable, (Object)visZip.getSource(), (InputStream)visZip.getInputStream(), (long)visZip.getContentLength(), (Util.IUnzipEntryHelper)zipMapFile, (String)taskName, (IProgressMonitor)unzipPM);
            if (status.matches(2)) {
                ZipInstallOperation.log.status(status);
            }
            if (status.matches(12)) {
                FileUtil.rm_r((File)dirForUnzip, (boolean)true);
                throw new CoreException(status);
            }
        }
        finally {
            unzipPM.done();
        }
        return zipMapFile;
    }

    private static void writeUnzipProperties(ContentInfoComputation.IValidatingInputStream visZip, File dirForUnzip) {
        Properties props = new Properties();
        props.setProperty("unpackedZip", visZip.getSource().toString());
        File unzipProperties = new File(dirForUnzip, UNZIP_PROPERTIES);
        try (FileOutputStream fos = new FileOutputStream(unzipProperties);){
            props.store(fos, null);
        }
        catch (IOException e) {
            ZipInstallOperation.log.error((Throwable)e);
        }
    }

    public static TempUtil.UniqueTempDir getTempDestination(Object zipSource, File destinationDir, String relPath) throws CoreException {
        TempUtil.UniqueTempDir tempDir;
        ArrayList attempts = new ArrayList();
        String tmpPrefix = "cictmp";
        if (relPath != null) {
            tmpPrefix = PathUtil.concatPathSegments((String)tmpPrefix, (String)relPath);
        }
        if ((tempDir = TempUtil.getTempDirRelatedToExistingDir((File)destinationDir, (String)tmpPrefix, attempts)) == null) {
            CicMultiStatus ms = Statuses.ERROR.getMultiStatus(NLS.bind((String)Messages.TempUnzipUtil_failedToCreateIntermediateUnpackDirectory, (Object)zipSource, (Object)destinationDir.getAbsolutePath()), new Object[0]);
            for (File triedDir : attempts) {
                ms.add((IStatus)Statuses.ERROR.get(triedDir.getAbsolutePath(), new Object[0]));
            }
            throw new CoreException((IStatus)ms);
        }
        return tempDir;
    }

    public static void removeIntermediatedUnzipDir(TempUtil.UniqueTempDir utdForUnzip, IStatus status, Object zipSource) throws CoreException {
        if (utdForUnzip == null) {
            return;
        }
        File tempDir = utdForUnzip.getUniqueTempDir();
        if (!FileUtil.rm_r((File)tempDir, (boolean)true)) {
            if (status.isOK()) {
                ICicStatus error = Statuses.ERROR.get(Messages.TempUnzipUtil_errorRemovingIntermediateFiles, new Object[]{tempDir});
                throw new CoreException((IStatus)error);
            }
            CicMultiStatus ms = Statuses.ERROR.getMultiStatus(Messages.TempUnzipUtil_errorUnzipping, new Object[]{zipSource});
            ms.add(status);
            ms.add((IStatus)Statuses.ERROR.get(Messages.TempUnzipUtil_errorRemovingIntermediateFiles, new Object[]{tempDir}));
            throw new CoreException((IStatus)ms);
        }
        try {
            utdForUnzip.cleanEmptyDirs();
        }
        catch (IOException e) {
            ICicStatus error = Statuses.ERROR.get((Throwable)e, Messages.TempUnzipUtil_errorRemovingIntermediateFiles2, new Object[]{tempDir});
            throw new CoreException((IStatus)error);
        }
    }

    public static class ZipEntryFileMap
    implements Util.IUnzipEntryHelper {
        private final File outDir;
        private final LinkedHashMap mapZipEntryToFile = new LinkedHashMap();
        private int fileSequenceNum = 1;
        public static final int NDIR = 1000;
        public static final int NFILES = 500;

        public ZipEntryFileMap(File outDir) {
            this.outDir = outDir;
        }

        public OutputStream makeOutputStream(CicMultiStatus result, ZipEntry ze) throws IOException {
            if (ze.isDirectory()) {
                this.mapZipEntryToFile.put(ze.getName(), null);
                ZipInstallOperation.log.debug("Tracking directory creation for zip entry {0}", new Object[]{ze.getName()});
                return null;
            }
            File file = this.nextUnzipFileName();
            ZipInstallOperation.log.debug("Start unzipping zip entry {0} to {1}", new Object[]{ze.getName(), file.getAbsolutePath()});
            IStatus status = FileUtil.makeDirectories((File)file.getParentFile());
            if (!status.isOK()) {
                result.add(status);
                return null;
            }
            UnzipFileOutputStream out = new UnzipFileOutputStream(ze, file);
            return out;
        }

        public void doneUsingStream(ZipEntry entry, OutputStream out) {
            UnzipFileOutputStream mout = (UnzipFileOutputStream)((Object)out);
            assert (entry == mout.getZipEntry());
            File file = mout.getFile();
            assert (file != null);
            ZipInstallOperation.log.debug("Succeeded unzipping zip entry {0} to {1}", new Object[]{entry.getName(), file.getAbsolutePath()});
            this.mapZipEntryToFile.put(entry.getName(), file);
        }

        private File nextUnzipFileName() {
            int fileNum = this.fileSequenceNum++;
            return this.getUnzipFileName(fileNum, 1000, 500);
        }

        public File getUnzipFileName(int fileNum, int N, int K) {
            String numPart = PathUtil.formatZeroPaddedCount((int)6, (int)fileNum);
            String shortName = "file" + numPart;
            String dirName = ZipEntryFileMap.getDir(fileNum, N, K);
            String name = PathUtil.concatPathSegments((String)dirName, (String)shortName);
            File file = new File(this.outDir, name);
            return file;
        }

        public static String getDir(int i, int N, int K) {
            int bucket = i / K % N;
            int padding = ZipEntryFileMap.getPadding(N);
            String numPart = PathUtil.formatZeroPaddedCount((int)padding, (int)bucket);
            return "d" + numPart;
        }

        private static int getPadding(int N) {
            int n = N;
            int i = 0;
            while (n >= 10) {
                n /= 10;
                ++i;
            }
            if (i == 0) {
                i = 1;
            }
            return i;
        }

        public Collection getNamesInZipFormat() {
            return this.mapZipEntryToFile.keySet();
        }

        public File getFile(String zipEntryName) {
            return (File)this.mapZipEntryToFile.get(zipEntryName);
        }

        public File getTempDirForUnzip() {
            return this.outDir;
        }

        public File getUnzipPropertiesFile() {
            File propFile = new File(this.outDir, TempUnzipUtil.UNZIP_PROPERTIES);
            if (!propFile.isFile() && propFile.exists()) {
                return null;
            }
            return propFile;
        }

        static class UnzipFileOutputStream
        extends FileUtil.SyncOnCloseFileOutputStream {
            private final ZipEntry ze;
            private final File file;
            boolean setLastModifiedCalled = false;

            public UnzipFileOutputStream(ZipEntry ze, File file) throws FileNotFoundException {
                super(file);
                this.ze = ze;
                this.file = file;
            }

            public void close() throws IOException {
                super.close();
                if (!this.setLastModifiedCalled) {
                    this.setLastModifiedCalled = true;
                    this.file.setLastModified(this.ze.getTime());
                }
            }

            public File getFile() {
                return this.file;
            }

            public ZipEntry getZipEntry() {
                return this.ze;
            }
        }
    }
}

