/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.CoreException;

public class SymLinkUtil {
    private static final Logger log = Logger.getLogger(SymLinkUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void installSymLink(String theTarget, File theLink) throws CoreException {
        if (PlatformUtils.isSymlink((File)theLink)) {
            String target = NativeUtils.nativeGetLinkTarget((String)theLink.getAbsolutePath());
            if (target == null) throw Util.coreException(Messages.create_sym_link_failed_target_null, theLink, theTarget);
            if (!target.equals(theTarget)) throw Util.coreException(Messages.create_sym_link_failed_exist_different, theLink, theTarget, target);
            String exText = NLS.bind((String)Messages.create_sym_link_failed_exist, (Object)theLink, (Object)theTarget);
            log.debug(exText);
            return;
        } else {
            if (theLink.exists()) {
                throw Util.coreException(Messages.create_sym_link_failed_exist_file, theLink, theTarget);
            }
            int status = PlatformUtils.createSymlink((String)theTarget, (String)theLink.getAbsolutePath());
            if (status != 0) {
                if (theLink.getParentFile() == null || theLink.getParentFile().exists()) throw Util.coreException(Messages.create_sym_link_failed, theLink, theTarget);
                throw Util.coreException(Messages.create_sym_link_failed_containing_directory_not_exist, theLink, theLink.getParent());
            }
            log.debug(Messages.created_sym_link, new Object[]{theLink, theTarget});
        }
    }

    public static void uninstallSymLink(String theTarget, File theLink) throws CoreException {
        String target;
        if (PlatformUtils.isSymlink((File)theLink) && ((target = NativeUtils.nativeGetLinkTarget((String)theLink.getAbsolutePath())) == null || target.equals(theTarget))) {
            if (!FileUtil.delete((File)theLink)) {
                throw Util.coreException(Messages.delete_sym_link_failed, theLink, theTarget);
            }
            log.debug(Messages.deleted_sym_link, new Object[]{theLink, theTarget});
        }
    }
}

