/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.AbstractExecInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.CustomOperationThread;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.PPExecInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.commonNativeAdapterData.AbstractExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.utils.PassOutputThruThread;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExecInstallOperation
extends AbstractExecInstallOperation {
    private static final Logger log = Logger.getLogger(ExecInstallOperation.class);

    public ExecInstallOperation(int phase, IInstallableUnit unit, InstallContext context, ExecCommonNativeData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, (AbstractExecCommonNativeData)data, performData, writer);
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        try {
            File wdir = this.getExecWorkingDirectory();
            String[] args = this.getArguments();
            String[] cmd = this.getExecCommand(wdir);
            this.exec(this.catenate(cmd, args), wdir, monitor);
        }
        finally {
            this.performLogOperations(monitor);
        }
        return Status.OK_STATUS;
    }

    private ExecCommonNativeData getExecData() {
        return (ExecCommonNativeData)this.getData();
    }

    private File getExecWorkingDirectory() throws CoreException {
        File dir = this.performVariableSubstitutionsAndResolvePath(this.getExecData().getWorkingDirectory());
        if (!dir.isDirectory()) {
            throw Util.coreException(Messages.fileutils_directory_not_found, dir, this.getExecData().getCommand());
        }
        return dir;
    }

    private String[] getExecCommand(File wdir) throws CoreException {
        String[] stringArray;
        String[] result;
        String cmdPath = this.performVariableSubstitutions(this.getExecData().getCommand(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        File cmdFile = new File(cmdPath);
        if (!cmdFile.isAbsolute()) {
            cmdFile = new File(wdir, cmdFile.getPath());
            try {
                cmdPath = cmdFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw Util.coreException(e, e.toString(), new Object[0]);
            }
        }
        if ((result = PPExecInstallOperation.getPolicy().platformSpecificCheck(cmdPath)) != null) {
            stringArray = result;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = cmdPath;
        }
        return stringArray;
    }

    private String[] catenate(String[] a1, String[] a2) {
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    private void exec(String[] args, File workingDirectory, IProgressMonitor monitor) throws CoreException {
        try {
            Process process = Runtime.getRuntime().exec(args, null, workingDirectory);
            try {
                process.getOutputStream().close();
            }
            catch (IOException ioe) {
                log.status((IStatus)Statuses.INFO.get((Throwable)ioe, com.ibm.cic.common.core.utils.Messages.PlatformUtils_outputStreamCloseException, new Object[]{args[0], workingDirectory}));
            }
            PassOutputThruThread outThread = new PassOutputThruThread(process.getInputStream(), (Writer)this.writer);
            PassOutputThruThread errThread = new PassOutputThruThread(process.getErrorStream(), (Writer)this.writer);
            ProcessRunner runner = new ProcessRunner(process);
            this.doExec(runner, monitor);
            outThread.finish();
            errThread.finish();
            if (runner.getStatus() != 0) {
                if (this.getExecData().failOnError()) {
                    throw Util.coreException(Messages.error_running_exec, args[0], runner.getStatus(), this.getSupplementaryLogWriterFileName());
                }
                log.warning(Messages.warning_executing, new Object[]{args[0], runner.getStatus(), this.getSupplementaryLogWriterFileName()});
            } else {
                this.logCompletion();
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Util.coreException(t, t.getMessage(), new Object[0]);
        }
    }

    protected void doExec(ProcessRunner runner, IProgressMonitor monitor) throws CoreException {
        String description = this.performVariableSubstitutions(this.getExecData().getDescription());
        int approximateTime = this.getExecData().getApproximateTime();
        new CustomOperationThread(description, approximateTime, runner).runCustomOperationThread(monitor);
    }

    private String getSupplementaryLogWriterFileName() {
        File logFile = this.writer.getFile();
        if (logFile != null) {
            return logFile.getAbsolutePath();
        }
        return Messages.fileutils_file_not_found_general;
    }

    protected static class ProcessRunner
    implements Runnable {
        private final Process process;
        private int status = -1;

        public ProcessRunner(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.status = this.process.waitFor();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public int getStatus() {
            return this.status;
        }
    }
}

