/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CustomOperationThread
extends Thread {
    private static final Logger log = Logger.getLogger(CustomOperationThread.class);
    private final String description;
    private final int approximateTime;

    public CustomOperationThread(String description, int approximateTime, Runnable runnable) {
        super(runnable);
        this.description = description;
        this.approximateTime = approximateTime;
    }

    public void runCustomOperationThread(IProgressMonitor monitor) throws CoreException {
        long startTimeMillis = System.currentTimeMillis();
        try {
            monitor.beginTask(null, this.approximateTime);
            monitor.subTask(NLS.bind((String)Messages.CustomOperationThread_PrgressDes, (Object)this.description));
            this.start();
            do {
                try {
                    this.join(1000L);
                    if (this.approximateTime > 0) {
                        long actualTimeMillis = System.currentTimeMillis() - startTimeMillis;
                        monitor.subTask(NLS.bind((String)Messages.CustomOperationThread_ProgressDesOnGoing, (Object)this.pctTime(actualTimeMillis, this.isAlive() ? 99 : 100), (Object)this.description));
                    }
                    monitor.worked(1);
                }
                catch (InterruptedException actualTimeMillis) {
                    // empty catch block
                }
            } while (this.isAlive());
            monitor.done();
        }
        catch (Throwable e) {
            throw Util.coreException(e, e.toString(), new Object[0]);
        }
        this.logActualTime(startTimeMillis);
    }

    private void logActualTime(long startTimeMillis) {
        if (!log.isDebugLoggable()) {
            return;
        }
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        String elapsed = LogUtil.toElapsedTime((long)elapsedTimeMillis);
        if (this.approximateTime > 0) {
            log.debug("Custom operation {0} completed in {1}, {2} percent of estimate", new Object[]{this.description, elapsed, this.pctTime(elapsedTimeMillis, 0)});
        } else {
            log.debug("Custom operation {0} completed in {1}", new Object[]{this.description, elapsed});
        }
    }

    private String pctTime(long millis, int max) {
        long pct = (millis / (long)this.approximateTime + 5L) / 10L;
        if (max > 0 && pct > (long)max) {
            pct = max;
        }
        return Long.toString(pct);
    }
}

