/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.common.commonNativeAdapterData.ZipArtifact;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class BackupDirs {
    private static final char DIR_NUM_PREFIX = 'd';
    private static final String NEXT_AVAILABLE_DIR_NUM = "nextAvailableDirNum";
    private static final String VERSION = "version";
    private static final Version VERSION1 = new Version(0, 0, 1);
    private static final Version CURRENT_VERSION = new Version(0, 0, 2);
    private static final String NEW_EXT = ".new";
    private static final String OLD_EXT = ".old";
    private static final String KEY_SEGMENT_SEPARATOR = ";";
    private final InstallContext context;
    private final Map map = new LinkedHashMap();
    private final File rootBackupDir;
    private final File storageFile;
    private final LinkedList available = new LinkedList();
    private int nextAvailable = 0;
    private boolean useOldBackupDirs = false;
    private static final String UNLOCALIZED_PREFIX = "zip ";
    private static final String[] LOCALIZED_PREFIXES = new String[]{"Soubor ZIP ", "\u58d3\u7e2e "};
    private static final String[] LOCALIZED_SUFFIXES = new String[]{" komprimieren", " \u306e zip", " zip", " \uc555\ucd95", " s\u0131k\u0131\u015ft\u0131r\u0131lm\u0131\u015f dosyas\u0131"};

    public BackupDirs(InstallContext context) {
        this.context = context;
        File adapterStorage = context.getAdapterStorage("native");
        this.rootBackupDir = new File(adapterStorage, "backupDirs");
        this.storageFile = new File(adapterStorage, "backupDirs.properties");
        this.useOldBackupDirs = AgentUserOptions.CIC_USE_OLD_BACKUP_DIRS.isSet();
    }

    public File getArtifactBackupDir(IInstallableUnit unit, IArtifact artifact) {
        if (this.useOldBackupDirs) {
            return this.getOldArtifactBackupDir(this.getOldIuBackupDir(unit), unit.getAdapterData(), artifact);
        }
        String key = this.getKey(unit, (ZipArtifact)artifact, true);
        File backupDir = (File)this.map.get(key);
        if (backupDir == null) {
            backupDir = new File(this.rootBackupDir, String.valueOf(this.nextAvailable()));
            this.map.put(key, backupDir);
        }
        return backupDir;
    }

    public void load() throws CoreException {
        if (this.useOldBackupDirs) {
            return;
        }
        if (!this.storageFile.isFile()) {
            File oldStorageFile = new File(String.valueOf(this.storageFile.getPath()) + OLD_EXT);
            if (!oldStorageFile.isFile()) {
                this.convert();
                return;
            }
            try {
                FileUtil.renameTo((File)oldStorageFile, (File)this.storageFile, (boolean)false);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
            }
        }
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(this.storageFile);
                props.load(stream);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
                }
            }
        }
        String nextAvailableDirNum = props.getProperty(NEXT_AVAILABLE_DIR_NUM);
        this.nextAvailable = Integer.parseInt(nextAvailableDirNum);
        String versionString = props.getProperty(VERSION);
        Version version = versionString == null ? Version.emptyVersion : new Version(versionString);
        boolean isPreVersion2 = version.compareTo(VERSION1) <= 0;
        this.map.clear();
        this.available.clear();
        int i = 0;
        while (i < this.nextAvailable) {
            String backupDirName = String.valueOf(i);
            String key = props.getProperty(String.valueOf('d') + backupDirName);
            if (key == null) {
                this.available.add(i);
            } else {
                if (isPreVersion2) {
                    key = this.getUnlocalizedKey(key);
                }
                File backupDir = new File(this.rootBackupDir, backupDirName);
                this.map.put(key, backupDir);
            }
            ++i;
        }
        if (versionString == null) {
            this.addDestinations();
        }
    }

    public void store() throws CoreException {
        IStatus status;
        String key;
        if (this.useOldBackupDirs) {
            return;
        }
        Properties props = new Properties();
        props.setProperty(VERSION, CURRENT_VERSION.toString());
        int maxDirNum = -1;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            key = (String)entry.getKey();
            File backupDir = (File)entry.getValue();
            if (!backupDir.isDirectory()) {
                iterator.remove();
                continue;
            }
            String backupDirName = backupDir.getName();
            int dirNum = Integer.parseInt(backupDirName);
            if (dirNum > maxDirNum) {
                maxDirNum = dirNum;
            }
            props.setProperty(String.valueOf('d') + backupDirName, key);
        }
        this.nextAvailable = maxDirNum + 1;
        props.setProperty(NEXT_AVAILABLE_DIR_NUM, String.valueOf(this.nextAvailable));
        this.available.clear();
        if (this.map.size() < this.nextAvailable) {
            int i = 0;
            while (i < this.nextAvailable) {
                String backupDirName = String.valueOf(i);
                key = props.getProperty(String.valueOf('d') + backupDirName);
                if (key == null) {
                    this.available.add(i);
                }
                ++i;
            }
        }
        if (!(status = FileUtil.makeDirectories((File)this.storageFile.getParentFile())).isOK()) {
            throw new CoreException(status);
        }
        File newStorageFile = new File(String.valueOf(this.storageFile.getPath()) + NEW_EXT);
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(newStorageFile);
                props.store(stream, null);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
                }
            }
        }
        File oldStorageFile = null;
        if (this.storageFile.isFile()) {
            oldStorageFile = new File(String.valueOf(this.storageFile.getPath()) + OLD_EXT);
            try {
                FileUtil.renameTo((File)this.storageFile, (File)oldStorageFile, (boolean)true);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
            }
        }
        try {
            FileUtil.renameTo((File)newStorageFile, (File)this.storageFile, (boolean)false);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
        }
        if (oldStorageFile != null && oldStorageFile.isFile() && !oldStorageFile.delete()) {
            String msg = NLS.bind((String)Messages.cant_delete_file, (Object)oldStorageFile.getPath());
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, msg, null));
        }
    }

    private void addDestinations() {
        Collection units = this.context.getInstalledIUs();
        for (IInstallableUnit unit : units) {
            if (!this.isNativeInstallAdapterUnit(unit)) continue;
            IAdapterData adapterData = unit.getAdapterData();
            Collection artifacts = adapterData.getArtifacts();
            for (IArtifact artifact : artifacts) {
                ZipArtifact zipArtifact;
                String key;
                File backupDir;
                if (!(artifact instanceof ZipArtifact) || (backupDir = (File)this.map.remove(key = this.getKey(unit, zipArtifact = (ZipArtifact)artifact, false))) == null) continue;
                key = this.getKey(unit, zipArtifact, true);
                this.map.put(key, backupDir);
            }
        }
    }

    private void convert() throws CoreException {
        Collection units = this.context.getInstalledIUs();
        ArrayList oldDirs = new ArrayList();
        for (IInstallableUnit unit : units) {
            this.convertUnit(unit, oldDirs);
        }
        this.convertMergedUnits(this.context.getParentContext(), oldDirs);
        this.store();
        for (File oldDir : oldDirs) {
            FileUtil.rm_r((File)oldDir, (boolean)true);
        }
    }

    private void convertUnit(IInstallableUnit unit, ArrayList oldDirs) throws CoreException {
        if (!this.isNativeInstallAdapterUnit(unit)) {
            return;
        }
        File oldIuBackupDir = this.getOldIuBackupDir(unit);
        if (!oldIuBackupDir.isDirectory()) {
            return;
        }
        IAdapterData adapterData = unit.getAdapterData();
        Collection artifacts = adapterData.getArtifacts();
        for (IArtifact artifact : artifacts) {
            File oldArtifactBackupDir;
            if (!(artifact instanceof ZipArtifact) || !(oldArtifactBackupDir = this.getOldArtifactBackupDir(oldIuBackupDir, adapterData, artifact)).isDirectory()) continue;
            File artifactBackupDir = this.getArtifactBackupDir(unit, artifact);
            IStatus status = FileUtil.makeDirectories((File)artifactBackupDir);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            try {
                FileUtil.copyDir((File)oldArtifactBackupDir, (File)artifactBackupDir, null);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.commonNativeInstallAdapter", 1, e.toString(), (Throwable)e));
            }
            oldDirs.add(oldArtifactBackupDir);
        }
        oldDirs.add(oldIuBackupDir);
    }

    private void convertMergedUnits(InstallContext parentContext, ArrayList oldDirs) throws CoreException {
        if (parentContext == null) {
            return;
        }
        boolean mergeNative = BackupDirs.locationMatches(this.context, parentContext, "installLocation");
        if (mergeNative) {
            Collection units = parentContext.getInstalledIUs();
            for (IInstallableUnit unit : units) {
                this.convertUnit(unit, oldDirs);
            }
        }
        this.convertMergedUnits(parentContext.getParentContext(), oldDirs);
    }

    private static boolean locationMatches(InstallContext context, InstallContext parentContext, String property) {
        String parentProperty;
        String contextProperty = context.getProperty(property);
        if (Util.equals((Object)contextProperty, (Object)(parentProperty = parentContext.getProperty(property)))) {
            return true;
        }
        if (parentProperty == null) {
            return parentContext.isRootContext();
        }
        if (contextProperty == null) {
            return false;
        }
        try {
            return new File(contextProperty).getCanonicalPath().equals(new File(parentProperty).getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getKey(IInstallableUnit unit, ZipArtifact artifact, boolean withDestination) {
        String versionedId = IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit);
        String artifactString = this.getArtifactString(artifact);
        String key = String.valueOf(versionedId) + KEY_SEGMENT_SEPARATOR + artifactString;
        if (withDestination) {
            key = String.valueOf(key) + KEY_SEGMENT_SEPARATOR + artifact.getData().getDestination();
        }
        return key;
    }

    private boolean isNativeInstallAdapterUnit(IInstallableUnit unit) {
        String adapterId = unit.getAdapterId();
        return !"eclipse".equals(adapterId) && !"p2Eclipse".equals(adapterId);
    }

    private File getOldIuBackupDir(IInstallableUnit unit) {
        return new File(this.context.getAdapterStorage("native"), String.valueOf(unit.getIdentity().getId()) + '_' + unit.getVersion());
    }

    private File getOldArtifactBackupDir(File iuBackupDir, IAdapterData adapterData, IArtifact artifact) {
        return new File(iuBackupDir, String.valueOf(adapterData.artifactIndexOf(artifact)));
    }

    private int nextAvailable() {
        if (!this.available.isEmpty()) {
            Integer next = (Integer)this.available.removeFirst();
            return next;
        }
        return this.nextAvailable++;
    }

    private String getUnlocalizedKey(String localizedKey) {
        String[] segments = localizedKey.split(KEY_SEGMENT_SEPARATOR);
        String versionedId = segments[0];
        String localizedArtifactString = segments[1];
        String artifactString = this.getUnlocalizedArtifactString(localizedArtifactString);
        StringBuilder sb = new StringBuilder();
        sb.append(versionedId).append(KEY_SEGMENT_SEPARATOR).append(artifactString);
        int i = 2;
        while (i < segments.length) {
            sb.append(KEY_SEGMENT_SEPARATOR).append(segments[i]);
            ++i;
        }
        return sb.toString();
    }

    private String getUnlocalizedArtifactString(String localizedArtifactString) {
        String localizedPrefix = this.getLocalizedPrefix(localizedArtifactString);
        if (localizedPrefix != null) {
            return UNLOCALIZED_PREFIX + localizedArtifactString.substring(localizedPrefix.length());
        }
        String localizedSuffix = this.getLocalizedSuffix(localizedArtifactString);
        if (localizedSuffix != null) {
            return UNLOCALIZED_PREFIX + localizedArtifactString.substring(0, localizedArtifactString.length() - localizedSuffix.length());
        }
        return localizedArtifactString;
    }

    private String getLocalizedPrefix(String localizedArtifactString) {
        String[] stringArray = LOCALIZED_PREFIXES;
        int n = LOCALIZED_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String localizedPrefix = stringArray[n2];
            if (localizedArtifactString.startsWith(localizedPrefix)) {
                return localizedPrefix;
            }
            ++n2;
        }
        return null;
    }

    private String getLocalizedSuffix(String localizedArtifactString) {
        String[] stringArray = LOCALIZED_SUFFIXES;
        int n = LOCALIZED_SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String localizedSuffix = stringArray[n2];
            if (localizedArtifactString.endsWith(localizedSuffix)) {
                return localizedSuffix;
            }
            ++n2;
        }
        return null;
    }

    private String getArtifactString(ZipArtifact artifact) {
        IArtifactKey key = artifact.getKey();
        if (key == null) {
            return null;
        }
        String result = NLS.bind((String)"zip {0} {1}", (Object)key.getId(), (Object)key.getVersion());
        if (!key.getPath().isEmpty()) {
            result = String.valueOf(result) + '/' + key.getPath().toString();
        }
        return result;
    }
}

