/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model;

import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.p2.model.IP2ArtifactKey;
import com.ibm.cic.p2.model.IP2InstallUnit;
import com.ibm.cic.p2.model.IP2Provide;
import com.ibm.cic.p2.model.IP2Require;
import com.ibm.cic.p2.model.internal.P2ArtifactKey;
import com.ibm.cic.p2.model.internal.P2ArtifactKeyUtil;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class P2Tools {
    private static final String FEATURE_GROUP = ".feature.group";
    private static final String FEATURE_JAR = ".feature.jar";
    public static final String A_JRE = "a.jre";
    public static final String A_JRE_SE = "a.jre.javase";
    public static final String IDE_IU = "org.eclipse.sdk.ide";
    public static final String TOOLINGIDE_IU = "toolingorg.eclipse.sdk.ide";

    public static boolean isBundleIU(IP2InstallUnit unit) {
        IP2Provide[] provides = unit.getProvides("osgi.bundle");
        return provides != null && provides.length > 0;
    }

    public static boolean isFeatureJar(IP2InstallUnit unit) {
        IP2Provide[] provides = unit.getProvides("org.eclipse.update.feature");
        return provides != null && provides.length > 0;
    }

    public static boolean hasNamespace(IP2Require require, String testNS) {
        String ns = require.getNamespace();
        return ns != null && ns.equals(testNS);
    }

    public static boolean isFeatureGroup(IP2InstallUnit unit) {
        return P2Tools.isFeatureGroup(unit.getId());
    }

    public static boolean isFeatureGroup(IP2Require req) {
        return P2Tools.isFeatureGroup(req.getName());
    }

    public static boolean isFeatureGroup(String id) {
        return id != null && id.endsWith(FEATURE_GROUP);
    }

    public static boolean isEclipseFeature(IP2InstallUnit unit) {
        IP2Require[] reqs;
        if (!P2Tools.isFeatureGroup(unit)) {
            return false;
        }
        String id = P2Tools.stripFeatureGroupSegments(unit.getId());
        String jarId = String.valueOf(id) + FEATURE_JAR;
        IP2Require[] iP2RequireArray = reqs = unit.getRequires();
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            IP2Require req = iP2RequireArray[n2];
            if (req.getName().equals(jarId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String toFeatureGroupId(String id) {
        return new StringBuffer(id).append(FEATURE_GROUP).toString();
    }

    public static String toFeatureJarId(String id) {
        return new StringBuffer(id).append(FEATURE_JAR).toString();
    }

    public static IP2InstallUnit highest(IP2InstallUnit[] vals) {
        if (vals.length == 0) {
            return null;
        }
        IP2InstallUnit highest = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (highest.getVersion().compareTo(vals[i].getVersion()) < 0) {
                highest = vals[i];
            }
            ++i;
        }
        return highest;
    }

    public static IP2InstallUnit higher(IP2InstallUnit one, IP2InstallUnit two) {
        if (one.getVersion().compareTo(two.getVersion()) <= 0) {
            return two;
        }
        return one;
    }

    public static String stripFeatureGroupSegments(String id) {
        return P2Tools.stripSegments(id, FEATURE_GROUP);
    }

    public static String stripFeatureJarSegments(String id) {
        return P2Tools.stripSegments(id, FEATURE_JAR);
    }

    private static String stripSegments(String id, String segment) {
        if (id.endsWith(segment)) {
            return id.substring(0, id.length() - segment.length());
        }
        return id;
    }

    public static String[] getDefaultIUs() {
        return new String[]{A_JRE, A_JRE_SE, IDE_IU, TOOLINGIDE_IU};
    }

    public static boolean isDefaultIU(String id) {
        return A_JRE.equals(id) || A_JRE_SE.equals(id) || IDE_IU.equals(id) || TOOLINGIDE_IU.equals(id);
    }

    public static IP2ArtifactKey toP2ArtifactKey(IArtifactKey cicKey) {
        org.eclipse.equinox.p2.metadata.IArtifactKey p2Key = P2ArtifactKeyUtil.toP2Key(cicKey);
        if (p2Key == null) {
            return null;
        }
        return new P2ArtifactKey(p2Key);
    }

    public static String defaultIsProductRegex(Set<String> nonProductSelectors) {
        boolean isFirstSelector = true;
        StringBuilder sb = new StringBuilder();
        sb.append("^(.*?)\\.(");
        for (String selector : nonProductSelectors) {
            if (!isFirstSelector) {
                sb.append("|");
            } else {
                isFirstSelector = false;
            }
            sb.append(selector);
        }
        sb.append(")(\\.feature)?$");
        return sb.toString();
    }

    public static boolean isProduct(String fdID, Map<Pattern, Boolean> nonProductMap) {
        boolean isProduct = true;
        if (fdID != null && nonProductMap != null) {
            for (Map.Entry<Pattern, Boolean> entry : nonProductMap.entrySet()) {
                Pattern pattern = entry.getKey();
                if (!pattern.matcher(fdID).matches()) continue;
                isProduct = entry.getValue();
            }
        }
        return isProduct;
    }
}

