/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.template;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.IXMLProcessor;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.template.Template;
import com.ibm.cic.common.xml.core.internal.template.TemplateBinding;
import com.ibm.cic.common.xml.core.internal.template.TemplateProcessingVisitor;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.template.ITemplate;
import com.ibm.cic.common.xml.core.template.ITemplateBinding;
import com.ibm.cic.common.xml.core.template.ITemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateEngine
implements ITemplateEngine {
    @Override
    public ITemplate getTemplate(InputStream stream, String name) throws CoreException {
        IXMLProcessor processsor = CicXMLCore.getDefault().getXMLProcessor();
        try {
            processsor.process(new InputSource(stream));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", e.getMessage(), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", e.getMessage(), (Throwable)e));
        }
        IXMLModel model = processsor.getRoot();
        if (!model.isWellFormed()) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateEngine_errMalformedTemplate, (Object)name)));
        }
        return new Template(model);
    }

    @Override
    public ITemplateBinding createBinding(ITemplate template, Object root) {
        return new TemplateBinding(template, root, null);
    }

    @Override
    public IXMLModel expand(ITemplateBinding binding) throws CoreException {
        IProcessingInstruction[] procs;
        IXMLModel templateModel = binding.getTemplate().getModel();
        IXMLModel ret = CicXMLCore.getDefault().newDocument();
        IProcessingInstruction[] iProcessingInstructionArray = procs = templateModel.getProcessingInstructions();
        int n = procs.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessingInstruction proc = iProcessingInstructionArray[n2];
            ret.addProcessingInstruction(proc.copy());
            ++n2;
        }
        IXMLTextModelItem[] children = templateModel.getChildren();
        TemplateProcessingVisitor v = new TemplateProcessingVisitor(binding, ret);
        IXMLTextModelItem[] iXMLTextModelItemArray = children;
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n4];
            element.visit(v);
            IStatus s = v.getStatus();
            if (!s.isOK()) {
                throw new CoreException(s);
            }
            ++n4;
        }
        return ret;
    }
}

