/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.template;

import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.template.ITemplate;
import com.ibm.cic.common.xml.core.template.ITemplateBinding;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TemplateBinding
implements ITemplateBinding {
    private static final String GET = "get";
    private static final String $_T = "${T:";
    private static final String NOT = "!";
    private static final String PARENT_OPERATOR = "^";
    private final Object fBinding;
    private final ITemplate fTemplate;
    private final ITemplateBinding fParent;

    public TemplateBinding(ITemplate template, Object root, ITemplateBinding parent) {
        this.fTemplate = template;
        this.fBinding = root;
        this.fParent = parent;
    }

    public Iterator forEachTemplate(String selectString, String args) throws CoreException {
        TemplateBinding selection = this.getReference(selectString, args, false);
        if (selection.fBinding instanceof Collection) {
            return this.wrapIterator(((Collection)selection.fBinding).iterator());
        }
        if (selection.fBinding instanceof Iterator) {
            return this.wrapIterator((Iterator)selection.fBinding);
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errBadSelectForEach, (Object)selectString)));
    }

    private Object[] marshallArgs(Method m, String args) throws CoreException {
        StringTokenizer tok;
        if (args == null || args.trim().length() == 0) {
            return new Object[0];
        }
        Class<?>[] params = m.getParameterTypes();
        if (params.length != (tok = new StringTokenizer(args, ",")).countTokens()) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errArgMismatch, (Object[])new Object[]{m.getName(), String.valueOf(params.length), String.valueOf(tok.countTokens()), args})));
        }
        Object[] ret = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            Class<?> paramClass = params[i];
            String argPart = tok.nextToken();
            ret[i] = this.coerceType(paramClass, argPart);
            ++i;
        }
        return ret;
    }

    public Object coerceType(Class type, String val) throws CoreException {
        val = val.trim();
        try {
            if (String.class.equals((Object)type)) {
                return val;
            }
            if (Integer.class.equals((Object)type)) {
                return Integer.valueOf(val);
            }
            if (Boolean.class.equals((Object)type)) {
                return Boolean.valueOf(val);
            }
            if (Long.class.equals((Object)type)) {
                return Long.valueOf(val);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errMarshalling, (Object)val, (Object)type.getName()), (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errUnsupportedMarshall, (Object)type.getName()), null));
    }

    public IXMLTextModelItem emitTemplate(String select, String args) throws CoreException {
        if (args != null) {
            args = this.processScriptString(args);
        }
        TemplateBinding selection = this.getReference(select, args, false);
        if (selection.fBinding instanceof IXMLTextModelItem) {
            return (IXMLTextModelItem)selection.fBinding;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errBadEmit, (Object)select)));
    }

    public boolean doIf(String testString, String args) throws CoreException {
        boolean invert = false;
        if (testString.startsWith(NOT)) {
            invert = true;
            testString = testString.substring(1);
        }
        TemplateBinding test = this.getReference(testString, args, true);
        if (test.fBinding == null) {
            return invert;
        }
        if (test.fBinding instanceof Boolean) {
            return invert ? !((Boolean)test.fBinding).booleanValue() : (Boolean)test.fBinding;
        }
        if (test.fBinding instanceof Object[]) {
            return invert ? ((Object[])test.fBinding).length == 0 : ((Object[])test.fBinding).length != 0;
        }
        return !invert;
    }

    public TemplateBinding selectTemplate(String selectString, String args) throws CoreException {
        return this.getReference(selectString, null, true);
    }

    public TemplateBinding[] forTemplate(String selectString, String args) throws CoreException {
        TemplateBinding ref = this.getReference(selectString, args, false);
        if (ref.fBinding instanceof Object[]) {
            Object[] refArr = (Object[])ref.fBinding;
            TemplateBinding[] ret = new TemplateBinding[refArr.length];
            int i = 0;
            while (i < refArr.length) {
                ret[i] = new TemplateBinding(this.fTemplate, refArr[i], this);
                ++i;
            }
            return ret;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errBadSelectFor, (Object)selectString)));
    }

    private Iterator wrapIterator(Iterator iter) {
        ArrayList<TemplateBinding> arr = new ArrayList<TemplateBinding>();
        while (iter.hasNext()) {
            arr.add(new TemplateBinding(this.fTemplate, iter.next(), this));
        }
        return arr.iterator();
    }

    public String processScriptString(String script) throws CoreException {
        int curIdx = 0;
        int idx = script.indexOf($_T, curIdx);
        String ret = script;
        while (idx > -1) {
            int eIdx = script.indexOf(125, idx += $_T.length());
            if (eIdx <= -1) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateEngine_errMalformedTemplate, (Object)this.fBinding)));
            }
            String expr = script.substring(idx, eIdx);
            String val = this.evaluateExpr(expr);
            ret = script.substring(0, idx - $_T.length());
            ret = String.valueOf(ret) + val;
            curIdx = ret.length();
            script = ret = String.valueOf(ret) + script.substring(eIdx + 1);
            idx = script.indexOf($_T, curIdx);
        }
        return ret;
    }

    private String evaluateExpr(String singleExpr) throws CoreException {
        TemplateBinding ref = this.getProperty(singleExpr);
        return ref.fBinding.toString();
    }

    private TemplateBinding getProperty(String property) throws CoreException {
        TemplateBinding current = this;
        StringTokenizer tok = new StringTokenizer(property, ":");
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (PARENT_OPERATOR.equals(part)) {
                if (current != null && current.fParent != null) {
                    current = (TemplateBinding)current.fParent;
                    continue;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.TemplateBinding_parentOperatorNotValid));
            }
            Object ret = null;
            Method m = this.getterMethod(current.fBinding, part);
            if (m != null) {
                try {
                    ret = m.invoke(current.fBinding, new Object[0]);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errNoInvoke, (Object)m.getName(), (Object)property), (Throwable)e));
                }
            }
            m = this.getMethod(current.fBinding);
            if (m == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_propertyNotValidNeitherGetVNotGetSDefined, (Object)property)));
            }
            try {
                ret = m.invoke(current.fBinding, property);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errNoInvoke, (Object)m.getName(), (Object)property), (Throwable)e));
            }
            if (ret == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errNoMethod, (Object)m.getName(), (Object)property)));
            }
            current = new TemplateBinding(this.fTemplate, ret, current);
        }
        return current;
    }

    private Method getMethod(Object src) throws CoreException {
        String mName = GET;
        try {
            Method[] ms = src.getClass().getMethods();
            Method match = null;
            Method[] methodArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Method element = methodArray[n2];
                if (element.getName().equals(mName)) {
                    if (match == null) {
                        match = element;
                    } else {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errOverloads, (Object)mName)));
                    }
                }
                ++n2;
            }
            return match;
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errMissingMethod, (Object)mName), (Throwable)e));
        }
    }

    private TemplateBinding getReference(String refString, String args, boolean allowNull) throws CoreException {
        StringTokenizer tok = new StringTokenizer(refString, ":");
        TemplateBinding current = this;
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (PARENT_OPERATOR.equals(part)) {
                if (current != null && current.fParent != null) {
                    current = (TemplateBinding)current.fParent;
                    continue;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.TemplateBinding_errInvalidParentOp));
            }
            Object[] currentArgs = new Object[]{};
            Method m = this.getterMethod(current.fBinding, part);
            if (m == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errBadRef, (Object)part, (Object)refString)));
            }
            if (!tok.hasMoreTokens()) {
                if (args != null) {
                    args = this.processScriptString(args);
                }
                currentArgs = this.marshallArgs(m, args);
            }
            try {
                Object ret = m.invoke(current.fBinding, currentArgs);
                if (ret == null && !allowNull) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errNoMethod, (Object)m.getName(), (Object)refString)));
                }
                current = new TemplateBinding(this.fTemplate, ret, current);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errNoInvoke, (Object)m.getName(), (Object)refString), (Throwable)e));
            }
        }
        return current;
    }

    private Method getterMethod(Object src, String strField) throws CoreException {
        String mName = new StringBuffer(GET).append(strField).toString();
        try {
            Method[] ms = src.getClass().getMethods();
            Method match = null;
            Method[] methodArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Method element = methodArray[n2];
                if (element.getName().equals(mName)) {
                    if (match == null) {
                        match = element;
                    } else {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errOverloads, (Object)mName)));
                    }
                }
                ++n2;
            }
            return match;
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.TemplateBinding_errMissingMethod, (Object)mName), (Throwable)e));
        }
    }

    @Override
    public ITemplate getTemplate() {
        return this.fTemplate;
    }
}

