/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.gen;

import com.ibm.cic.common.xml.core.internal.gen.DocSkeleton;
import com.ibm.cic.common.xml.core.internal.gen.GenUtils;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.gen.IElementGenerator;
import com.ibm.cic.common.xml.core.model.gen.IGeneratorValueProvider;
import com.ibm.cic.common.xml.core.model.gen.ISkeleton;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;

public class XMLGenerator
implements IElementGenerator {
    @Override
    public String generate(IElementDefinition element, int depth, String delim) {
        return this.generate(element, null, false, 0, 0, false, depth, delim);
    }

    @Override
    public String generate(IElementDefinition element, int startIndex, int indent, boolean tabs, int depth, String delim) {
        return this.generate(element, null, false, startIndex, indent, tabs, depth, delim);
    }

    @Override
    public String generate(ISkeleton skeleton, boolean tabs, int initialIndent, String delim) {
        IProcessingInstruction[] _instr;
        Assert.isTrue((boolean)(skeleton instanceof DocSkeleton), (String)"XMLGenerator::generate: param skeleton must be an instanceof DocSkeleton.");
        DocSkeleton doc = (DocSkeleton)skeleton;
        StringBuffer buffer = new StringBuffer();
        IProcessingInstruction[] iProcessingInstructionArray = _instr = doc.getProcessingInstructions();
        int n = _instr.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessingInstruction element = iProcessingInstructionArray[n2];
            GenUtils.addProcessingInstruction(element, buffer, delim);
            ++n2;
        }
        IGeneratorValueProvider rootProvider = doc.getRootProvider();
        this.writeElement(doc, rootProvider, buffer, initialIndent, tabs, delim);
        return buffer.toString();
    }

    private void writeElement(DocSkeleton skeleton, IGeneratorValueProvider provider, StringBuffer buffer, int depth, boolean tabs, String delim) {
        GenUtils.padToDepth(depth, tabs, buffer);
        IElementDefinition element = provider.getDefinition();
        GenUtils.startElement(element, provider, buffer, delim);
        IGeneratorValueProvider[] children = provider.getChildren();
        if (children.length > 0) {
            IGeneratorValueProvider[] iGeneratorValueProviderArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGeneratorValueProvider element2 = iGeneratorValueProviderArray[n2];
                this.writeElement(skeleton, element2, buffer, depth + 1, tabs, delim);
                ++n2;
            }
            GenUtils.padToDepth(depth, tabs, buffer);
            GenUtils.endElement(element, buffer, delim);
        } else if (!provider.hasSimpleValue() && element.getChildElementCount() == 0) {
            GenUtils.endSingleLineElement(buffer, delim);
        } else {
            GenUtils.padToDepth(depth, tabs, buffer);
            GenUtils.endElement(element, buffer, delim);
        }
    }

    @Override
    public String generate(IElementDefinition element, IGeneratorValueProvider valueProvider, boolean doProcessingInstructions, int startIndex, int indent, boolean tabs, int depth, String delim) {
        if (depth != -1 && depth < 0) {
            System.err.println("Invalid depth provided to XMLGenerator::generate");
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        char sp = ' ';
        if (tabs) {
            sp = '\t';
        }
        if (doProcessingInstructions) {
            buffer.append("<?xml version='1.0' encoding='UTF-8'?>\r<?metadata version='0.0.4'?>\r");
        }
        boolean fullDepth = depth == -1;
        buffer.append('<');
        buffer.append(element.getName());
        Iterator iter = element.attributeIterator();
        int curDepth = 1;
        while (iter.hasNext()) {
            IAttributeDefinition def = (IAttributeDefinition)iter.next();
            if (!def.isRequired()) continue;
            this.appendAttribute(def, valueProvider, buffer);
        }
        if (element.getChildElementCount() > 0) {
            buffer.append('>');
            buffer.append('\r');
            if (fullDepth || depth >= curDepth) {
                this.insertChildren(element, buffer, startIndex + indent, sp, curDepth, depth);
            }
            buffer.append('<');
            buffer.append('/');
            buffer.append(element.getName());
            buffer.append('>');
        } else {
            buffer.append(' ');
            buffer.append('/');
            buffer.append('>');
        }
        return buffer.toString();
    }

    private void insertChildren(IElementDefinition element, StringBuffer buffer, int indent, char indentChar, int currentDepth, int depthBoundary) {
        if (currentDepth > depthBoundary) {
            // empty if block
        }
    }

    private void appendAttribute(IAttributeDefinition attr, IGeneratorValueProvider provider, StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(attr.getName());
        buffer.append('=');
        buffer.append('\'');
        if (provider != null) {
            String val = provider.getAttributeValue(attr.getName());
            if (val != null) {
                buffer.append(val);
            } else if (attr.getDefault() != null) {
                buffer.append(attr.getDefault());
            }
        } else if (attr.getDefault() != null) {
            buffer.append(attr.getDefault());
        }
        buffer.append('\'');
    }
}

