/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.ext;

import com.ibm.cic.common.xml.core.internal.ext.SchemaHolder;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ReferenceSchemaExtensions {
    private static final String EXT_REF_SCHEMA = "com.ibm.cic.common.xml.core.refSchema";
    private static final String ELEMENT_REF_SCHEMA = "schema";
    private static final String ATTR_URL = "namespaceURL";
    private static final String ATTR_FILE = "schemaFile";
    private final HashMap fRefs = new HashMap();

    public ReferenceSchemaExtensions() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_REF_SCHEMA);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (ELEMENT_REF_SCHEMA.equals(config.getName())) {
                String refURL = config.getAttribute(ATTR_URL);
                String schemaFile = config.getAttribute(ATTR_FILE);
                IContributor contributor = config.getContributor();
                String bundleId = contributor.getName();
                Bundle source = Platform.getBundle((String)bundleId);
                URL schemaURL = source.getResource(schemaFile);
                SchemaHolder holder = new SchemaHolder(config, schemaURL);
                this.fRefs.put(refURL, holder);
            }
            ++n2;
        }
    }

    public ISchema getReferenceSchema(String url) {
        SchemaHolder holder = (SchemaHolder)this.fRefs.get(url);
        if (holder != null) {
            return holder.getSchema();
        }
        return null;
    }
}

