/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.policy.ui.preferences;

import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicensePolicyDataParser;
import com.ibm.cic.licensing.common.util.LicensePolicyDataWriter;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.cic.licensing.policy.ui.preferences.Messages;
import com.ibm.cic.licensing.policy.ui.viewers.EditableTableViewer;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class LicensingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected LicensePolicyData data;
    protected EditableTableViewer tableViewer;

    public LicensingPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.data = this.getLicensePolicyData();
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)gridData);
        outerContainer.setFont(font);
        return outerContainer;
    }

    public boolean performOk() {
        try {
            File file = new File(PolicyManager.getLicensePolicyFilePath());
            file.getParentFile().mkdirs();
            LicensePolicyData latestData = this.getLicensePolicyData();
            this.updateLatestData(latestData);
            LicensePolicyDataWriter.write((File)file, (LicensePolicyData)latestData);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.preferencesTitle, (String)NLS.bind((String)Messages.writeError, (Object)e.toString()));
            return false;
        }
        return super.performOk();
    }

    protected abstract LicensePolicyData.AbstractData getSubData(LicensePolicyData var1);

    protected void updateLatestData(LicensePolicyData latestData) {
        LicensePolicyData.AbstractData subData = this.getSubData(this.data);
        LicensePolicyData.AbstractData latestSubData = this.getSubData(latestData);
        LicensePolicyData.AbstractData[] children = subData.getChildren();
        latestSubData.removeAllChildren();
        int i = 0;
        while (i < children.length) {
            latestSubData.addChild(children[i]);
            ++i;
        }
    }

    private LicensePolicyData getLicensePolicyData() {
        LicensePolicyDataParser parser = new LicensePolicyDataParser();
        parser.parse(PolicyManager.getLicensePolicyFilePath());
        return parser.getLicensePolicyData();
    }
}

