/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.internal.commands.IParseMessageFormatter;
import com.ibm.cic.agent.core.internal.commands.InputParser;
import com.ibm.cic.agent.core.internal.commands.MissingRequiredAttrException;
import com.ibm.cic.agent.core.internal.commands.XMLRule;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.history.impl.ActivityImpl;
import com.ibm.cic.agent.internal.core.history.impl.FeatureInfoImpl;
import com.ibm.cic.agent.internal.core.history.impl.IXMLElement;
import com.ibm.cic.agent.internal.core.history.impl.OfferingInfoImpl;
import com.ibm.cic.agent.internal.core.history.impl.XMLElement;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class HistoryParser
extends DefaultHandler
implements IParseMessageFormatter {
    private static ServiceTracker xmlTracker = null;
    private final BundleContext context;
    private final Stack ruleStack = new Stack();
    private XMLRule currentRule;
    private final Stack elementStack = new Stack();
    private IXMLElement currentElement;
    private int currentLineNum;
    private int currentColNum;
    private static final Logger log = Logger.getLogger(InputParser.class, (Plugin)AgentActivator.getDefault());

    public static SAXParserFactory acquireXMLParsing(BundleContext context) {
        if (xmlTracker == null) {
            xmlTracker = new ServiceTracker(context, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        return (SAXParserFactory)xmlTracker.getService();
    }

    public static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    public HistoryParser(BundleContext context) {
        this.context = context;
    }

    public IXMLElement parse(InputStream input, XMLRule rule) throws IOException, SAXException, ParserConfigurationException {
        this.currentRule = rule;
        this.getParser().parse(input, (DefaultHandler)this);
        if (!this.currentElement.isEmpty()) {
            return this.currentElement.getChild(0);
        }
        return null;
    }

    public IXMLElement parse(File file, XMLRule rule) throws IOException, SAXException, ParserConfigurationException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file.getCanonicalFile()));
        try {
            IXMLElement iXMLElement = this.parse(input, rule);
            return iXMLElement;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
        }
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = HistoryParser.acquireXMLParsing(this.context);
        if (factory == null) {
            throw new SAXException(Messages.InputParser_No_SAX_Parser_Found);
        }
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/string-interning", true);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    @Override
    public void startDocument() {
        this.currentElement = new XMLElement(this.currentRule.getElementName());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.ruleStack.push(this.currentRule);
        this.elementStack.push(this.currentElement);
        try {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            this.currentRule = this.currentRule.validateChildElement(localName, attrs, status, this);
            if (!status.isOK()) {
                log.status((IStatus)status);
            }
        }
        catch (MissingRequiredAttrException e) {
            throw new SAXException(NLS.bind((String)Messages.HeadlessApplication_Missing_Required_Attribute, (Object)e.getAttribute()));
        }
        this.currentElement = this.createElement(this.currentElement, this.currentRule, localName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.currentRule.isValidElementName(localName)) {
            throw new SAXException(NLS.bind((String)Messages.InputParser_Unexpected_EndOfElement, (Object[])new Object[]{localName, this.currentLineNum, this.currentColNum}));
        }
        this.currentRule = (XMLRule)this.ruleStack.pop();
        this.currentElement = (IXMLElement)this.elementStack.pop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.currentLineNum = locator.getLineNumber();
        this.currentColNum = locator.getColumnNumber();
    }

    private IXMLElement createElement(IXMLElement parentElement, XMLRule rule, String elmName, Attributes attrs) {
        IXMLElement element = this.createElement(rule, elmName);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                element.addAttribute(attrs.getLocalName(i), attrs.getValue(i));
                ++i;
            }
        }
        parentElement.addChild(element);
        return element;
    }

    private IXMLElement createElement(XMLRule rule, String elmName) {
        XMLElement element;
        int elementId = rule.getId();
        switch (elementId) {
            case 2: {
                element = new ActivityImpl(0);
                break;
            }
            case 3: {
                element = new ActivityImpl(1);
                break;
            }
            case 4: {
                element = new OfferingInfoImpl();
                break;
            }
            case 5: {
                element = new FeatureInfoImpl();
                break;
            }
            case 7: {
                element = new ActivityImpl(3);
                break;
            }
            case 8: {
                element = new ActivityImpl(2);
                break;
            }
            default: {
                element = new XMLElement(elmName);
            }
        }
        return element;
    }

    @Override
    public String formatMessage(String msg) {
        return msg;
    }
}

