/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.agent.internal.core.history.ProfileIdentity;
import com.ibm.cic.agent.internal.core.history.impl.HistoryUtil;
import com.ibm.cic.agent.internal.core.history.impl.ProfileInfoImpl;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class HistoryIndex {
    private static final String FILENAME_HISTORY = "history.xml";
    private Map historyIndex = null;
    private final File historyDirectory;
    private boolean isDirty = false;

    public HistoryIndex(File historyDirectory) {
        this.historyDirectory = historyDirectory;
    }

    private List<File> readIndexXml(File indexFile) {
        if (!indexFile.exists()) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = XMLUtil.createDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(indexFile);
            document.getDocumentElement().normalize();
            Element histories = document.getDocumentElement();
            NodeList profileList = histories.getElementsByTagName("profile");
            ArrayList<File> historyFiles = new ArrayList<File>();
            int i = 0;
            while (i < profileList.getLength()) {
                Node profileElement = profileList.item(i);
                String historyPath = profileElement.getTextContent();
                File file = new File(indexFile.getParentFile(), historyPath);
                if (!file.exists()) {
                    file = new File(historyPath);
                }
                historyFiles.add(file);
                ++i;
            }
            return historyFiles;
        }
        catch (Exception e) {
            Agent.getLogger().status((IStatus)Statuses.WARNING.get((Throwable)e, Messages.FileLog_Error_Reading, new Object[]{indexFile, e.getMessage()}));
            return null;
        }
    }

    public void load() {
        this.historyIndex = new HashMap();
        File indexXml = new File(this.historyDirectory, "index.xml");
        List<File> historyFilesFromIndex = this.readIndexXml(indexXml);
        if (historyFilesFromIndex != null) {
            for (File historyFile : historyFilesFromIndex) {
                if (!historyFile.exists()) continue;
                ProfileIdentity profileIdentity = new ProfileIdentity(new File(historyFile.getParent()).getName());
                ProfileInfoImpl profileInfo = new ProfileInfoImpl(profileIdentity, historyFile);
                this.historyIndex.put(profileIdentity, profileInfo);
            }
        }
    }

    public IProfileInfo getProfileInfo(ProfileIdentity profileIdentity) {
        if (this.historyIndex == null) {
            this.load();
        }
        return (IProfileInfo)this.historyIndex.get(profileIdentity);
    }

    public void addProfileInfo(ProfileIdentity profileIdentity, IProfileInfo profileInfo) {
        if (this.historyIndex == null) {
            this.load();
        }
        this.historyIndex.put(profileIdentity, profileInfo);
    }

    public Iterator getAllProfileInfos() {
        if (this.historyIndex == null) {
            this.load();
        }
        return this.historyIndex.values().iterator();
    }

    public IProfileInfo createProfileInfo(Profile profile) {
        ProfileIdentity profileIdentity = new ProfileIdentity(profile);
        File historyFile = new File(profile.getHistoryStorage(), String.valueOf(profileIdentity.getProfileId()) + File.separator + FILENAME_HISTORY);
        ProfileInfoImpl profileInfo = new ProfileInfoImpl(profileIdentity, historyFile);
        this.addProfileInfo(profileIdentity, profileInfo);
        this.isDirty = true;
        return profileInfo;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void save(File historyIndexDir) {
        this.isDirty = false;
        if (!historyIndexDir.exists()) {
            historyIndexDir.mkdirs();
        }
        HistoryUtil.createXSLFile(historyIndexDir, "history_index.xsl");
        File indexFile = new File(historyIndexDir, "index.xml");
        try (FileOutputStream fos = new FileOutputStream(indexFile);){
            PrintWriter pw = new PrintWriter(Encodings.UTF8.writer((OutputStream)fos));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            pw.println("<?xml-stylesheet type=\"text/xsl\" href=\"history_index.xsl\"?>");
            pw.println("<histories>");
            String historyIndexDirPath = historyIndexDir.getCanonicalPath();
            Iterator iterator = this.getAllProfileInfos();
            while (iterator.hasNext()) {
                IProfileInfo profileInfo = (IProfileInfo)iterator.next();
                String historyFilePath = profileInfo.getHistoryFilePath();
                if (historyFilePath.startsWith(historyIndexDirPath) && historyFilePath.length() > historyIndexDirPath.length()) {
                    historyFilePath = PathUtil.forwardSlashify((String)historyFilePath.substring(historyIndexDirPath.length() + 1));
                }
                pw.println(NLS.bind((String)"<profile id=\"{0}\">{1}</profile>", (Object)profileInfo.getProfileIdentity().getProfileId(), (Object)historyFilePath));
            }
            pw.println("</histories>");
            pw.close();
        }
        catch (IOException e) {
            Agent.getLogger().status((IStatus)Statuses.WARNING.get((Throwable)e, Messages.FileLog_Error_Writing, new Object[]{indexFile, e.getMessage()}));
        }
    }

    public void moveProfile(String oldProfileId, String newProfileId, File newHistoryStorage) {
        if (this.historyIndex == null) {
            this.load();
        }
        ProfileIdentity oldProfileIdentity = null;
        IProfileInfo oldProfileInfo = null;
        for (Map.Entry entry : this.historyIndex.entrySet()) {
            ProfileIdentity profileIdentity = (ProfileIdentity)entry.getKey();
            IProfileInfo profileInfo = (IProfileInfo)entry.getValue();
            String profileId = profileIdentity.getProfileId();
            if (!oldProfileId.equals(profileId)) continue;
            oldProfileIdentity = profileIdentity;
            oldProfileInfo = profileInfo;
            break;
        }
        if (oldProfileIdentity != null && oldProfileInfo != null) {
            File newDir;
            File oldDir = new File(oldProfileInfo.getHistoryFilePath()).getParentFile();
            if (oldDir.equals(newDir = new File(newHistoryStorage != null ? newHistoryStorage : oldDir.getParentFile(), newProfileId))) {
                return;
            }
            this.historyIndex.remove(oldProfileIdentity);
            oldProfileIdentity.profileId = newProfileId;
            oldProfileInfo.setHistoryFile(new File(newDir, FILENAME_HISTORY));
            this.historyIndex.put(oldProfileIdentity, oldProfileInfo);
            this.isDirty = true;
            try {
                if (oldDir.isDirectory()) {
                    IStatus status;
                    if (newHistoryStorage != null && !(status = FileUtil.makeDirectories((File)newHistoryStorage)).isOK()) {
                        Agent.getLogger().status(status);
                    }
                    FileUtil.copyDir((File)oldDir, (File)newDir, (IProgressMonitor)new NullProgressMonitor());
                    FileUtil.rm_r((File)oldDir, (boolean)true);
                }
            }
            catch (IOException e) {
                Agent.getLogger().error((Throwable)e);
            }
        }
        if (this.isDirty) {
            this.save(this.historyDirectory);
        }
    }
}

