/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.ProfileRegistry;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SimpleProfileRegistry
implements ProfileRegistry {
    private final LinkedHashMap profiles = new LinkedHashMap(8);
    private final LinkedProperties properties = new LinkedProperties();

    public String toString() {
        return this.profiles.toString();
    }

    @Override
    public Profile getProfile(String id) {
        return (Profile)this.profiles.get(id);
    }

    @Override
    public Profile getProfileByInstallLocation(String installLocation) {
        for (Profile profile : this.profiles.values()) {
            if (!FileUtil.filesAreSame((String)profile.getInstallLocation(), (String)installLocation)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public List getProfilesByOfferingOrFixId(String offeringId) {
        ArrayList<Profile> return_value = new ArrayList<Profile>();
        for (Profile profile : this.profiles.values()) {
            IFix[] fixes;
            if (profile.findOffering(offeringId) != null) {
                return_value.add(profile);
                continue;
            }
            IFix[] iFixArray = fixes = profile.getInstalledFixes();
            int n = fixes.length;
            int n2 = 0;
            while (n2 < n) {
                IFix fix = iFixArray[n2];
                if (fix.getIdentity().getId().equals(offeringId)) {
                    return_value.add(profile);
                }
                ++n2;
            }
        }
        return return_value;
    }

    @Override
    public Profile[] getProfiles() {
        return this.profiles.values().toArray(new Profile[this.profiles.size()]);
    }

    @Override
    public void addProfile(Profile toAdd) throws IllegalArgumentException {
        String id = toAdd.getProfileId();
        if (this.getProfile(id) != null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Duplicate_Profile_Id, (Object)id));
        }
        this.profiles.put(id, toAdd);
    }

    @Override
    public void removeProfile(Profile toRemove) {
        this.profiles.remove(toRemove.getProfileId());
    }

    @Override
    public LinkedProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public IStatus setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return Status.OK_STATUS;
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove((Object)key);
    }
}

