/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKeyUtil;
import com.ibm.cic.common.core.model.internal.CICWriter;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.IXMLProcessor;
import com.ibm.cic.common.xml.core.model.IXMLElementVisitor;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;
import org.xml.sax.InputSource;

public class MetadataReplacer {
    private static final Logger log = Logger.getLogger(MetadataReplacer.class);
    private static final String METADATA_REPLACED_BY_UNIT = "metadata.replaced.by.unit";
    private static final String MATCH_HASH = "matchHash";
    private static final String MATCH_OLD_HASH = "matchOldHash";
    private static final String OPTION_PREFIX = ";";
    private static final String MATCH_HASH_OPTION = ";matchHash";
    private static final String MATCH_OLD_HASH_OPTION = ";matchOldHash";
    private final IUReplacementsMap metadataReplacements = new IUReplacementsMap();
    private static final Map<String, String> KNOWN_MATCH_OLD_HASH_IUS;

    static {
        HashMap<String, String> knownIUs = new HashMap<String, String>();
        knownIUs.put("replace.metadata.matching.hash.test2..replace.metadata.matching.hash.test2.win32_iu_999.999.999.-54029263", "-119464271");
        knownIUs.put("replace.metadata.matching.hash.test2..replace.metadata.matching.hash.test2_iu_999.999.999.-1877901740", "1621846228");
        knownIUs.put("replace.metadata.matching.hash.test3..replace.metadata.matching.hash.test3_iu2_999.999.999.391357084", "-2057172576");
        knownIUs.put("ClearCaseAlbdServer-CINSTALLDIR..ClearCaseAlbdServer-C-Albd.iu_999.999.999.1958640253", "927583359");
        knownIUs.put("com.ibm.rational.cmserver..com.ibm.rational.cmserver.deploy.teamEar.common.iu_999.999.999.-187614420", "-383358300");
        knownIUs.put("com.ibm.rational.cmserver..com.ibm.rational.cmserver.deploy.teamEar.common.iu_999.999.999.-2075742121", "1907253199");
        knownIUs.put("com.ibm.rational.cmserver..com.ibm.rational.cmserver.deploy.teamEar.common.iu_999.999.999.1734118208", "1422146232");
        KNOWN_MATCH_OLD_HASH_IUS = Collections.unmodifiableMap(knownIUs);
    }

    public void replace(CicMultiStatus status, InstallContextTree root, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{4, 1, 6});
        List trees = root.getFullTree();
        try {
            List metadataReplacementPairs = this.extractMetadataReplacementPairs(trees, spm.next());
            this.prepareMetadataReplacements(status, metadataReplacementPairs, spm.next());
            if (status.isOK()) {
                this.performMetadataReplacements(status, trees, spm.next());
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    public String toString() {
        return this.metadataReplacements.toString();
    }

    public static String computeHash(IInstallableUnit unit) {
        return MetadataReplacer.computeHash(unit, null);
    }

    private List extractMetadataReplacementPairs(List trees, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        monitor.subTask(Messages.MetadataReplacer_extractMetadataReplacementPairs);
        ArrayList metadataReplacementPairs = new ArrayList();
        for (InstallContextTree tree : trees) {
            this.extractMetadataReplacementPairs(tree, metadataReplacementPairs);
        }
        monitor.worked(1);
        monitor.done();
        return metadataReplacementPairs;
    }

    private void extractMetadataReplacementPairs(InstallContextTree tree, List metadataReplacementPairs) {
        InstallableUnitPair.List pairs = tree.getPairs();
        Iterator iter = pairs.iterator();
        while (iter.hasNext()) {
            InstallableUnitPair pair = (InstallableUnitPair)iter.next();
            if (this.getReplaceMetadataProperty(pair.getFrom()) == null && this.getReplaceMetadataProperty(pair.getTo()) == null) continue;
            metadataReplacementPairs.add(pair);
            iter.remove();
        }
    }

    private void prepareMetadataReplacements(CicMultiStatus status, List metadataReplacementPairs, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        monitor.subTask(Messages.MetadataReplacer_prepareMetadataReplacements);
        if (!metadataReplacementPairs.isEmpty()) {
            for (InstallableUnitPair pair : metadataReplacementPairs) {
                this.prepareMetadataReplacements(status, pair);
            }
            this.performFurtherValidations(status);
            this.logMetadataReplacements();
        }
        monitor.worked(1);
        monitor.done();
    }

    private void prepareMetadataReplacements(CicMultiStatus status, InstallableUnitPair pair) {
        IUReplacement replacement = null;
        if (pair.isIdentical() || pair.isInstall()) {
            IInstallableUnit unit = pair.getTo();
            replacement = this.prepareMetadataReplacement(status, unit);
        } else if (pair.isUninstall()) {
            IInstallableUnit unit = pair.getFrom();
            replacement = this.prepareMetadataReplacement(status, unit);
        } else {
            IInstallableUnit fromUnit = pair.getFrom();
            IUReplacement fromReplacement = this.prepareMetadataReplacement(status, fromUnit);
            IInstallableUnit toUnit = pair.getTo();
            IUReplacement toReplacement = this.prepareMetadataReplacement(status, toUnit);
            if (fromReplacement != null && toReplacement != null) {
                if (!fromReplacement.getIuId().equals(toReplacement.getIuId())) {
                    this.addMismatchedIuIdError(status, fromUnit, toUnit);
                } else if (!fromReplacement.getIuVersion().equals((Object)toReplacement.getIuVersion())) {
                    this.addMismatchedIuVersionError(status, fromUnit, toUnit);
                } else {
                    replacement = pair.isUpdate() ? toReplacement : fromReplacement;
                }
            } else if (fromReplacement != null || toReplacement != null) {
                this.addMissingPropertyError(status, fromUnit, toUnit);
            }
        }
        if (replacement != null) {
            this.putReplacement(status, replacement);
        }
    }

    private IUReplacement prepareMetadataReplacement(CicMultiStatus status, IInstallableUnit unit) {
        String iuIdAndVersionText;
        String value = this.getReplaceMetadataProperty(unit);
        if (value == null) {
            return null;
        }
        boolean matchHash = false;
        boolean matchOldHash = false;
        if (value.endsWith(MATCH_HASH_OPTION)) {
            iuIdAndVersionText = value.substring(0, value.length() - MATCH_HASH_OPTION.length());
            matchHash = true;
        } else if (value.endsWith(MATCH_OLD_HASH_OPTION)) {
            iuIdAndVersionText = value.substring(0, value.length() - MATCH_OLD_HASH_OPTION.length());
            matchOldHash = true;
        } else {
            iuIdAndVersionText = value;
        }
        Object[] iuIdAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)iuIdAndVersionText);
        if (iuIdAndVersion[1] == null) {
            this.addInvalidPropertyError(status, unit, value);
            return null;
        }
        Version iuVersion = (Version)iuIdAndVersion[1];
        String iuId = (String)iuIdAndVersion[0];
        if (iuId.equals(unit.getIdentity().getId())) {
            this.addSelfReferenceError(status, unit, value);
            return null;
        }
        String hashValueToMatch = this.getHashValueToMatchProperty(unit);
        IInstallableUnitContainer su = unit.getParent();
        String suId = su.getIdentity().getId();
        if (matchOldHash) {
            String qualifiedVersionedId = IdentityUtil.createQualifiedId((String)suId, (String)iuIdAndVersionText);
            String expectedHash = KNOWN_MATCH_OLD_HASH_IUS.get(qualifiedVersionedId);
            if (expectedHash != null) {
                hashValueToMatch = expectedHash;
                matchHash = true;
            } else {
                this.addUnexpectedOldHashError(status, unit, qualifiedVersionedId);
                matchHash = true;
                hashValueToMatch = "00000000";
            }
        }
        return new IUReplacement(suId, iuId, iuVersion, unit, matchHash, hashValueToMatch);
    }

    private void performFurtherValidations(CicMultiStatus status) {
        if (this.metadataReplacements.isEmpty()) {
            return;
        }
        List allReplacements = this.metadataReplacements.values();
        for (IUReplacement curReplacement : allReplacements) {
            IInstallableUnit curReplacementUnit = curReplacement.getReplacement();
            IUReplacement replacement = this.metadataReplacements.get(curReplacementUnit);
            if (replacement == null) continue;
            this.addReplacingMetadataReplacementError(status, replacement, curReplacementUnit);
        }
    }

    private void logMetadataReplacements() {
        if (log.isDebugLoggable()) {
            log.debug(this.toString());
        }
    }

    private void performMetadataReplacements(CicMultiStatus status, List trees, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        monitor.subTask(Messages.MetadataReplacer_performMetadataReplacements);
        for (InstallContextTree tree : trees) {
            this.performMetadataReplacements(status, tree);
        }
        monitor.worked(1);
        monitor.done();
    }

    private void performMetadataReplacements(CicMultiStatus status, InstallContextTree tree) {
        InstallableUnitPair.List pairs = tree.getPairs();
        for (InstallableUnitPair pair : pairs) {
            this.performMetadataReplacements(status, pair);
        }
    }

    private void performMetadataReplacements(CicMultiStatus status, InstallableUnitPair pair) {
        IInstallableUnit toUnit;
        IInstallableUnit toReplacement;
        IInstallableUnit fromUnit = pair.getFrom();
        IInstallableUnit fromReplacement = this.createMetadataReplacement(status, fromUnit);
        if (fromReplacement != null) {
            pair.setFrom(fromReplacement);
        }
        if ((toReplacement = this.createMetadataReplacement(status, toUnit = pair.getTo())) != null) {
            pair.setTo(toReplacement);
        }
    }

    private IInstallableUnit createMetadataReplacement(CicMultiStatus status, IInstallableUnit unit) {
        boolean matchedByHash;
        String hash;
        IInstallableUnit result;
        if (unit == null) {
            return null;
        }
        IUReplacement iuReplacement = this.metadataReplacements.get(unit);
        if (iuReplacement == null) {
            return null;
        }
        IInstallableUnit replacement = iuReplacement.getReplacement();
        try {
            result = (IInstallableUnit)replacement.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
            return null;
        }
        result.setParent(unit.getParent());
        result.setIdentity(unit.getIdentity());
        result.setVersion(unit.getVersion());
        LinkedProperties properties = result.getProperties();
        properties.remove((Object)"replace.metadata");
        String replacementVersionedId = IdentityUtil.getQualifiedVersionedId((IInstallableUnit)replacement);
        properties.setProperty(METADATA_REPLACED_BY_UNIT, replacementVersionedId);
        boolean versionMatches = iuReplacement.getIuVersion().equals((Object)unit.getVersion());
        if (versionMatches && iuReplacement.matchHash() && !MetadataReplacer.hashMatches(iuReplacement, hash = MetadataReplacer.computeHash(iuReplacement, unit))) {
            this.addHashDiffersError(status, unit, iuReplacement, hash);
            return null;
        }
        boolean bl = matchedByHash = iuReplacement.matchHash() && !versionMatches;
        if (!this.sameArtifacts(unit, result, matchedByHash)) {
            this.addArtifactsDifferError(status, unit, replacement);
            return null;
        }
        if (matchedByHash && !result.getAdapterData().setArtifacts(unit.getAdapterData())) {
            this.addError(status, "metadata replacement failed", new Object[0]);
        }
        if (log.isDebugLoggable()) {
            String unitVersionedId = IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit);
            log.debug(Messages.MetadataReplacer_metadataReplacedByUnit, new Object[]{unitVersionedId, replacementVersionedId});
        }
        return result;
    }

    private boolean sameArtifacts(IInstallableUnit unit, IInstallableUnit createdReplacement, boolean matchedByHash) {
        Collection artifacts = unit.getAdapterData().getArtifacts();
        Collection replacementArtifacts = createdReplacement.getAdapterData().getArtifacts();
        if (artifacts.size() != replacementArtifacts.size()) {
            return false;
        }
        Iterator i = artifacts.iterator();
        Iterator j = replacementArtifacts.iterator();
        while (i.hasNext()) {
            IArtifact artifact = (IArtifact)i.next();
            IArtifact replacementArtifact = (IArtifact)j.next();
            if (matchedByHash ? !ArtifactKeyUtil.isSameArtifactIgnoreVersion((IArtifact)artifact, (IArtifact)replacementArtifact) : !artifact.getKey().equals(replacementArtifact.getKey())) {
                return false;
            }
            if (artifact.getClass().equals(replacementArtifact.getClass())) continue;
            return false;
        }
        return true;
    }

    private String getReplaceMetadataProperty(IInstallableUnit unit) {
        if (unit == null) {
            return null;
        }
        String value = unit.getProperties().getProperty("replace.metadata");
        return value;
    }

    private String getHashValueToMatchProperty(IInstallableUnit unit) {
        if (unit == null) {
            return null;
        }
        String value = unit.getProperties().getProperty("hash.value.to.match");
        return value;
    }

    private void putReplacement(CicMultiStatus status, IUReplacement replacement) {
        IUReplacement previousReplacement = this.metadataReplacements.put(replacement);
        if (previousReplacement != null && !previousReplacement.equals(replacement)) {
            IInstallableUnit currentUnit = replacement.getReplacement();
            IInstallableUnit previousUnit = previousReplacement.getReplacement();
            Version currentVersion = currentUnit.getParent().getVersion();
            Version previousVersion = previousUnit.getParent().getVersion();
            int cmp = previousVersion.compareTo(currentVersion);
            if (cmp == 0) {
                this.addMultipleMetadataReplacementsError(status, previousUnit, currentUnit);
            } else if (cmp > 0) {
                this.metadataReplacements.put(previousReplacement);
            }
        }
    }

    private static String computeHash(IUReplacement iuReplacement, IInstallableUnit iu) {
        IAdapterData replacementData = null;
        if (!iuReplacement.getIuVersion().equals((Object)iu.getVersion())) {
            IInstallableUnit replacement = iuReplacement.getReplacement();
            replacementData = replacement.getAdapterData();
        }
        return MetadataReplacer.computeHash(iu, replacementData);
    }

    private static String computeHash(IInstallableUnit iu, IAdapterData replacementData) {
        IInstallableUnit adjustedIu;
        try {
            adjustedIu = (IInstallableUnit)iu.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
            return "";
        }
        adjustedIu.setVersion(null);
        if (replacementData != null && !adjustedIu.getAdapterData().setArtifacts(replacementData)) {
            return "";
        }
        CICWriter writer = new CICWriter();
        String xml = CICWriter.toXML((CICWriter)writer, (IContent)adjustedIu);
        IXMLProcessor processor = CicXMLCore.getDefault().getXMLProcessor();
        try {
            processor.process(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        IXMLModel root = processor.getRoot();
        if (root.getChildCount() != 1) {
            log.error("hashMatches: xml processor failed to parse IU in the following xml:\n" + xml);
            return "";
        }
        IXMLTextModelItem iuElement = root.getChildren()[0];
        HashPrep prep = new HashPrep();
        iuElement.visit((IXMLElementVisitor)prep);
        String hash = CicXMLCore.getDefault().getHash(iuElement);
        return hash != null ? hash : "";
    }

    private static boolean hashMatches(IUReplacement iuReplacement, IInstallableUnit iu) {
        String hash = MetadataReplacer.computeHash(iuReplacement, iu);
        return MetadataReplacer.hashMatches(iuReplacement, hash);
    }

    private static boolean hashMatches(IUReplacement iuReplacement, String hash) {
        String expectedHash = iuReplacement.getExpectedHash();
        return hash.equals(expectedHash);
    }

    private void addError(CicMultiStatus status, String msg, Object ... bindings) {
        ICicStatus errorStatus = Statuses.ERROR.get(msg, bindings);
        this.addError(status, (IStatus)errorStatus, msg, bindings);
    }

    private CicMultiStatus addMultiStatusError(CicMultiStatus status, String message, Object ... args) {
        CicMultiStatus errorStatus = Statuses.ERROR.getMultiStatus(message, args);
        this.addError(status, (IStatus)errorStatus, message, args);
        return errorStatus;
    }

    private void addError(CicMultiStatus status, IStatus errorStatus, String msg, Object ... bindings) {
        status.add(errorStatus);
        if (log.isDebugLoggable()) {
            log.error(msg, bindings);
        }
    }

    private void addInvalidPropertyError(CicMultiStatus status, IInstallableUnit unit, String value) {
        this.addError(status, Messages.MetadataReplacer_invalidProperty, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit), "replace.metadata", value);
    }

    private void addMismatchedIuIdError(CicMultiStatus status, IInstallableUnit fromUnit, IInstallableUnit toUnit) {
        String fromProp = this.getReplaceMetadataProperty(fromUnit);
        String toProp = this.getReplaceMetadataProperty(toUnit);
        this.addError(status, Messages.MetadataReplacer_mismatchedIuId, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)fromUnit), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)toUnit), "replace.metadata", fromProp, toProp);
    }

    private void addMismatchedIuVersionError(CicMultiStatus status, IInstallableUnit fromUnit, IInstallableUnit toUnit) {
        String fromProp = this.getReplaceMetadataProperty(fromUnit);
        String toProp = this.getReplaceMetadataProperty(toUnit);
        this.addError(status, Messages.MetadataReplacer_mismatchedIuVersion, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)fromUnit), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)toUnit), "replace.metadata", fromProp, toProp);
    }

    private void addMissingPropertyError(CicMultiStatus status, IInstallableUnit fromUnit, IInstallableUnit toUnit) {
        this.addError(status, Messages.MetadataReplacer_missingProperty, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)fromUnit), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)toUnit), "replace.metadata");
    }

    private void addMultipleMetadataReplacementsError(CicMultiStatus status, IInstallableUnit previousUnit, IInstallableUnit currentUnit) {
        String previousProp = this.getReplaceMetadataProperty(previousUnit);
        String currentProp = this.getReplaceMetadataProperty(currentUnit);
        this.addError(status, Messages.MetadataReplacer_multipleMetadataReplacements, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)previousUnit), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)currentUnit), "replace.metadata", previousProp, currentProp);
    }

    private void addHashDiffersError(CicMultiStatus status, IInstallableUnit unit, IUReplacement iuReplacement, String recomputedHash) {
        IInstallableUnit replacement = iuReplacement.getReplacement();
        CicMultiStatus errorStatus = this.addMultiStatusError(status, Messages.MetadataReplacer_hashDiffers, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)replacement), "replace.metadata", this.getReplaceMetadataProperty(replacement), recomputedHash, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit), iuReplacement.getExpectedHash());
        this.addHashDiffersPossibleExplanation2(errorStatus, recomputedHash);
    }

    private void addUnexpectedOldHashError(CicMultiStatus status, IInstallableUnit unit, String qualifiedVersionId) {
        log.error(Messages.MetadataReplacer_unexpectedOldHash, new Object[]{IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit), qualifiedVersionId});
    }

    private void addHashDiffersPossibleExplanation2(CicMultiStatus status, String recomputedHash) {
        this.addError(status, Messages.MetadataReplacer_hashDiffersPossibleExplanation2, recomputedHash, "hash.value.to.match");
    }

    private void addArtifactsDifferError(CicMultiStatus status, IInstallableUnit unit, IInstallableUnit replacement) {
        this.addError(status, Messages.MetadataReplacer_artifactsDiffer, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)replacement), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit));
    }

    private void addReplacingMetadataReplacementError(CicMultiStatus status, IUReplacement replacement, IInstallableUnit unit) {
        IInstallableUnit replacementUnit = replacement.getReplacement();
        this.addError(status, Messages.MetadataReplacer_replacingMetadataReplacement, "replace.metadata", IdentityUtil.getQualifiedVersionedId((IInstallableUnit)replacementUnit), IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit));
    }

    private void addSelfReferenceError(CicMultiStatus status, IInstallableUnit unit, String value) {
        this.addError(status, Messages.MetadataReplacer_selfReference, IdentityUtil.getQualifiedVersionedId((IInstallableUnit)unit), "replace.metadata", value);
    }

    private static class HashPrep
    implements IXMLElementVisitor {
        private static final String ZIP_ELEMENT_NAME = "zip";
        private static final String ARTIFACT_ELEMENT_NAME = "artifact";
        private static final String ARTIFACT_DOWNLOAD_SIZE = "downloadSize";
        private static final String ARTIFACT_INSTALL_SIZE = "installSize";

        private HashPrep() {
        }

        public boolean visit(IXMLTextModelItem item) {
            if (ZIP_ELEMENT_NAME.equals(item.getName()) || ARTIFACT_ELEMENT_NAME.equals(item.getName())) {
                item.removeAttribute(ARTIFACT_DOWNLOAD_SIZE);
                item.removeAttribute(ARTIFACT_INSTALL_SIZE);
            }
            return true;
        }
    }

    private static class IUReplacement
    implements Comparable {
        private final String suId;
        private final String iuId;
        private final Version iuVersion;
        private final IInstallableUnit replacement;
        private final boolean matchHash;
        private final String hashValueToMatch;

        public IUReplacement(String suId, String iuId, Version iuVersion, IInstallableUnit replacement, boolean matchHash, String hashValueToMatch) {
            this.suId = suId;
            this.iuId = iuId;
            this.iuVersion = iuVersion;
            this.replacement = replacement;
            this.matchHash = matchHash;
            this.hashValueToMatch = hashValueToMatch;
        }

        public String getSuId() {
            return this.suId;
        }

        public String getIuId() {
            return this.iuId;
        }

        public Version getIuVersion() {
            return this.iuVersion;
        }

        public IInstallableUnit getReplacement() {
            return this.replacement;
        }

        public boolean matchHash() {
            return this.matchHash;
        }

        public String getHashValueToMatch() {
            return this.hashValueToMatch;
        }

        public String getExpectedHash() {
            String expectedHash = this.getHashValueToMatch();
            if (expectedHash == null) {
                expectedHash = this.getIuVersion().getQualifier();
            }
            return expectedHash;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof IUReplacement)) {
                return false;
            }
            IUReplacement that = (IUReplacement)obj;
            return this.replacement.equals(that.replacement);
        }

        public int hashCode() {
            return this.replacement.hashCode();
        }

        public int compareTo(Object obj) {
            IUReplacement that = (IUReplacement)obj;
            int cmp = this.suId.compareTo(that.suId);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.iuId.compareTo(that.iuId);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.iuVersion.compareTo(that.iuVersion);
            return cmp;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("IUReplacement(");
            sb.append("suId=\"").append(this.suId).append('\"');
            sb.append(", iuId=\"").append(this.iuId).append('\"');
            sb.append(", iuVersion=\"").append(this.iuVersion).append('\"');
            String versionedId = IdentityUtil.getVersionedId((IContent)this.replacement);
            sb.append(", replacement=\"").append(versionedId).append('\"');
            if (this.matchHash) {
                sb.append(", matchHash=true");
            }
            if (this.hashValueToMatch != null) {
                sb.append(", hashValueToMatch=\"").append(this.hashValueToMatch).append('\"');
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class IUReplacementsMap {
        private final Map metadataReplacements = new HashMap();
        private int metadataReplacementsCount = 0;

        private IUReplacementsMap() {
        }

        public IUReplacement put(IUReplacement replacement) {
            Version iuVersion;
            IUReplacement previousReplacement;
            String iuId;
            IUVersionMap iuVersionMap;
            String suId = replacement.getSuId();
            HashMap<String, IUVersionMap> iuIdMap = (HashMap<String, IUVersionMap>)this.metadataReplacements.get(suId);
            if (iuIdMap == null) {
                iuIdMap = new HashMap<String, IUVersionMap>();
                this.metadataReplacements.put(suId, iuIdMap);
            }
            if ((iuVersionMap = (IUVersionMap)iuIdMap.get(iuId = replacement.getIuId())) == null) {
                iuVersionMap = new IUVersionMap();
                iuIdMap.put(iuId, iuVersionMap);
            }
            if ((previousReplacement = iuVersionMap.put(iuVersion = replacement.getIuVersion(), replacement)) == null) {
                ++this.metadataReplacementsCount;
            }
            return previousReplacement;
        }

        public IUReplacement get(IInstallableUnit iu) {
            IInstallableUnitContainer su = iu.getParent();
            String suId = su.getIdentity().getId();
            Map iuIdMap = (Map)this.metadataReplacements.get(suId);
            if (iuIdMap == null) {
                return null;
            }
            String iuId = iu.getIdentity().getId();
            IUVersionMap iuVersionMap = (IUVersionMap)iuIdMap.get(iuId);
            if (iuVersionMap == null) {
                return null;
            }
            Version iuVersion = iu.getVersion();
            IUReplacement replacement2 = (IUReplacement)iuVersionMap.get(iuVersion);
            if (replacement2 != null) {
                return replacement2;
            }
            if (!iuVersionMap.hasMatchHashReplacement()) {
                return null;
            }
            Collection replacements = iuVersionMap.values();
            for (IUReplacement replacement2 : replacements) {
                if (!replacement2.matchHash() || !MetadataReplacer.hashMatches(replacement2, iu)) continue;
                return replacement2;
            }
            return null;
        }

        public List values() {
            ArrayList result = new ArrayList(this.metadataReplacementsCount);
            Collection iuIdMaps = this.metadataReplacements.values();
            for (Map iuIdMap : iuIdMaps) {
                Collection iuVersionMaps = iuIdMap.values();
                for (Map iuVersionMap : iuVersionMaps) {
                    result.addAll(iuVersionMap.values());
                }
            }
            return result;
        }

        public int size() {
            return this.metadataReplacementsCount;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "No metadata replacements";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Metadata replacements:\n");
            List allReplacements = this.values();
            Collections.sort(allReplacements);
            for (IUReplacement replacement : allReplacements) {
                sb.append("  ").append(replacement).append('\n');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }

    private static class IUVersionMap
    extends HashMap {
        private boolean hasMatchHashReplacement = false;

        private IUVersionMap() {
        }

        public boolean hasMatchHashReplacement() {
            return this.hasMatchHashReplacement;
        }

        @Override
        public IUReplacement put(Version version, IUReplacement replacement) {
            if (replacement.matchHash()) {
                this.hasMatchHashReplacement = true;
            }
            return super.put(version, replacement);
        }
    }
}

