/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.common.commonNativeAdapterData.PropertyAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InstallContextPropertyOperation
extends AbstractInstallOperation {
    private static final String SCOPE_DELIMITER = ":";
    private static final String AGENT_SCOPE = "agent";
    private static final String PROFILE_SCOPE = "profile";
    private static final String CONTEXT_SCOPE = "context";
    private static final String SYSTEM_SCOPE = "system";
    private static final String KLUDGE_STRING = "ConfigDir";
    private final PropertyAdapterData data;

    public InstallContextPropertyOperation(int phase, IInstallableUnit unit, InstallContext context, String key, String value) {
        super(phase, unit, context);
        this.data = new PropertyAdapterData(key, value);
    }

    @Override
    protected CommonAdapterData getData() {
        return this.data;
    }

    @Override
    protected IStatus doPerform(IProgressMonitor monitor) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String key;
        String name = this.data.getPropertyName();
        String value = this.data.getPropertyValue();
        int delim = name.indexOf(SCOPE_DELIMITER);
        String keyScope = delim > 0 ? name.substring(0, delim) : CONTEXT_SCOPE;
        String string = key = delim > 0 ? name.substring(delim + 1) : name;
        if (AGENT_SCOPE.equals(keyScope)) {
            InstallRegistry.getInstance().setProperty(key, this.performVariableSubstitutions(value));
        } else if (PROFILE_SCOPE.equals(keyScope)) {
            this.getProfile().setData(key, this.performVariableSubstitutions(value));
        } else if (SYSTEM_SCOPE.equals(keyScope)) {
            System.setProperty(key, this.performVariableSubstitutions(value));
        } else if (CONTEXT_SCOPE.equals(keyScope)) {
            InstallContext context = this.getInstallContext();
            context.setLocalProperty(key, this.performVariableSubstitutions(value));
            if (KLUDGE_STRING.equals(key) && context.getProperty("configLocation") == null) {
                context.setLocalProperty("configLocation", this.performVariableSubstitutions(value));
            }
        }
        return Status.OK_STATUS;
    }
}

