/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AgentInstallPathCheck {
    public static final String WIN_INVALID_CHARACTERS = "[`!@#$%^&,{}\\[\\]]|((^|[^ ])\\()";
    public static final String UNIX_INVALID_CHARACTERS = "[`!@#$%^&*|\\\\:\"?><,{}\\[\\]()]";

    public static IStatus validate(String agentInstallPath) {
        String regex = CicCommonSettings.isWindows() ? WIN_INVALID_CHARACTERS : UNIX_INVALID_CHARACTERS;
        Matcher matcher = Pattern.compile(regex).matcher(agentInstallPath);
        if (matcher.find()) {
            String userAction;
            String explanation;
            String uid;
            String message;
            if (CicCommonSettings.isWindows()) {
                message = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Windows;
                uid = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Windows$uid;
                explanation = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Windows$explanation;
                userAction = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Windows$useraction;
            } else {
                message = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Unix;
                uid = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Unix$uid;
                explanation = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Unix$explanation;
                userAction = Messages.Agent_Profile_Install_Location_Unsupported_Chars_Unix$useraction;
            }
            if (!CmdLine.CL.isSilentMode() && !CmdLine.CL.isConsoleMode()) {
                explanation = AgentInstallPathCheck.escapeXml(explanation);
            }
            return Statuses.createStatus((String)ComIbmCicCommonCorePlugin.getPluginId(), (int)2, (int)0, (String)uid, (String)explanation, (String)userAction, null, (String)message, (Object[])new Object[0]);
        }
        return Status.OK_STATUS;
    }

    private static String escapeXml(String orig) {
        return orig.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

