/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.utils;

import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.CredentialStore;
import com.ibm.cic.common.downloads.CredentialTarget;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SaveCredentialPrompter
implements ICredentialPrompter {
    private final String uid;
    private final String uPwd;
    private final String proxyUid;
    private final String proxyUPwd;
    private final ArrayList savedTargets = new ArrayList(2);

    public SaveCredentialPrompter(String uid, String uPwd, String proxyUid, String proxyUPwd) {
        this.uid = uid;
        this.uPwd = uPwd;
        this.proxyUid = proxyUid;
        this.proxyUPwd = proxyUPwd;
    }

    private int getSavedTargetIndex(CredentialTarget target) {
        int i = 0;
        while (i < this.savedTargets.size()) {
            SavedTarget savedTarget = (SavedTarget)this.savedTargets.get(i);
            if (savedTarget.ct.equals((Object)target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addSavedTarget(CredentialTarget target, String id) {
        int i = this.getSavedTargetIndex(target);
        if (i < 0) {
            this.savedTargets.add(new SavedTarget(target, id));
        }
    }

    private void removeSavedTarget(CredentialTarget target) {
        int i = this.getSavedTargetIndex(target);
        if (i >= 0) {
            this.savedTargets.remove(i);
        }
    }

    public boolean hasSavedTarget() {
        return this.savedTargets.size() > 0;
    }

    public String getSavedTargetsString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.savedTargets.size()) {
            SavedTarget savedTarget = (SavedTarget)this.savedTargets.get(i);
            buf.append(NLS.bind((String)Messages.SaveCredential_Credential, (Object[])new Object[]{savedTarget.ct.getRealm(), savedTarget.ct.getAuthScheme(), savedTarget.id}));
            if (i < this.savedTargets.size() - 1) {
                buf.append("\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public boolean checkTargets() {
        int i = 0;
        while (i < this.savedTargets.size()) {
            SavedTarget savedTarget = (SavedTarget)this.savedTargets.get(i);
            if (!CredentialStore.INSTANCE.isCredentialInKeyring(savedTarget.ct)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous, CredentialInfo[] ret) {
        CredentialInfo tempCredentialInfo = new CredentialInfo();
        tempCredentialInfo.setPersist(true);
        String tempUid = null;
        String tempUPwd = null;
        if (requested.isProxy().booleanValue()) {
            if (this.proxyUid == null || this.proxyUPwd == null) {
                System.out.println(Messages.SaveCredential_Error_NoProxyCredential);
                return Status.CANCEL_STATUS;
            }
            tempUid = this.proxyUid;
            tempUPwd = this.proxyUPwd;
        } else {
            tempUid = this.uid;
            tempUPwd = this.uPwd;
        }
        tempCredentialInfo.setUid(tempUid);
        tempCredentialInfo.setPwd(tempUPwd);
        IStatus status = validator.validate(tempCredentialInfo);
        if (status.matches(4)) {
            return status;
        }
        ret[0] = tempCredentialInfo;
        CredentialTarget ct = CredentialTarget.makeFromRequest((CredentialRequested)requested);
        if (previous.isSomething() && previous.getUid().equals(tempUid) && previous.getPwd().equals(tempUPwd)) {
            this.removeSavedTarget(ct);
            return Status.CANCEL_STATUS;
        }
        this.addSavedTarget(ct, tempUid);
        return Status.OK_STATUS;
    }

    private static class SavedTarget {
        protected CredentialTarget ct = null;
        protected String id = null;

        public SavedTarget(CredentialTarget ct, String id) {
            this.ct = ct;
            this.id = id;
        }
    }
}

